/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.conditions;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.config.RecipeControlConfig;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class BoolConfigCondition
implements ICondition {
    public static final ResourceLocation ID = ModRef.res("recipe_control.bool");
    private final List<String> path;
    private final boolean expected;

    public BoolConfigCondition(ForgeConfigSpec.BooleanValue config, boolean expected) {
        this.path = config.getPath();
        this.expected = expected;
    }

    public BoolConfigCondition(String path, boolean expected) {
        this.path = Lists.newArrayList((Object[])path.split("\\."));
        this.expected = expected;
    }

    public boolean test(ICondition.IContext context) {
        return (Boolean)((ForgeConfigSpec.BooleanValue)RecipeControlConfig.SPEC.getValues().get(this.path)).get() == this.expected;
    }

    public ResourceLocation getID() {
        return ID;
    }

    public static class Serializer
    implements IConditionSerializer<BoolConfigCondition> {
        public static final ResourceLocation ID = ModRef.res("recipe_control.bool");

        public void write(JsonObject json, BoolConfigCondition condition) {
            json.addProperty("path", String.join((CharSequence)".", condition.path));
            json.addProperty("expected", Boolean.valueOf(condition.expected));
        }

        public BoolConfigCondition read(JsonObject json) {
            String path = json.get("path").getAsString();
            boolean value = json.get("expected").getAsBoolean();
            return new BoolConfigCondition(path, value);
        }

        public ResourceLocation getID() {
            return ID;
        }
    }
}

