/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.community.event;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.community.CommunityPack;
import com.alaharranhonor.swem.forge.community.content.tack.RawTackData;
import com.alaharranhonor.swem.forge.util.ClientUtil;
import com.alaharranhonor.swem.forge.util.SingleTextureSprite;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.math.Transformation;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import net.minecraftforge.client.textures.ForgeTextureMetadata;
import net.minecraftforge.client.textures.UnitTextureAtlasSprite;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="swem", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommunityClientModEvents {
    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        for (CommunityPack pack : ModRef.COMMUNITY_MANAGER.getPacks()) {
            for (ResourceLocation coatTexture : pack.getCoats().texturesToLoad) {
                ClientUtil.loadTexture(pack.getTexturesPath().resolve("coats"), coatTexture);
            }
            for (RawTackData tackData : pack.getTack().getContent()) {
                for (ResourceLocation texturePath : tackData.rackTextures.values()) {
                    ClientUtil.loadTexture(pack.getTack().getTexturePath(), texturePath);
                }
                for (ResourceLocation texturePath : tackData.horseTextures.values()) {
                    ClientUtil.loadTexture(pack.getTack().getTexturePath(), texturePath);
                }
            }
        }
    }

    @SubscribeEvent
    public static void bakeModels(ModelEvent.ModifyBakingResult event) throws IOException {
        for (CommunityPack pack : ModRef.COMMUNITY_MANAGER.getPacks()) {
            for (RawTackData tackData : pack.getTack().getContent()) {
                ModelResourceLocation modelName = new ModelResourceLocation(tackData.id, "inventory");
                event.getModels().put(modelName, CommunityClientModEvents.bakeItemModel(event.getModelBakery(), tackData.id, pack.getTack().getTexturePath(), tackData.iconPath));
            }
        }
    }

    private static BakedModel bakeItemModel(ModelBakery bakery, ResourceLocation id, Path texturePath, ResourceLocation texture) {
        NativeImage img = ClientUtil.loadTexture(texturePath, texture);
        if (img == null) {
            return null;
        }
        SpriteContents spriteContents = new SpriteContents(id, new FrameSize(16, 16), img, AnimationMetadataSection.f_119012_, ForgeTextureMetadata.EMPTY);
        SingleTextureSprite sprite = new SingleTextureSprite(texture, spriteContents, 8, 8, 4, 4);
        HashMap map = Maps.newHashMap();
        map.put(Direction.SOUTH, new BlockElementFace(null, 0, "layer0", new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0)));
        map.put(Direction.NORTH, new BlockElementFace(null, 0, "layer0", new BlockFaceUV(new float[]{16.0f, 0.0f, 0.0f, 16.0f}, 0)));
        ArrayList list = Lists.newArrayList();
        list.add(new BlockElement(new Vector3f(0.0f, 0.0f, 8.0f), new Vector3f(16.0f, 16.0f, 8.0f), (Map)map, null, true));
        IModelBuilder builder = IModelBuilder.of((boolean)false, (boolean)false, (boolean)true, (ItemTransforms)new ItemTransforms(new ItemTransform(new Vector3f(), new Vector3f(0.0f, 3.0f, 1.0f).mul(0.0625f), new Vector3f(0.55f, 0.55f, 0.55f)), new ItemTransform(new Vector3f(), new Vector3f(0.0f, 3.0f, 1.0f).mul(0.0625f), new Vector3f(0.55f, 0.55f, 0.55f)), new ItemTransform(new Vector3f(0.0f, -90.0f, 25.0f), new Vector3f(1.13f, 3.2f, 1.13f).mul(0.0625f), new Vector3f(0.68f, 0.68f, 0.68f)), new ItemTransform(new Vector3f(0.0f, -90.0f, 25.0f), new Vector3f(1.13f, 3.2f, 1.13f).mul(0.0625f), new Vector3f(0.68f, 0.68f, 0.68f)), new ItemTransform(new Vector3f(0.0f, 180.0f, 0.0f), new Vector3f(0.0f, 13.0f, 7.0f).mul(0.0625f), new Vector3f(1.0f)), new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(), new Vector3f(1.0f)), new ItemTransform(new Vector3f(), new Vector3f(0.0f, 2.0f, 0.0f).mul(0.0625f), new Vector3f(0.5f)), new ItemTransform(new Vector3f(0.0f, 180.0f, 0.0f), new Vector3f(), new Vector3f(1.0f)), ImmutableMap.of()), (ItemOverrides)ItemOverrides.f_111734_, (TextureAtlasSprite)UnitTextureAtlasSprite.INSTANCE, (RenderTypeGroup)new RenderTypeGroup(RenderType.m_110466_(), RenderType.m_110473_((ResourceLocation)texture), RenderType.m_110473_((ResourceLocation)texture)));
        UnbakedGeometryHelper.bakeElements((IModelBuilder)builder, (List)list, material -> sprite, (ModelState)new SimpleModelState(new Transformation(null, null, null, null), false), (ResourceLocation)id);
        return builder.build();
    }
}

