/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.community;

import com.alaharranhonor.swem.forge.community.content.tack.RawTackData;
import com.alaharranhonor.swem.forge.community.content.tack.type.BridleTypeData;
import com.alaharranhonor.swem.forge.community.content.tack.type.GirthStrapTypeData;
import com.alaharranhonor.swem.forge.community.content.tack.type.HorseArmorTypeData;
import com.alaharranhonor.swem.forge.community.content.tack.type.PastureBlanketTypeData;
import com.alaharranhonor.swem.forge.community.content.tack.type.SaddleTypeData;
import com.alaharranhonor.swem.forge.community.content.tack.type.TackTypeData;
import com.alaharranhonor.swem.forge.items.tack.SaddlebagItem;
import com.alaharranhonor.swem.forge.items.tack.TackItem;
import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public enum TackType {
    HALTER("halter", TackTypeData::new),
    BRIDLE("bridle", BridleTypeData::new),
    BLANKET("blanket", TackTypeData::new),
    SADDLE("saddle", SaddleTypeData::new),
    GIRTH_STRAP("girth_strap", GirthStrapTypeData::new),
    BREAST_COLLAR("breast_collar", TackTypeData::new),
    LEG_WRAPS("leg_wraps", TackTypeData::new),
    PASTURE_BLANKET("pasture_blanket", PastureBlanketTypeData::new),
    SADDLE_BAG("saddle_bag", TackTypeData::new),
    HORSE_ARMOR("horse_armor", HorseArmorTypeData::new);

    private final String name;
    private final Function<JsonObject, TackTypeData> dataParser;

    private TackType(String name, Function<JsonObject, TackTypeData> dataParser) {
        this.name = name;
        this.dataParser = dataParser;
    }

    public static TackType fromName(String name) {
        for (TackType type : TackType.values()) {
            if (!type.name.equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    public TackTypeData defaultData() {
        return this.dataParser.apply(new JsonObject());
    }

    public TackTypeData parseData(JsonObject data) {
        return this.dataParser.apply(data);
    }

    public TackItem createItem(RawTackData tackData) {
        if (this == SADDLE_BAG) {
            return new SaddlebagItem(tackData.getTackDefinition(), new Item.Properties().m_41487_(16));
        }
        return new TackItem(tackData.getTackDefinition(), new Item.Properties().m_41487_(64));
    }

    public boolean is(ItemStack stack) {
        TackItem tack;
        Item item = stack.m_41720_();
        return item instanceof TackItem && (tack = (TackItem)item).getType() == this;
    }
}

