/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.commands;

import com.alaharranhonor.swem.forge.commands.HorseGenderSubCommands;
import com.alaharranhonor.swem.forge.data.HorseDataElement;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.GodBehavior;
import com.alaharranhonor.swem.forge.eventhandlers.CommonEventHandler;
import com.alaharranhonor.swem.forge.keys.Keys;
import com.alaharranhonor.swem.forge.network.protocol.SWEMPackets;
import com.alaharranhonor.swem.forge.network.protocol.game.SHorseFriendPacket;
import com.alaharranhonor.swem.forge.registry.ItemSetup;
import com.alaharranhonor.swem.forge.util.PermissionNodes;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PacketDistributor;

public class HorseSubCommands {
    public static LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"horse").then(HorseGenderSubCommands.build())).then(Commands.m_82127_((String)"addfriend").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> HorseSubCommands.addFriendToHorse((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_(), EntityArgument.m_91474_((CommandContext)ctx, (String)"player")))))).then(Commands.m_82127_((String)"removefriend").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> HorseSubCommands.removeFriendFromHorse((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_(), EntityArgument.m_91474_((CommandContext)ctx, (String)"player")))))).then(Commands.m_82127_((String)"transfer").then(Commands.m_82129_((String)"profile", (ArgumentType)GameProfileArgument.m_94584_()).executes(ctx -> HorseSubCommands.transferHorse((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_(), GameProfileArgument.m_94590_((CommandContext)ctx, (String)"profile")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"tackup").executes(ctx -> HorseSubCommands.tackUp((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_(), false))).then(Commands.m_82127_((String)"adventure").executes(context -> HorseSubCommands.tackUp((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_(), true))))).then(Commands.m_82127_((String)"tame").executes(ctx -> HorseSubCommands.tame((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_())))).then(Commands.m_82127_((String)"immortal").executes(ctx -> HorseSubCommands.immortal((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"dismount").requires(src -> Keys.hasPermission(src, PermissionNodes.CAN_TRANSFER))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> HorseSubCommands.dismountRider((CommandSourceStack)ctx.getSource(), (Player)EntityArgument.m_91474_((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"owned").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"list").executes(ctx -> HorseSubCommands.listOwnedHorses((CommandSourceStack)ctx.getSource(), (Player)((CommandSourceStack)ctx.getSource()).m_81375_()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)GameProfileArgument.m_94584_()).requires(src -> Keys.hasPermission(src, PermissionNodes.CAN_ACCESS))).executes(ctx -> HorseSubCommands.listOwnedHorses((CommandSourceStack)ctx.getSource(), GameProfileArgument.m_94590_((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"search").requires(src -> Keys.hasPermission(src, PermissionNodes.CAN_ACCESS))).then(Commands.m_82129_((String)"limit", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> HorseSubCommands.searchOwnedHorsesOutsideLimit((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"limit"))))));
    }

    public static int searchOwnedHorsesOutsideLimit(CommandSourceStack src, int limit) {
        Collection<HorseDataElement> horses = CommonEventHandler.getHorseDataManager().getAllData();
        HashMap<UUID, Integer> playerHorseCount = new HashMap<UUID, Integer>();
        for (HorseDataElement data : horses) {
            if (data.getOwnerId() == null) continue;
            if (!playerHorseCount.containsKey(data.getOwnerId())) {
                playerHorseCount.put(data.getOwnerId(), 0);
            }
            playerHorseCount.put(data.getOwnerId(), (Integer)playerHorseCount.get(data.getOwnerId()) + 1);
        }
        playerHorseCount.values().removeIf(count -> count <= limit);
        if (playerHorseCount.size() == 0) {
            src.m_288197_(() -> Component.m_237113_((String)"There are no players above the limit."), false);
            return 0;
        }
        StringBuilder text = new StringBuilder().append("There are ").append(playerHorseCount.size()).append(" players who own more that the limit of ").append(limit).append(".");
        for (Map.Entry entry : playerHorseCount.entrySet()) {
            Optional optionalProfile = src.m_81377_().m_129927_().m_11002_((UUID)entry.getKey());
            optionalProfile.ifPresent(profile -> text.append("\n - ").append(profile.getName()).append(" [").append(entry.getValue()).append("]"));
        }
        src.m_288197_(() -> Component.m_237113_((String)text.toString()), false);
        return playerHorseCount.size();
    }

    public static int listOwnedHorses(CommandSourceStack src, Player player) {
        return HorseSubCommands.listOwnedHorses(src, player.m_36316_());
    }

    public static int listOwnedHorses(CommandSourceStack src, Collection<GameProfile> profiles) {
        if (profiles.size() != 1) {
            src.m_81352_((Component)Component.m_237113_((String)"Must target only one player"));
            return 0;
        }
        return HorseSubCommands.listOwnedHorses(src, profiles.iterator().next());
    }

    public static int listOwnedHorses(CommandSourceStack src, GameProfile profile) {
        List<HorseDataElement> belongingHorses = CommonEventHandler.getHorseDataManager().getHorsesBelongingTo(profile.getId());
        if (belongingHorses.isEmpty()) {
            src.m_288197_(() -> Component.m_237113_((String)(profile.getName() + " does not own any horses.")), false);
            return 0;
        }
        StringBuilder text = new StringBuilder(profile.getName()).append(" owns ").append(belongingHorses.size()).append(" horse/s.");
        List<HorseDataElement> namedHorses = belongingHorses.stream().filter(data -> data.getName() != null).toList();
        if (!namedHorses.isEmpty()) {
            text.append("\nOf which named:");
            for (HorseDataElement horseData : namedHorses) {
                text.append("\n - ").append(horseData.getName());
            }
        }
        src.m_288197_(() -> Component.m_237113_((String)text.toString()), false);
        return belongingHorses.size();
    }

    public static int addFriendToHorse(CommandSourceStack src, ServerPlayer player, ServerPlayer friend) {
        Entity mount = player.m_20202_();
        if (!(mount instanceof SWEMHorseEntityBase)) {
            src.m_81352_((Component)Component.m_237113_((String)"You must be on a SWEM horse."));
            return 0;
        }
        SWEMHorseEntityBase horse = (SWEMHorseEntityBase)mount;
        if (!HorseSubCommands.isOwner(horse, player) && !Keys.hasPermission(src, PermissionNodes.CAN_FRIEND)) {
            src.m_81352_((Component)Component.m_237113_((String)"You are not the owner of this horse."));
            return 0;
        }
        horse.addAllowedUUID(friend.m_20148_());
        SWEMPackets.sendToPlayers(PacketDistributor.TRACKING_ENTITY.with(() -> horse), new SHorseFriendPacket(friend.m_20148_(), horse.m_19879_(), 1));
        src.m_288197_(() -> Component.m_237113_((String)("You have added " + friend.m_5446_().getString() + " to your allowed list, on " + mount.m_5446_().getString() + ".")), false);
        return 1;
    }

    public static int removeFriendFromHorse(CommandSourceStack src, ServerPlayer player, ServerPlayer friend) {
        Entity mount = player.m_20202_();
        if (!(mount instanceof SWEMHorseEntityBase)) {
            src.m_81352_((Component)Component.m_237113_((String)"You must be on a SWEM horse."));
            return 0;
        }
        SWEMHorseEntityBase horse = (SWEMHorseEntityBase)mount;
        if (!HorseSubCommands.isOwner(horse, player) && !Keys.hasPermission(src, PermissionNodes.CAN_FRIEND)) {
            src.m_81352_((Component)Component.m_237113_((String)"You are not the owner of this horse."));
            return 0;
        }
        horse.removeAllowedUUID(friend.m_20148_());
        SWEMPackets.sendToPlayers(PacketDistributor.TRACKING_ENTITY.with(() -> horse), new SHorseFriendPacket(friend.m_20148_(), horse.m_19879_(), 2));
        src.m_288197_(() -> Component.m_237113_((String)("You have removed " + friend.m_5446_().getString() + " from your allowed list, on " + mount.m_5446_().getString() + ".")), false);
        return 1;
    }

    public static int transferHorse(CommandSourceStack src, ServerPlayer player, Collection<GameProfile> targets) {
        Entity mount = player.m_20202_();
        if (!(mount instanceof SWEMHorseEntityBase)) {
            src.m_81352_((Component)Component.m_237113_((String)"You must be on a SWEM horse."));
            return 0;
        }
        SWEMHorseEntityBase horse = (SWEMHorseEntityBase)mount;
        if (!HorseSubCommands.isOwner(horse, player) && !Keys.hasPermission(src, PermissionNodes.CAN_TRANSFER)) {
            src.m_81352_((Component)Component.m_237113_((String)"You are not the owner of this horse."));
            return 0;
        }
        if (targets.isEmpty()) {
            src.m_81352_((Component)Component.m_237113_((String)"Player does not exist."));
            return 0;
        }
        GameProfile target = targets.iterator().next();
        horse.m_20153_();
        horse.transferHorse(target);
        SWEMPackets.sendToPlayers(PacketDistributor.TRACKING_ENTITY.with(() -> horse), new SHorseFriendPacket(UUID.randomUUID(), horse.m_19879_(), 3));
        src.m_288197_(() -> Component.m_237113_((String)("You have transferred " + mount.m_5446_().getString() + " to " + target.getName() + ".")), false);
        return 1;
    }

    public static int dismountRider(CommandSourceStack src, Player rider) {
        if (!Keys.hasPermission(src, PermissionNodes.CAN_DISMOUNT)) {
            src.m_81352_((Component)Component.m_237113_((String)"You are not permitted to dismount riders."));
            return 0;
        }
        rider.m_8127_();
        rider.m_5661_((Component)Component.m_237115_((String)"command.swem.horse.dismount.dismounted"), false);
        src.m_288197_(() -> Component.m_237113_((String)(rider.m_5446_().getString() + " has been dismounted.")), true);
        return 1;
    }

    public static int immortal(CommandSourceStack src, ServerPlayer player) {
        if (!Keys.hasPermission(src, PermissionNodes.CAN_MODIFY)) {
            src.m_81352_((Component)Component.m_237113_((String)"You do not have permission to do that."));
            return 0;
        }
        Entity mount = player.m_20202_();
        if (!(mount instanceof SWEMHorseEntityBase)) {
            src.m_81352_((Component)Component.m_237113_((String)"You must be on a SWEM horse."));
            return 0;
        }
        SWEMHorseEntityBase horse = (SWEMHorseEntityBase)mount;
        GodBehavior behavior = horse.getBehavior(GodBehavior.class);
        behavior.setGod(!behavior.isGod());
        boolean isNowGod = behavior.isGod();
        src.m_288197_(() -> Component.m_237110_((String)"commands.horse.immortal", (Object[])new Object[]{horse.m_5446_(), isNowGod ? "immortal" : "mortal"}), true);
        return 1;
    }

    public static int tame(CommandSourceStack src, ServerPlayer player) {
        if (!Keys.hasPermission(src, PermissionNodes.CAN_TAME)) {
            src.m_81352_((Component)Component.m_237113_((String)"You do not have permission to do that."));
            return 0;
        }
        List list = player.m_9236_().m_45976_(SWEMHorseEntityBase.class, new AABB(player.m_20182_().f_82479_ - 10.0, player.m_20182_().f_82480_ - 10.0, player.m_20182_().f_82481_ - 10.0, (double)player.m_20183_().m_123341_() + 10.0, (double)player.m_20183_().m_123342_() + 10.0, (double)player.m_20183_().m_123343_() + 10.0));
        for (SWEMHorseEntityBase horse : list) {
            if (horse == null || horse.m_30614_()) continue;
            horse.tameWithName(player.m_36316_());
        }
        src.m_288197_(() -> Component.m_237113_((String)"Your horse has been tamed for you sir! (With the accent)"), false);
        return 1;
    }

    public static int tackUp(CommandSourceStack src, ServerPlayer player, boolean adventureTack) {
        Entity mount = player.m_20202_();
        if (!(mount instanceof SWEMHorseEntityBase)) {
            src.m_81352_((Component)Component.m_237113_((String)"You must be on a SWEM horse."));
            return 0;
        }
        SWEMHorseEntityBase horse = (SWEMHorseEntityBase)mount;
        if (!Keys.hasPermission(src, PermissionNodes.CAN_TACKUP)) {
            src.m_81352_((Component)Component.m_237113_((String)"You do not have permission to do that."));
            return 0;
        }
        if (adventureTack) {
            horse.insertAndSyncItem(0, new ItemStack((ItemLike)ItemSetup.ADVENTURE_BRIDLE.get()));
            horse.insertAndSyncItem(1, new ItemStack((ItemLike)ItemSetup.ADVENTURE_BLANKET.get()));
            horse.insertAndSyncItem(2, new ItemStack((ItemLike)ItemSetup.ADVENTURE_SADDLE_WITHERED.get()));
            horse.insertAndSyncItem(3, new ItemStack((ItemLike)ItemSetup.ADVENTURE_BREAST_COLLAR.get()));
            horse.insertAndSyncItem(4, new ItemStack((ItemLike)ItemSetup.ADVENTURE_LEG_WRAPS.get()));
            horse.insertAndSyncItem(5, new ItemStack((ItemLike)ItemSetup.ADVENTURE_GIRTH_STRAP.get()));
            horse.insertAndSyncItem(6, new ItemStack((ItemLike)ItemSetup.AMETHYST_HORSE_ARMOR.get()));
        } else {
            horse.insertAndSyncItem(0, new ItemStack((ItemLike)ItemSetup.WESTERN_BRIDLES.get(0).get()));
            horse.insertAndSyncItem(1, new ItemStack((ItemLike)ItemSetup.WESTERN_BLANKETS.get(0).get()));
            horse.insertAndSyncItem(2, new ItemStack((ItemLike)ItemSetup.WESTERN_SADDLES.get(0).get()));
            horse.insertAndSyncItem(5, new ItemStack((ItemLike)ItemSetup.WESTERN_GIRTH_STRAPS.get(0).get()));
        }
        src.m_288197_(() -> Component.m_237113_((String)"Your horse has been tacked up sir! (With the accent)"), false);
        return 1;
    }

    private static boolean isOwner(SWEMHorseEntityBase horse, ServerPlayer player) {
        return player.m_20148_().equals(horse.m_21805_());
    }
}

