/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.client.render;

import com.alaharranhonor.swem.forge.blocks.LeadAnchorBlock;
import com.alaharranhonor.swem.forge.client.SWEMRenderTypes;
import com.alaharranhonor.swem.forge.client.model.ModelBoneType;
import com.alaharranhonor.swem.forge.client.model.SWEMHorseModel;
import com.alaharranhonor.swem.forge.community.content.tack.type.BridleTypeData;
import com.alaharranhonor.swem.forge.community.content.tack.type.SaddleTypeData;
import com.alaharranhonor.swem.forge.config.ClientConfig;
import com.alaharranhonor.swem.forge.config.ServerConfig;
import com.alaharranhonor.swem.forge.entities.horse.HorseModelType;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntity;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.coats.HorseCoat;
import com.alaharranhonor.swem.forge.items.tack.HorseArmorTier;
import com.alaharranhonor.swem.forge.items.tack.TackItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.DynamicGeoEntityRenderer;

public class SWEMHorseRenderer
extends DynamicGeoEntityRenderer<SWEMHorseEntity> {
    private static final String[] ADVENTURE_SADDLE_BONE_NAMES = new String[]{"AdventureSaddle", "AdventureSaddleMiddle", "AdventureSaddleLeftSide", "AdventureSaddleRightSide"};
    private static final String[] ENGLISH_SADDLE_BONE_NAMES = new String[]{"EnglishSaddle", "EnglishSaddleMiddle", "EnglishSaddleLeftSide", "EnglishSaddleRightSide"};
    private static final String[] WESTERN_SADDLE_BONE_NAMES = new String[]{"WesternSaddle", "WesternSaddleMiddle", "WesternSaddleLeftSide", "WesternSaddleRightSide"};
    private static final String[] WESTERN_BRIDLE_BONE_NAMES = new String[]{"WesternBridle", "WesternBridleLeftBit", "WesternBridleRightBit"};
    private static final String[] WESTERN_BRIDLE_REIN_BONE_NAMES = new String[]{"WesternBridleLeftRein", "WesternBridleLeftRein1", "WesternBridleLeftRein2", "WesternBridleRightRein", "WesternBridleRightRein1", "WesternBridleRightRein2"};
    private static final String[] ENGLISH_BRIDLE_BONE_NAMES = new String[]{"EnglishBridle", "EnglishBridleLeftBit", "EnglishBridleRightBit"};
    private static final String[] ENGLISH_BRIDLE_REIN_BONE_NAMES = new String[]{"EnglishBridleLeftRein", "EnglishBridleLeftRein1", "EnglishBridleLeftRein2", "EnglishBridleRightRein", "EnglishBridleRightRein1", "EnglishBridleRightRein2"};
    private static final String[] ARMOR_BONE_NAMES = new String[]{"ArmorHead", "ArmorHead1", "ArmorNeck", "ArmorNeck1", "ArmorRightShoulder", "ArmorLeftShoulder", "ArmorCloth", "ArmorClothLeft", "ArmorClothRight", "ArmorButt", "ArmorMiddle", "ArmorBaseBack"};
    private static final String[] WING_BONE_NAMES = new String[]{"WingsScapularLeftGROUP", "WingsScapularLeft", "WingsMarginalLeft", "WingsMarginal2Left", "WingsAlulaLeft", "WingsFlightFeathersRight", "WingsScapularRightGROUP", "WingsScapularRight", "WingsMarginalRight", "WingsMarginal2Right", "WingsAlulaRight", "WingsFlightFeathersRight"};
    private static final String[] SADDLE_BAG_AND_BED_ROLL_BONE_NAMES = new String[]{"SaddleBag", "SaddleBagLeft", "SaddleBagRight", "BedRoll"};
    private static final String[] BLANKET_BONE_NAMES = new String[]{"BlanketMiddle", "BlanketBaseBack", "BlanketBaseFront", "BlanketFrontRight", "BlanketFrontLeft", "BlanketConnectionMiddle"};
    private static final String[] PASTURE_BLANKET_BONE_NAMES = new String[]{"PBFrontLeft", "PBMiddle", "PBFrontRight", "PBBack"};
    private static final String[] GIRTH_STRAP_BONE_NAMES = new String[]{"GirthStrapMiddle", "GirthStrapBelly"};
    private static final String[] HALTER_BONE_NAMES = new String[]{"HalterCheeks", "HalterBridgeOfNose", "HalterSkull", "HalterMouth"};
    private static final String[] LEG_WRAPS_BONE_NAMES = new String[]{"LegWrapsSkull", "LegWrapsBridgeOfNose", "LegWrapsEarLeft", "LegWrapsEarRight", "LegWrapsMiddle", "LegWrapsBackRight", "LegWrapsBackLeft", "LegWrapsFrontRight", "LegWrapsFrontLeft"};
    private static final String[] LEG_WRAPS_HOOF_BONE_NAMES = new String[]{"LegWrapsBackRightHoof", "LegWrapsBackLeftHoof", "LegWrapsFrontRightHoof", "LegWrapsFrontLeftHoof"};
    private static final String[] BREAST_COLLAR_BONE_NAMES = new String[]{"BreastCollarBaseBack", "BreastCollarMiddle", "BreastCollarConnectionMiddle", "BreastCollarBelly", "BreastCollarFrontRight", "BreastCollarFrontLeft", "BreastCollarBreastRight", "BreastCollarBreastLeft", "BreastCollarBase"};

    public SWEMHorseRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (GeoModel)new SWEMHorseModel());
    }

    public void render(SWEMHorseEntity entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        List<Entity> leashHolders = entity.getLeashHolders();
        if (leashHolders.size() > 1 && leashHolders.get(0) != null) {
            this.renderLeash((Mob)entity, partialTicks, stack, bufferIn, leashHolders.get(0));
        }
        if (!entity.m_6162_()) {
            this.showBone("Main", entity);
            this.checkArmorForRendering(entity);
            this.checkWingsForRendering(entity);
            this.checkSaddlesForRendering(entity);
            this.checkBridlesForRendering(entity);
            this.checkHalterForRendering(entity);
            this.checkSaddlebagForRendering(entity);
            this.checkBlanketForRendering(entity);
            this.checkGirthStrapForRendering(entity);
            this.checkLegWrapsForRendering(entity);
            this.checkLegWrapsHoofForRendering(entity);
            this.checkBreastCollarForRendering(entity);
            this.checkPastureBlanketForRendering(entity);
        }
        if (entity.m_6162_()) {
            stack.m_85836_();
            float scale = 1.0f + ((float)((Integer)ServerConfig.FOAL_GROW_UP_TIME_IN_SECONDS.get()).intValue() * 20.0f - (float)entity.m_146764_()) / ((float)((Integer)ServerConfig.FOAL_GROW_UP_TIME_IN_SECONDS.get()).intValue() * 20.0f) * 0.25f;
            stack.m_85841_(scale, scale, scale);
        }
        super.m_7392_((Entity)entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
        if (Boolean.parseBoolean(System.getProperty("swem.debug")) && Minecraft.m_91087_().m_91290_().m_114377_()) {
            this.enableDebugRendering(entity, stack);
        }
        if (entity.m_6162_()) {
            stack.m_85849_();
        }
        if (!entity.m_6162_()) {
            this.getGeoModel().getBakedModel(this.getGeoModel().getModelResource((GeoAnimatable)entity)).getBone("main").ifPresent(bone -> bone.setHidden(true));
        }
    }

    private void checkLegWrapsHoofForRendering(SWEMHorseEntity entity) {
        ItemStack legWrapsStack = entity.getLegWraps();
        ItemStack armorStack = entity.getArmor();
        if (!legWrapsStack.m_41619_() || !armorStack.m_41619_()) {
            Arrays.stream(LEG_WRAPS_HOOF_BONE_NAMES).forEach(n -> this.showBone((String)n, entity));
        } else {
            Arrays.stream(LEG_WRAPS_HOOF_BONE_NAMES).forEach(n -> this.hideBone((String)n, entity));
        }
    }

    private void enableDebugRendering(SWEMHorseEntity entity, PoseStack stack) {
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        AABB biteBox = new AABB(new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()), new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_())).m_82363_(0.0, 2.0, 0.0).m_82377_(0.75, 0.0, 0.75).m_82386_(-entity.m_20185_(), -entity.m_20186_(), -entity.m_20189_());
        biteBox = biteBox.m_82386_((double)(entity.m_20205_() * 1.0f) * entity.m_20154_().m_82541_().m_7096_(), 0.0, (double)(entity.m_20205_() * 1.0f) * entity.m_20154_().m_82541_().m_7094_());
        AABB kickBox = new AABB(new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()), new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_())).m_82363_(0.0, 2.0, 0.0).m_82377_(0.75, 0.0, 0.75).m_82386_(-entity.m_20185_(), -entity.m_20186_(), -entity.m_20189_());
        kickBox = kickBox.m_82386_((double)(entity.m_20205_() * 1.0f) * entity.m_20154_().m_82548_().m_82541_().m_7096_(), 0.0, (double)(entity.m_20205_() * 1.0f) * entity.m_20154_().m_82548_().m_82541_().m_7094_());
        AABB stompBox = entity.m_20191_().m_82377_(2.0, 0.0, 2.0).m_82363_(0.0, -1.0, 0.0).m_82386_(-entity.m_20185_(), -entity.m_20186_(), -entity.m_20189_());
        LevelRenderer.m_109646_((PoseStack)stack, (VertexConsumer)buffer.m_6299_(RenderType.m_110504_()), (AABB)biteBox, (float)0.23f, (float)0.78f, (float)0.23f, (float)0.5f);
        LevelRenderer.m_109646_((PoseStack)stack, (VertexConsumer)buffer.m_6299_(RenderType.m_110504_()), (AABB)kickBox, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        LevelRenderer.m_109646_((PoseStack)stack, (VertexConsumer)buffer.m_6299_(RenderType.m_110504_()), (AABB)stompBox, (float)1.0f, (float)0.0f, (float)1.0f, (float)0.5f);
    }

    private void checkPastureBlanketForRendering(SWEMHorseEntity entity) {
        ItemStack stack = entity.getPastureBlanket();
        if (!stack.m_41619_()) {
            Arrays.stream(PASTURE_BLANKET_BONE_NAMES).forEach(boneName -> this.showBone((String)boneName, entity));
            this.hideBone("BreastLeft", entity);
            this.hideBone("BreastRight", entity);
        } else {
            Arrays.stream(PASTURE_BLANKET_BONE_NAMES).forEach(boneName -> this.hideBone((String)boneName, entity));
            this.showBone("BreastLeft", entity);
            this.showBone("BreastRight", entity);
        }
    }

    private void checkHalterForRendering(SWEMHorseEntity entity) {
        ItemStack bridleStack = entity.getHalterOrBridle();
        boolean bridleRenderFlag = (Boolean)entity.m_20088_().m_135370_(SWEMHorseEntityBase.RENDER_BRIDLE);
        if (bridleRenderFlag && !bridleStack.m_41619_()) {
            Arrays.stream(HALTER_BONE_NAMES).forEach(boneName -> this.showBone((String)boneName, entity));
        } else {
            Arrays.stream(HALTER_BONE_NAMES).forEach(boneName -> this.hideBone((String)boneName, entity));
        }
    }

    private void checkSaddlesForRendering(SWEMHorseEntity entity) {
        TackItem tack;
        block7: {
            block6: {
                ItemStack saddleStack = entity.getSaddle();
                boolean shouldRenderSaddle = (Boolean)entity.m_20088_().m_135370_(SWEMHorseEntityBase.RENDER_SADDLE);
                Arrays.stream(ADVENTURE_SADDLE_BONE_NAMES).forEach(n -> this.hideBone((String)n, entity));
                Arrays.stream(ENGLISH_SADDLE_BONE_NAMES).forEach(n -> this.hideBone((String)n, entity));
                Arrays.stream(WESTERN_SADDLE_BONE_NAMES).forEach(n -> this.hideBone((String)n, entity));
                Item item = saddleStack.m_41720_();
                if (!(item instanceof TackItem)) break block6;
                tack = (TackItem)item;
                if (shouldRenderSaddle) break block7;
            }
            return;
        }
        String modelType = ((SaddleTypeData)tack.getData()).getModelType();
        if ("adventure".equalsIgnoreCase(modelType)) {
            Arrays.stream(ADVENTURE_SADDLE_BONE_NAMES).forEach(n -> this.showBone((String)n, entity));
        }
        if ("english".equalsIgnoreCase(modelType)) {
            Arrays.stream(ENGLISH_SADDLE_BONE_NAMES).forEach(n -> this.showBone((String)n, entity));
        }
        if ("western".equalsIgnoreCase(modelType)) {
            Arrays.stream(WESTERN_SADDLE_BONE_NAMES).forEach(n -> this.showBone((String)n, entity));
        }
    }

    private void checkBridlesForRendering(SWEMHorseEntity entity) {
        TackItem tack;
        block8: {
            block7: {
                ItemStack bridleStack = entity.getBridle();
                boolean shouldRenderBridle = (Boolean)entity.m_20088_().m_135370_(SWEMHorseEntityBase.RENDER_BRIDLE);
                Arrays.stream(WESTERN_BRIDLE_BONE_NAMES).forEach(n -> this.hideBone((String)n, entity));
                Arrays.stream(WESTERN_BRIDLE_REIN_BONE_NAMES).forEach(n -> this.hideBone((String)n, entity));
                Arrays.stream(ENGLISH_BRIDLE_BONE_NAMES).forEach(n -> this.hideBone((String)n, entity));
                Arrays.stream(ENGLISH_BRIDLE_REIN_BONE_NAMES).forEach(n -> this.hideBone((String)n, entity));
                Item item = bridleStack.m_41720_();
                if (!(item instanceof TackItem)) break block7;
                tack = (TackItem)item;
                if (shouldRenderBridle) break block8;
            }
            return;
        }
        String modelType = ((BridleTypeData)tack.getData()).getModelType();
        if ("western".equalsIgnoreCase(modelType)) {
            Arrays.stream(WESTERN_BRIDLE_BONE_NAMES).forEach(n -> this.showBone((String)n, entity));
            if (!entity.isBridleLeashed()) {
                Arrays.stream(WESTERN_BRIDLE_REIN_BONE_NAMES).forEach(n -> this.showBone((String)n, entity));
            }
        }
        if ("english".equalsIgnoreCase(modelType)) {
            Arrays.stream(ENGLISH_BRIDLE_BONE_NAMES).forEach(n -> this.showBone((String)n, entity));
            if (!entity.isBridleLeashed()) {
                Arrays.stream(ENGLISH_BRIDLE_REIN_BONE_NAMES).forEach(n -> this.showBone((String)n, entity));
            }
        }
    }

    private void checkWingsForRendering(SWEMHorseEntity horse) {
        HorseArmorTier tier;
        ItemStack armorStack = horse.getArmor();
        HorseCoat coat = horse.getCoatBehavior().coat();
        boolean shouldRenderWings = coat.hasWings();
        if (!shouldRenderWings && !armorStack.m_41619_() && (tier = horse.getArmorTier()) == HorseArmorTier.AMETHYST) {
            shouldRenderWings = true;
        }
        if (shouldRenderWings && (Integer)ClientConfig.WINGS_TRANSPARENCY.get() != 0) {
            Arrays.stream(WING_BONE_NAMES).forEach(n -> this.showBone((String)n, horse));
        } else {
            Arrays.stream(WING_BONE_NAMES).forEach(n -> this.hideBone((String)n, horse));
        }
    }

    private void checkArmorForRendering(SWEMHorseEntity horse) {
        ItemStack armorStack = horse.getArmor();
        if (!armorStack.m_41619_()) {
            HorseArmorTier tier = horse.getArmorTier();
            Arrays.stream(ARMOR_BONE_NAMES).forEach(n -> this.showBone((String)n, horse));
            this.hideBone("BreastLeft", horse);
            this.hideBone("BreastRight", horse);
            if (tier.getTier() >= HorseArmorTier.DIAMOND.getTier()) {
                this.hideBone("Mane", horse);
                this.hideBone("Bang", horse);
            } else {
                this.showBone("Mane", horse);
                this.showBone("Bang", horse);
            }
        } else {
            Arrays.stream(ARMOR_BONE_NAMES).forEach(n -> this.hideBone((String)n, horse));
            this.showBone("Mane", horse);
            this.showBone("Bang", horse);
            this.showBone("BreastLeft", horse);
            this.showBone("BreastRight", horse);
        }
    }

    private void checkSaddlebagForRendering(SWEMHorseEntity entity) {
        ItemStack stack = entity.getSaddleBag();
        if (!stack.m_41619_()) {
            Arrays.stream(SADDLE_BAG_AND_BED_ROLL_BONE_NAMES).forEach(n -> this.showBone((String)n, entity));
        } else {
            Arrays.stream(SADDLE_BAG_AND_BED_ROLL_BONE_NAMES).forEach(n -> this.hideBone((String)n, entity));
        }
    }

    private void checkBlanketForRendering(SWEMHorseEntity entity) {
        ItemStack stack = entity.getBlanket();
        boolean shouldRenderBlanket = (Boolean)entity.m_20088_().m_135370_(SWEMHorseEntityBase.RENDER_BLANKET);
        if (!stack.m_41619_() && shouldRenderBlanket) {
            Arrays.stream(BLANKET_BONE_NAMES).forEach(n -> this.showBone((String)n, entity));
        } else {
            Arrays.stream(BLANKET_BONE_NAMES).forEach(n -> this.hideBone((String)n, entity));
        }
    }

    private void checkGirthStrapForRendering(SWEMHorseEntity entity) {
        ItemStack stack = entity.getGirthStrap();
        boolean shouldRenderGirthStrap = (Boolean)entity.m_20088_().m_135370_(SWEMHorseEntityBase.RENDER_GIRTH_STRAP);
        if (!stack.m_41619_() && shouldRenderGirthStrap) {
            Arrays.stream(GIRTH_STRAP_BONE_NAMES).forEach(n -> this.showBone((String)n, entity));
        } else {
            Arrays.stream(GIRTH_STRAP_BONE_NAMES).forEach(n -> this.hideBone((String)n, entity));
        }
    }

    private void checkLegWrapsForRendering(SWEMHorseEntity entity) {
        ItemStack stack = entity.getLegWraps();
        if (!stack.m_41619_()) {
            Arrays.stream(LEG_WRAPS_BONE_NAMES).forEach(n -> this.showBone((String)n, entity));
        } else {
            Arrays.stream(LEG_WRAPS_BONE_NAMES).forEach(n -> this.hideBone((String)n, entity));
        }
    }

    private void checkBreastCollarForRendering(SWEMHorseEntity entity) {
        ItemStack stack = entity.getBreastCollar();
        if (!stack.m_41619_()) {
            Arrays.stream(BREAST_COLLAR_BONE_NAMES).forEach(n -> this.showBone((String)n, entity));
        } else {
            Arrays.stream(BREAST_COLLAR_BONE_NAMES).forEach(n -> this.hideBone((String)n, entity));
        }
    }

    @Nullable
    protected ResourceLocation getTextureOverrideForBone(GeoBone bone, SWEMHorseEntity horse, float partialTick) {
        ItemStack pastureBlanketStack;
        String boneName = bone.getName();
        if (boneName.equalsIgnoreCase("Main")) {
            return this.getGeoModel().getTextureResource((GeoAnimatable)horse);
        }
        if (boneName.contains(ModelBoneType.BRIDLE.bone)) {
            if (horse.hasBridle()) {
                return TackItem.as(horse.getHalterOrBridle()).getTextureOnHorse(HorseModelType.LEGACY, ModelBoneType.BRIDLE);
            }
        } else if (boneName.contains(ModelBoneType.WINGS.bone)) {
            ItemStack armorStack = horse.getArmor();
            if (!armorStack.m_41619_()) {
                TackItem tack = TackItem.as(armorStack);
                HorseArmorTier tier = horse.getArmorTier();
                if (tier.getTier() >= HorseArmorTier.AMETHYST.getTier()) {
                    return tack.getTextureOnHorse(HorseModelType.LEGACY, ModelBoneType.WINGS);
                }
            }
            if (horse.getCoatBehavior().coat().hasWings()) {
                return horse.getCoatBehavior().coat().modelTexture(HorseModelType.LEGACY);
            }
        } else if (boneName.contains(ModelBoneType.ARMOR.bone)) {
            ItemStack armorStack = horse.getArmor();
            if (!armorStack.m_41619_()) {
                return TackItem.as(armorStack).getTextureOnHorse(HorseModelType.LEGACY, ModelBoneType.ARMOR);
            }
        } else if (boneName.contains(ModelBoneType.SADDLE_BAG.bone) || boneName.contains("BedRoll")) {
            ItemStack stack = horse.getSaddleBag();
            if (!stack.m_41619_()) {
                return TackItem.as(stack).getTextureOnHorse(HorseModelType.LEGACY, ModelBoneType.SADDLE_BAG);
            }
        } else if (boneName.contains(ModelBoneType.HALTER.bone)) {
            ItemStack stack = horse.getHalterOrBridle();
            Item item = stack.m_41720_();
            if (item instanceof TackItem) {
                TackItem tack = (TackItem)item;
                return tack.getTextureOnHorse(HorseModelType.LEGACY, ModelBoneType.HALTER);
            }
        } else if (boneName.contains(ModelBoneType.BLANKET.bone)) {
            ItemStack stack = horse.getBlanket();
            Item item = stack.m_41720_();
            if (item instanceof TackItem) {
                TackItem tack = (TackItem)item;
                return tack.getTextureOnHorse(HorseModelType.LEGACY, ModelBoneType.BLANKET);
            }
        } else if (boneName.contains(ModelBoneType.GIRTH_STRAP.bone)) {
            ItemStack stack = horse.getGirthStrap();
            Item item = stack.m_41720_();
            if (item instanceof TackItem) {
                TackItem tack = (TackItem)item;
                return tack.getTextureOnHorse(HorseModelType.LEGACY, ModelBoneType.GIRTH_STRAP);
            }
        } else if (boneName.contains(ModelBoneType.LEG_WRAPS.bone)) {
            ItemStack armorStack;
            if (boneName.contains(ModelBoneType.HOOF.bone) && !(armorStack = horse.getArmor()).m_41619_()) {
                return TackItem.as(armorStack).getTextureOnHorse(HorseModelType.LEGACY, ModelBoneType.ARMOR);
            }
            ItemStack stack = horse.getLegWraps();
            Item item = stack.m_41720_();
            if (item instanceof TackItem) {
                TackItem tack = (TackItem)item;
                return tack.getTextureOnHorse(HorseModelType.LEGACY, ModelBoneType.LEG_WRAPS);
            }
        } else if (boneName.contains(ModelBoneType.BREAST_COLLAR.bone)) {
            ItemStack stack = horse.getBreastCollar();
            Item item = stack.m_41720_();
            if (item instanceof TackItem) {
                TackItem tack = (TackItem)item;
                return tack.getTextureOnHorse(HorseModelType.LEGACY, ModelBoneType.BREAST_COLLAR);
            }
        } else if (boneName.contains(ModelBoneType.SADDLE.bone)) {
            ItemStack stack = horse.getSaddle();
            Item item = stack.m_41720_();
            if (item instanceof TackItem) {
                TackItem tack = (TackItem)item;
                return tack.getTextureOnHorse(HorseModelType.LEGACY, ModelBoneType.SADDLE);
            }
        } else if (boneName.contains(ModelBoneType.PASTURE_BLANKET.bone) && !(pastureBlanketStack = horse.getPastureBlanket()).m_41619_()) {
            return TackItem.as(pastureBlanketStack).getTextureOnHorse(HorseModelType.LEGACY, ModelBoneType.PASTURE_BLANKET);
        }
        return this.getGeoModel().getTextureResource((GeoAnimatable)horse);
    }

    public void hideBone(String boneName, SWEMHorseEntity entity) {
        this.getGeoModel().getBakedModel(this.getGeoModel().getModelResource((GeoAnimatable)entity)).getBone(boneName).ifPresent(bone -> bone.setHidden(true));
    }

    public void showBone(String boneName, SWEMHorseEntity entity) {
        this.getGeoModel().getBakedModel(this.getGeoModel().getModelResource((GeoAnimatable)entity)).getBone(boneName).ifPresent(bone -> bone.setHidden(false));
    }

    public void renderRecursively(PoseStack poseStack, SWEMHorseEntity animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (Arrays.stream(WING_BONE_NAMES).anyMatch(name -> name.equalsIgnoreCase(bone.getName()))) {
            alpha = (float)((Integer)ClientConfig.WINGS_TRANSPARENCY.get()).intValue() * 0.25f;
        }
        super.renderRecursively(poseStack, (Entity)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public RenderType getRenderType(SWEMHorseEntity animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return SWEMRenderTypes.horseArmor(texture, true);
    }

    public void renderLeash(SWEMHorseEntityBase entity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, LivingEntity leashHolder) {
        int segment;
        double lerpBodyAngle = Mth.m_14179_((float)partialTick, (float)entity.f_20883_, (float)entity.f_20884_) * ((float)Math.PI / 180) + 1.5707964f;
        Vec3 leashOffset = entity.m_7939_();
        double xAngleOffset = Math.cos(lerpBodyAngle) * leashOffset.f_82481_ + Math.sin(lerpBodyAngle) * leashOffset.f_82479_;
        double zAngleOffset = Math.sin(lerpBodyAngle) * leashOffset.f_82481_ - Math.cos(lerpBodyAngle) * leashOffset.f_82479_;
        double lerpOriginX = Mth.m_14139_((double)partialTick, (double)entity.f_19854_, (double)entity.m_20185_()) + xAngleOffset;
        double lerpOriginY = Mth.m_14139_((double)partialTick, (double)entity.f_19855_, (double)entity.m_20186_()) + leashOffset.f_82480_;
        double lerpOriginZ = Mth.m_14139_((double)partialTick, (double)entity.f_19856_, (double)entity.m_20189_()) + zAngleOffset;
        Vec3 ropeGripPosition = leashHolder.m_7398_(partialTick);
        ropeGripPosition = ropeGripPosition.m_82549_(this.addRopeHoldPositionOffset((Entity)leashHolder));
        float xDif = (float)(ropeGripPosition.f_82479_ - lerpOriginX);
        float yDif = (float)(ropeGripPosition.f_82480_ - lerpOriginY);
        float zDif = (float)(ropeGripPosition.f_82481_ - lerpOriginZ);
        float offsetMod = (float)Mth.m_14193_((double)(xDif * xDif + zDif * zDif)) * 0.025f / 2.0f;
        float xOffset = zDif * offsetMod;
        float zOffset = xDif * offsetMod;
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110475_());
        BlockPos entityEyePos = BlockPos.m_274446_((Position)entity.m_20299_(partialTick));
        BlockPos holderEyePos = BlockPos.m_274446_((Position)leashHolder.m_20299_(partialTick));
        int entityBlockLight = this.m_6086_((Entity)((SWEMHorseEntity)entity), entityEyePos);
        int holderBlockLight = leashHolder.m_6060_() ? 15 : leashHolder.m_9236_().m_45517_(LightLayer.BLOCK, holderEyePos);
        int entitySkyLight = entity.m_9236_().m_45517_(LightLayer.SKY, entityEyePos);
        int holderSkyLight = entity.m_9236_().m_45517_(LightLayer.SKY, holderEyePos);
        poseStack.m_85836_();
        poseStack.m_85837_(xAngleOffset, leashOffset.f_82480_, zAngleOffset);
        Matrix4f posMatrix = poseStack.m_85850_().m_252922_();
        for (segment = 0; segment <= 24; ++segment) {
            SWEMHorseRenderer.renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight, entitySkyLight, holderSkyLight, 0.025f, 0.025f, xOffset, zOffset, segment, false);
        }
        for (segment = 24; segment >= 0; --segment) {
            SWEMHorseRenderer.renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight, entitySkyLight, holderSkyLight, 0.025f, 0.0f, xOffset, zOffset, segment, true);
        }
        poseStack.m_85849_();
    }

    private static void renderLeashPiece(VertexConsumer buffer, Matrix4f positionMatrix, float xDif, float yDif, float zDif, int entityBlockLight, int holderBlockLight, int entitySkyLight, int holderSkyLight, float width, float yOffset, float xOffset, float zOffset, int segment, boolean isLeashKnot) {
        float piecePosPercent = (float)segment / 24.0f;
        int lerpBlockLight = (int)Mth.m_14179_((float)piecePosPercent, (float)entityBlockLight, (float)holderBlockLight);
        int lerpSkyLight = (int)Mth.m_14179_((float)piecePosPercent, (float)entitySkyLight, (float)holderSkyLight);
        int packedLight = LightTexture.m_109885_((int)lerpBlockLight, (int)lerpSkyLight);
        float knotColourMod = segment % 2 == (isLeashKnot ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.5f * knotColourMod;
        float green = 0.4f * knotColourMod;
        float blue = 0.3f * knotColourMod;
        float x = xDif * piecePosPercent;
        float y = yDif > 0.0f ? yDif * piecePosPercent * piecePosPercent : yDif - yDif * (1.0f - piecePosPercent) * (1.0f - piecePosPercent);
        float z = zDif * piecePosPercent;
        buffer.m_252986_(positionMatrix, x - xOffset, y + yOffset, z + zOffset).m_85950_(red, green, blue, 1.0f).m_85969_(packedLight).m_5752_();
        buffer.m_252986_(positionMatrix, x + xOffset, y + width - yOffset, z - zOffset).m_85950_(red, green, blue, 1.0f).m_85969_(packedLight).m_5752_();
    }

    private Vec3 addRopeHoldPositionOffset(Entity leashHolder) {
        BlockState state = leashHolder.m_9236_().m_8055_(leashHolder.m_20183_());
        if (state.m_60734_() instanceof LeadAnchorBlock) {
            if (state.m_61143_((Property)LeadAnchorBlock.f_53179_) == AttachFace.FLOOR) {
                return new Vec3(0.0, -0.35, 0.0);
            }
            if (state.m_61143_((Property)LeadAnchorBlock.f_53179_) == AttachFace.CEILING) {
                return new Vec3(0.0, -0.1, 0.0);
            }
            if (state.m_61143_((Property)LeadAnchorBlock.f_54117_) == Direction.SOUTH) {
                return new Vec3(0.0, -0.4, -0.4);
            }
            if (state.m_61143_((Property)LeadAnchorBlock.f_54117_) == Direction.NORTH) {
                return new Vec3(0.0, -0.4, 0.4);
            }
            if (state.m_61143_((Property)LeadAnchorBlock.f_54117_) == Direction.EAST) {
                return new Vec3(-0.4, -0.4, 0.0);
            }
            if (state.m_61143_((Property)LeadAnchorBlock.f_54117_) == Direction.WEST) {
                return new Vec3(0.4, -0.4, 0.0);
            }
        }
        return new Vec3(0.0, 0.0, 0.0);
    }
}

