/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.client.gui.screens;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.client.gui.screens.TackBoxBirthScreen;
import com.alaharranhonor.swem.forge.client.gui.screens.TackBoxGeneticsScreen;
import com.alaharranhonor.swem.forge.client.gui.screens.TackBoxProgressionScreen;
import com.alaharranhonor.swem.forge.config.ServerConfig;
import com.alaharranhonor.swem.forge.container.TackBoxContainer;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.BreedingBehavior;
import com.alaharranhonor.swem.forge.network.protocol.SWEMPackets;
import com.alaharranhonor.swem.forge.network.protocol.game.ServerboundHorsePermissionPacket;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class TackBoxDefaultScreen
extends AbstractContainerScreen<TackBoxContainer> {
    private static final ResourceLocation TACKBOX_DEFAULT_TEXTURE = ModRef.res("textures/gui/container/tackbox_default.png");
    private final Inventory inventory;

    public TackBoxDefaultScreen(TackBoxContainer screenContainer, Inventory inv, Component title) {
        super((AbstractContainerMenu)screenContainer, inv, (Component)Component.m_237113_((String)"").m_7220_(screenContainer.horseName).m_130946_("'s Tack Box"));
        this.f_97727_ = 245;
        this.f_97729_ = 28;
        this.f_97731_ = this.f_97727_ - 94;
        this.inventory = inv;
    }

    protected void m_7856_() {
        super.m_7856_();
        SWEMHorseEntityBase horse = ((TackBoxContainer)this.m_6262_()).horse;
        Button permissionButton = Button.m_253074_((Component)Component.m_237113_((String)(horse != null ? horse.getPermissionState().name() : "Invalid")), p_onPress_1_ -> {
            SWEMPackets.sendToServer(new ServerboundHorsePermissionPacket(horse.m_20148_(), ServerboundHorsePermissionPacket.Action.CYCLE_PERMISSION));
            p_onPress_1_.m_93666_((Component)Component.m_237113_((String)SWEMHorseEntityBase.RidingPermission.values()[(horse.getPermissionState().ordinal() + 1) % 3].name()));
        }).m_252987_(this.f_97735_ + 122, this.f_97736_ + 137, 47, 14).m_253136_();
        if (horse == null || !Objects.equals(horse.m_21805_(), Minecraft.m_91087_().f_91074_.m_20148_())) {
            permissionButton.f_93623_ = false;
        }
        this.m_142416_((GuiEventListener)permissionButton);
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTicks, int pMouseX, int pMouseY) {
        this.m_280273_(pGuiGraphics);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        pGuiGraphics.m_280163_(TACKBOX_DEFAULT_TEXTURE, i, j, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 256);
        SWEMHorseEntityBase horse = ((TackBoxContainer)this.m_6262_()).horse;
        for (Slot slot : ((TackBoxContainer)this.m_6262_()).f_38839_) {
            if (!slot.m_6657_()) continue;
            pGuiGraphics.m_280218_(TACKBOX_DEFAULT_TEXTURE, this.f_97735_ + slot.f_40220_, this.f_97736_ + slot.f_40221_, 8, 112, 16, 16);
        }
        if (horse == null) {
            pGuiGraphics.m_280218_(TACKBOX_DEFAULT_TEXTURE, i + 41, j + 144, 179, 42, 29, 3);
            pGuiGraphics.m_280218_(TACKBOX_DEFAULT_TEXTURE, i + 82, j + 144, 179, 42, 29, 3);
            pGuiGraphics.m_280218_(TACKBOX_DEFAULT_TEXTURE, i + 9, j + 140, 187, 22, 3, 3);
            return;
        }
        if (horse.isBeingTracked()) {
            pGuiGraphics.m_280218_(TACKBOX_DEFAULT_TEXTURE, i + 9, j + 142, 180, 23, 3, 3);
        }
        int hungerX = i + 52;
        int hungerY = j + 139;
        int hungerUOffset = 179;
        int hungerVOffset = 30;
        int hungerHeight = 3;
        switch (horse.getNeeds().getHunger().getState()) {
            case STARVING: {
                break;
            }
            case MALNOURISHED: {
                pGuiGraphics.m_280218_(TACKBOX_DEFAULT_TEXTURE, hungerX, hungerY, hungerUOffset, hungerVOffset, 12, hungerHeight);
                break;
            }
            case HUNGRY: {
                pGuiGraphics.m_280218_(TACKBOX_DEFAULT_TEXTURE, hungerX, hungerY, hungerUOffset, hungerVOffset, 18, hungerHeight);
                break;
            }
            case FED: {
                pGuiGraphics.m_280218_(TACKBOX_DEFAULT_TEXTURE, hungerX, hungerY, hungerUOffset, hungerVOffset, 24, hungerHeight);
                break;
            }
            case FULLY_FED: {
                pGuiGraphics.m_280218_(TACKBOX_DEFAULT_TEXTURE, hungerX, hungerY, hungerUOffset, hungerVOffset, 28, hungerHeight);
            }
        }
        int thirstX = i + 52;
        int thirstY = j + 150;
        int thirstXOffset = 179;
        int thirstYOffset = 36;
        int thirstHeight = 3;
        switch (horse.getNeeds().getThirst().getState()) {
            case EXICCOSIS: {
                break;
            }
            case DEHYDRATED: {
                pGuiGraphics.m_280218_(TACKBOX_DEFAULT_TEXTURE, thirstX, thirstY, thirstXOffset, thirstYOffset, 12, thirstHeight);
                break;
            }
            case THIRSTY: {
                pGuiGraphics.m_280218_(TACKBOX_DEFAULT_TEXTURE, thirstX, thirstY, thirstXOffset, thirstYOffset, 18, thirstHeight);
                break;
            }
            case SATISIFIED: {
                pGuiGraphics.m_280218_(TACKBOX_DEFAULT_TEXTURE, thirstX, thirstY, thirstXOffset, thirstYOffset, 24, thirstHeight);
                break;
            }
            case QUENCHED: {
                pGuiGraphics.m_280218_(TACKBOX_DEFAULT_TEXTURE, thirstX, thirstY, thirstXOffset, thirstYOffset, 28, thirstHeight);
            }
        }
        BreedingBehavior breeding = horse.getBreeding();
        int genderX = this.f_97735_ + 96;
        int genderY = this.f_97736_ + 138;
        int genderUOffset = breeding.isMale() ? 179 : 194;
        int genderVOffset = breeding.isInfertile() ? 61 : 46;
        pGuiGraphics.m_280218_(TACKBOX_DEFAULT_TEXTURE, genderX, genderY, genderUOffset, genderVOffset, 12, 12);
        int breedMarkUOffset = breeding.canFallInLove() ? 179 : 187;
        pGuiGraphics.m_280218_(TACKBOX_DEFAULT_TEXTURE, genderX - 6, genderY, breedMarkUOffset, 22, 5, 5);
        if (breeding.isFemale()) {
            pGuiGraphics.m_280218_(TACKBOX_DEFAULT_TEXTURE, genderX + 13, genderY, 216, 28, 4, 12);
            if (breeding.isPregnant()) {
                int pregnancyProgress = breeding.getPregnancyStage();
                if (pregnancyProgress >= 25) {
                    pGuiGraphics.m_280218_(TACKBOX_DEFAULT_TEXTURE, genderX + 14, genderY + 8, 211, 36, 2, 3);
                }
                if (pregnancyProgress >= 50) {
                    pGuiGraphics.m_280218_(TACKBOX_DEFAULT_TEXTURE, genderX + 14, genderY + 4, 211, 32, 2, 7);
                }
                if (pregnancyProgress >= 75) {
                    pGuiGraphics.m_280218_(TACKBOX_DEFAULT_TEXTURE, genderX + 14, genderY + 1, 211, 29, 2, 10);
                }
            }
        }
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        pGuiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)"Storage"), 8, 101, 0x404040, false);
        if (((TackBoxContainer)this.m_6262_()).horse == null) {
            return;
        }
        int genderX = this.f_97735_ + 96;
        int genderY = this.f_97736_ + 138;
        BreedingBehavior breeding = ((TackBoxContainer)this.m_6262_()).horse.getBreeding();
        if (pMouseX >= genderX && pMouseX <= genderX + 12 && pMouseY >= genderY && pMouseY <= genderY + 12) {
            ArrayList<Object> components = new ArrayList<Object>();
            Component name = breeding.getName();
            if (breeding.isInfertile()) {
                name = name.m_6881_().m_130946_(" (").m_7220_(breeding.getInfertilityText()).m_130946_(")");
            }
            components.add(name);
            components.add(Component.m_237113_((String)(breeding.isMale() ? "Covers" : "Births")).m_130946_(": ").m_130946_(Integer.toString(breeding.getTotalOffsprings())).m_130946_((String)(breeding.isMale() ? (ServerConfig.maxStallionCovers > 0 ? "/" + ServerConfig.maxStallionCovers : "") : (ServerConfig.maxMareBirths > 0 ? "/" + ServerConfig.maxMareBirths : ""))));
            int loveTimer = breeding.getLoveTimer();
            StringBuilder loveStatus = new StringBuilder("Is in love: ");
            loveStatus.append(breeding.isInLove() ? "Yes" : "No");
            if (loveTimer > 0) {
                loveStatus.append(" (").append(loveTimer / 20).append("s)");
            }
            components.add(Component.m_237113_((String)loveStatus.toString()));
            pGuiGraphics.m_280677_(this.f_96547_, components, Optional.empty(), pMouseX - this.f_97735_, pMouseY - this.f_97736_);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (mouseY >= (double)this.f_97736_ && mouseY <= (double)(this.f_97736_ + 22)) {
            if (mouseX >= (double)(this.f_97735_ + 3) && mouseX <= (double)(this.f_97735_ + 27)) {
                this.getMinecraft().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                return true;
            }
            if (mouseX >= (double)(this.f_97735_ + 34) && mouseX <= (double)(this.f_97735_ + 56)) {
                this.getMinecraft().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                this.f_96541_.m_91152_((Screen)new TackBoxBirthScreen((TackBoxContainer)this.m_6262_(), this.inventory, (Component)Component.m_237115_((String)"container.swem.tack_box_certificate")));
                return true;
            }
            if (mouseX >= (double)(this.f_97735_ + 65) && mouseX <= (double)(this.f_97735_ + 87)) {
                this.getMinecraft().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                this.f_96541_.m_91152_((Screen)new TackBoxGeneticsScreen((TackBoxContainer)this.m_6262_(), this.inventory, (Component)Component.m_237115_((String)"container.swem.tack_box_genetics")));
                return true;
            }
            if (mouseX >= (double)(this.f_97735_ + 96) && mouseX <= (double)(this.f_97735_ + 118)) {
                this.getMinecraft().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                this.f_96541_.m_91152_((Screen)new TackBoxProgressionScreen((TackBoxContainer)this.m_6262_(), this.inventory, (Component)Component.m_237115_((String)"container.swem.tack_box_progression")));
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }
}

