/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.client.gui.screens;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.client.KeyBindSetup;
import com.alaharranhonor.swem.forge.config.ServerConfig;
import com.alaharranhonor.swem.forge.container.SWEMHorseInventoryContainer;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.BreedingBehavior;
import com.alaharranhonor.swem.forge.entities.horse.progression.leveling.AffinityLeveling;
import com.alaharranhonor.swem.forge.entities.horse.progression.leveling.HealthLeveling;
import com.alaharranhonor.swem.forge.entities.horse.progression.leveling.JumpLeveling;
import com.alaharranhonor.swem.forge.entities.horse.progression.leveling.SpeedLeveling;
import com.alaharranhonor.swem.forge.network.protocol.SWEMPackets;
import com.alaharranhonor.swem.forge.network.protocol.game.ServerboundHorsePermissionPacket;
import com.alaharranhonor.swem.forge.util.SWEMUtil;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SWEMHorseInventoryScreen
extends AbstractContainerScreen<SWEMHorseInventoryContainer> {
    private static final ResourceLocation HORSE_GUI_TEXTURES = ModRef.res("textures/gui/container/swem_horse.png");
    private final SWEMHorseEntityBase horse;
    public Timer timer;
    private int tackSet = 0;

    public SWEMHorseInventoryScreen(SWEMHorseInventoryContainer container, Inventory playerInventoryIn, Component title) {
        super((AbstractContainerMenu)container, playerInventoryIn, title);
        this.f_97727_ = 222;
        this.f_97731_ = this.f_97727_ - 94;
        this.f_97728_ = 65;
        this.f_97729_ = 22;
        this.horse = container.horse;
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                SWEMHorseInventoryScreen.this.tackSet = (SWEMHorseInventoryScreen.this.tackSet + 1) % 3;
            }
        }, 3000L, 3000L);
    }

    public void m_7379_() {
        this.timer.cancel();
        super.m_7379_();
    }

    protected void m_7856_() {
        super.m_7856_();
        Button permissionButton = Button.m_253074_((Component)Component.m_237113_((String)this.horse.getPermissionState().name()), b -> {
            SWEMPackets.sendToServer(new ServerboundHorsePermissionPacket(this.horse.m_20148_(), ServerboundHorsePermissionPacket.Action.CYCLE_PERMISSION));
            b.m_93666_((Component)Component.m_237113_((String)SWEMHorseEntityBase.RidingPermission.values()[(this.horse.getPermissionState().ordinal() + 1) % 3].name()));
        }).m_252987_(this.f_97735_ + 122, this.f_97736_ + 111, 48, 14).m_253136_();
        if (!Objects.equals(this.horse.m_21805_(), Minecraft.m_91087_().f_91074_.m_20148_())) {
            permissionButton.f_93623_ = false;
        }
        this.m_142416_((GuiEventListener)permissionButton);
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
        int genderX = this.f_97735_ + 96;
        int genderY = this.f_97736_ + 113;
        BreedingBehavior breeding = this.horse.getBreeding();
        if (pMouseX >= genderX && pMouseX <= genderX + 12 && pMouseY >= genderY && pMouseY <= genderY + 12) {
            ArrayList<Object> components = new ArrayList<Object>();
            Component name = breeding.getName();
            if (breeding.isInfertile()) {
                name = name.m_6881_().m_130946_(" (").m_7220_(breeding.getInfertilityText()).m_130946_(")");
            }
            components.add(name);
            components.add(Component.m_237113_((String)(breeding.isMale() ? "Covers" : "Births")).m_130946_(": ").m_130946_(Integer.toString(breeding.getTotalOffsprings())).m_130946_((String)(breeding.isMale() ? (ServerConfig.maxStallionCovers > 0 ? "/" + ServerConfig.maxStallionCovers : "") : (ServerConfig.maxMareBirths > 0 ? "/" + ServerConfig.maxMareBirths : ""))));
            int loveTimer = breeding.getLoveTimer();
            StringBuilder loveStatus = new StringBuilder("Is in love: ");
            loveStatus.append(breeding.isInLove() ? "Yes" : "No");
            if (loveTimer > 0) {
                loveStatus.append(" (").append(loveTimer / 20).append("s)");
            }
            components.add(Component.m_237113_((String)loveStatus.toString()));
            pGuiGraphics.m_280677_(this.f_96547_, components, Optional.empty(), pMouseX, pMouseY);
        }
        int tankX = this.f_97735_ + 153;
        int tankY = this.f_97736_ + 19;
        if (pMouseX >= tankX && pMouseX <= tankX + 14 && pMouseY >= tankY && pMouseY <= tankY + 11) {
            pGuiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237110_((String)"container.swem.inventory.tank_controls", (Object[])new Object[]{KeyBindSetup.TOGGLE_TANK_CONTROLS.m_90863_()}), pMouseX, pMouseY);
        }
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTicks, int pMouseX, int pMouseY) {
        this.m_280273_(pGuiGraphics);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        pGuiGraphics.m_280218_(HORSE_GUI_TEXTURES, i, j, 0, 0, this.f_97726_, this.f_97727_);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        boolean hasTankControl = SWEMUtil.hasTankControls((Entity)player);
        pGuiGraphics.m_280218_(HORSE_GUI_TEXTURES, this.f_97735_ + 153, this.f_97736_ + 19, hasTankControl ? 196 : 179, 195, 14, 11);
        if (this.tackSet != 0) {
            for (int xSlot = 0; xSlot < 2; ++xSlot) {
                for (int ySlot = 0; ySlot < 3; ++ySlot) {
                    pGuiGraphics.m_280218_(HORSE_GUI_TEXTURES, this.f_97735_ + 8 + xSlot * 21, this.f_97736_ + 17 + ySlot * 21, 180 + xSlot * 21, 4 + ySlot * 21 + (this.tackSet == 2 ? 67 : 0), 16, 16);
                }
            }
        }
        for (Slot slot : ((SWEMHorseInventoryContainer)this.f_97732_).f_38839_) {
            if (!slot.m_6657_()) continue;
            pGuiGraphics.m_280218_(HORSE_GUI_TEXTURES, this.f_97735_ + slot.f_40220_, this.f_97736_ + slot.f_40221_, 8, 140, 16, 16);
        }
        if (this.horse.isBeingTracked()) {
            pGuiGraphics.m_280218_(HORSE_GUI_TEXTURES, this.f_97735_ + 9, this.f_97736_ + 117, 180, 138, 3, 3);
        }
        int hungerX = this.f_97735_ + 52;
        int hungerY = this.f_97736_ + 114;
        int hungerXOffset = 179;
        int hungerYOffset = 145;
        int hungerHeight = 3;
        switch (this.horse.getNeeds().getHunger().getState()) {
            case STARVING: {
                break;
            }
            case MALNOURISHED: {
                pGuiGraphics.m_280218_(HORSE_GUI_TEXTURES, hungerX, hungerY, hungerXOffset, hungerYOffset, 12, hungerHeight);
                break;
            }
            case HUNGRY: {
                pGuiGraphics.m_280218_(HORSE_GUI_TEXTURES, hungerX, hungerY, hungerXOffset, hungerYOffset, 18, hungerHeight);
                break;
            }
            case FED: {
                pGuiGraphics.m_280218_(HORSE_GUI_TEXTURES, hungerX, hungerY, hungerXOffset, hungerYOffset, 24, hungerHeight);
                break;
            }
            case FULLY_FED: {
                pGuiGraphics.m_280218_(HORSE_GUI_TEXTURES, hungerX, hungerY, hungerXOffset, hungerYOffset, 28, hungerHeight);
            }
        }
        int thirstX = this.f_97735_ + 52;
        int thirstY = this.f_97736_ + 125;
        int thirstXOffset = 179;
        int thirstYOffset = 151;
        int thirstHeight = 3;
        switch (this.horse.getNeeds().getThirst().getState()) {
            case EXICCOSIS: {
                break;
            }
            case DEHYDRATED: {
                pGuiGraphics.m_280218_(HORSE_GUI_TEXTURES, thirstX, thirstY, thirstXOffset, thirstYOffset, 12, thirstHeight);
                break;
            }
            case THIRSTY: {
                pGuiGraphics.m_280218_(HORSE_GUI_TEXTURES, thirstX, thirstY, thirstXOffset, thirstYOffset, 18, thirstHeight);
                break;
            }
            case SATISIFIED: {
                pGuiGraphics.m_280218_(HORSE_GUI_TEXTURES, thirstX, thirstY, thirstXOffset, thirstYOffset, 24, thirstHeight);
                break;
            }
            case QUENCHED: {
                pGuiGraphics.m_280218_(HORSE_GUI_TEXTURES, thirstX, thirstY, thirstXOffset, thirstYOffset, 28, thirstHeight);
            }
        }
        BreedingBehavior breeding = this.horse.getBreeding();
        int genderX = this.f_97735_ + 96;
        int genderY = this.f_97736_ + 113;
        int genderXOffset = breeding.isMale() ? 179 : 194;
        int genderYOffset = breeding.isInfertile() ? 176 : 161;
        pGuiGraphics.m_280218_(HORSE_GUI_TEXTURES, genderX, genderY, genderXOffset, genderYOffset, 12, 12);
        int breedMarkUOffset = breeding.canFallInLove() ? 179 : 187;
        pGuiGraphics.m_280218_(HORSE_GUI_TEXTURES, genderX - 6, genderY, breedMarkUOffset, 137, 5, 5);
        if (breeding.isFemale()) {
            pGuiGraphics.m_280218_(HORSE_GUI_TEXTURES, genderX + 13, genderY, 215, 143, 4, 12);
            if (breeding.isPregnant()) {
                int pregnancyProgress = breeding.getPregnancyStage();
                if (pregnancyProgress >= 25) {
                    pGuiGraphics.m_280218_(HORSE_GUI_TEXTURES, genderX + 14, genderY + 8, 211, 151, 2, 3);
                }
                if (pregnancyProgress >= 50) {
                    pGuiGraphics.m_280218_(HORSE_GUI_TEXTURES, genderX + 14, genderY + 4, 211, 147, 2, 7);
                }
                if (pregnancyProgress >= 75) {
                    pGuiGraphics.m_280218_(HORSE_GUI_TEXTURES, genderX + 14, genderY + 1, 211, 144, 2, 10);
                }
            }
        }
    }

    protected void m_280003_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        super.m_280003_(pGuiGraphics, pMouseX, pMouseY);
        SpeedLeveling speedLeveling = this.horse.progressionManager.getSpeedLeveling();
        AffinityLeveling affinityLeveling = this.horse.progressionManager.getAffinityLeveling();
        JumpLeveling jumpLeveling = this.horse.progressionManager.getJumpLeveling();
        HealthLeveling healthLeveling = this.horse.progressionManager.getHealthLeveling();
        pGuiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"Tack"), 15, 6, 0x404040, false);
        pGuiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"Stats"), 65, 6, 0x404040, false);
        pGuiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)SWEMUtil.checkTextOverflow(this.horse.getOwnerName(), 22)), 65, 36, 0x404040, false);
        pGuiGraphics.m_280614_(this.f_96547_, jumpLeveling.getValueComponent(), 65, 49, 0x404040, false);
        pGuiGraphics.m_280614_(this.f_96547_, speedLeveling.getValueComponent(), 65, 64, 0x404040, false);
        pGuiGraphics.m_280614_(this.f_96547_, healthLeveling.getValueComponent(), 65, 78, 0x404040, false);
        pGuiGraphics.m_280614_(this.f_96547_, affinityLeveling.getValueComponent(), 65, 92, 0x404040, false);
    }

    static Component getAffinityTextComp(AffinityLeveling affinityLeveling) {
        if (affinityLeveling.getLevel() != affinityLeveling.getMaxLevel()) {
            float currentXP = affinityLeveling.getXp();
            float requiredXP = affinityLeveling.getRequiredXp();
            boolean currentThousands = false;
            boolean requiredThousands = false;
            if (currentXP > 1000.0f) {
                currentXP /= 1000.0f;
                currentThousands = true;
            }
            if (requiredXP > 1000.0f) {
                requiredXP /= 1000.0f;
                requiredThousands = true;
            }
            return Component.m_237115_((String)(String.format("%s: ", affinityLeveling.getLevelName()) + String.format("%.0f", Float.valueOf(currentXP)) + (currentThousands ? "k" : "") + "/" + String.format("%.0f", Float.valueOf(requiredXP)) + (requiredThousands ? "k" : "")));
        }
        return Component.m_237115_((String)String.format("%s", affinityLeveling.getLevelName()));
    }
}

