/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.blocks.jumps;

import com.alaharranhonor.swem.forge.blocks.SWEMBlockStateProperties;
import com.alaharranhonor.swem.forge.config.ServerConfig;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.registry.BlockSetup;
import com.alaharranhonor.swem.forge.tileentity.JumpPasserBE;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class JumpBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final EnumProperty<SWEMBlockStateProperties.TripleBlockSide> JUMP_PIECE = SWEMBlockStateProperties.T_SIDE;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.f_61360_;
    private final VoxelShape ew;
    private final VoxelShape ns;

    public JumpBlock(VoxelShape ew, VoxelShape ns) {
        super(BlockBehaviour.Properties.m_284310_().m_60955_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
        this.ew = ew;
        this.ns = ns;
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        SWEMHorseEntityBase horse;
        if (!ServerConfig.fireworkDisplay) {
            return;
        }
        if (!(pEntity instanceof SWEMHorseEntityBase) || !(horse = (SWEMHorseEntityBase)pEntity).m_20160_()) {
            return;
        }
        if (pState.m_60734_() != BlockSetup.JUMP_NONE.get() && !pLevel.m_5776_() && !((Boolean)pState.m_61143_((Property)TRIGGERED)).booleanValue()) {
            pLevel.m_7967_((Entity)new FireworkRocketEntity(pLevel, (double)pPos.m_123341_() + 0.5, (double)(pPos.m_123342_() + 5), (double)pPos.m_123343_() + 0.5, this.getFirework(DyeColor.RED, 1)));
            pLevel.m_186460_(pPos, pState.m_60734_(), 20);
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 3);
    }

    private ItemStack getFirework(DyeColor pColor, int pFlightTime) {
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_42688_, 1);
        ItemStack itemstack1 = new ItemStack((ItemLike)Items.f_42689_);
        CompoundTag compoundtag = itemstack1.m_41698_("Explosion");
        ArrayList list = Lists.newArrayList();
        list.add(pColor.m_41070_());
        compoundtag.m_128408_("Colors", (List)list);
        compoundtag.m_128344_("Type", (byte)FireworkRocketItem.Shape.BURST.m_41236_());
        CompoundTag compoundtag1 = itemstack.m_41698_("Fireworks");
        ListTag listtag = new ListTag();
        CompoundTag compoundtag2 = itemstack1.m_41737_("Explosion");
        if (compoundtag2 != null) {
            listtag.add((Object)compoundtag2);
        }
        compoundtag1.m_128344_("Flight", (byte)pFlightTime);
        if (!listtag.isEmpty()) {
            compoundtag1.m_128365_("Explosions", (Tag)listtag);
        }
        return itemstack;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Direction)state.m_61143_((Property)f_54117_)).m_122434_() == Direction.Axis.X) {
            return this.ew;
        }
        return this.ns;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, JUMP_PIECE, TRIGGERED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new JumpPasserBE(p_153215_, p_153216_);
    }
}

