/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.blocks;

import com.alaharranhonor.swem.forge.blocks.SWEMBlockStateProperties;
import com.alaharranhonor.swem.forge.tileentity.PaddockFeederBE;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class PaddockFeederBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final IntegerProperty LEVEL = SWEMBlockStateProperties.LEVEL_0_3;
    public static final EnumProperty<SWEMBlockStateProperties.DoubleBlockSide> SIDE = SWEMBlockStateProperties.D_SIDE;

    public PaddockFeederBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(SIDE, (Comparable)((Object)SWEMBlockStateProperties.DoubleBlockSide.LEFT))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        SWEMBlockStateProperties.DoubleBlockSide side = (SWEMBlockStateProperties.DoubleBlockSide)((Object)state.m_61143_(SIDE));
        switch (direction) {
            case NORTH: {
                if (side == SWEMBlockStateProperties.DoubleBlockSide.LEFT) {
                    return Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)14.0, (double)16.0, (double)15.0);
                }
                return Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0);
            }
            case EAST: {
                if (side == SWEMBlockStateProperties.DoubleBlockSide.LEFT) {
                    return Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)14.0);
                }
                return Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0);
            }
            case SOUTH: {
                if (side == SWEMBlockStateProperties.DoubleBlockSide.LEFT) {
                    return Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0);
                }
                return Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)14.0, (double)16.0, (double)15.0);
            }
            case WEST: {
                if (side == SWEMBlockStateProperties.DoubleBlockSide.LEFT) {
                    return Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0);
                }
                return Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)14.0);
            }
        }
        return Shapes.m_83144_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction blockFacing = context.m_8125_().m_122424_();
        if (!PaddockFeederBlock.canPlace(context.m_43725_(), context.m_8083_(), blockFacing, context)) {
            return null;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)blockFacing)).m_61124_(SIDE, (Comparable)((Object)SWEMBlockStateProperties.DoubleBlockSide.LEFT));
    }

    public static boolean isMain(BlockState state) {
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER && state.m_61143_(SIDE) == SWEMBlockStateProperties.DoubleBlockSide.LEFT;
    }

    public static BlockPos getMainPos(BlockState state, BlockPos pos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        SWEMBlockStateProperties.DoubleBlockSide side = (SWEMBlockStateProperties.DoubleBlockSide)((Object)state.m_61143_(SIDE));
        if (half == DoubleBlockHalf.LOWER && side == SWEMBlockStateProperties.DoubleBlockSide.LEFT) {
            return pos;
        }
        if (half == DoubleBlockHalf.UPPER) {
            pos = pos.m_7495_();
        }
        if (side == SWEMBlockStateProperties.DoubleBlockSide.LEFT) {
            return pos;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return pos.m_121945_(facing.m_122427_());
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pBuilder) {
        List drops = super.m_49635_(pState, pBuilder);
        BlockEntity be = (BlockEntity)pBuilder.m_287159_(LootContextParams.f_81462_);
        if (be instanceof PaddockFeederBE) {
            PaddockFeederBE feeder = (PaddockFeederBE)be;
            drops.add(feeder.peekStack(0));
        }
        return drops;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_) {
            PaddockFeederBlock.getAllParts(state, pos).forEach(blockPos -> level.m_46953_(blockPos, true, (Entity)player));
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        Direction offsetFacing = ((Direction)state.m_61143_((Property)FACING)).m_122428_();
        worldIn.m_7731_(pos.m_121945_(offsetFacing), (BlockState)state.m_61124_(SIDE, (Comparable)((Object)SWEMBlockStateProperties.DoubleBlockSide.RIGHT)), 3);
        worldIn.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        worldIn.m_7731_(pos.m_121945_(offsetFacing).m_7494_(), (BlockState)((BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_(SIDE, (Comparable)((Object)SWEMBlockStateProperties.DoubleBlockSide.RIGHT)), 3);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(handIn);
        if (itemstack.m_41619_()) {
            return InteractionResult.PASS;
        }
        int hayLevel = (Integer)state.m_61143_((Property)LEVEL);
        Item item = itemstack.m_41720_();
        BlockPos mainPos = PaddockFeederBlock.getMainPos(state, pos);
        PaddockFeederBE te = (PaddockFeederBE)worldIn.m_7702_(mainPos);
        ItemStack copy = itemstack.m_41777_();
        if (!player.m_7500_()) {
            itemstack.m_41774_(1);
        }
        copy.m_41764_(1);
        AtomicReference returnedStack = new AtomicReference();
        te.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> returnedStack.set(handler.insertItem(0, copy, false)));
        if (returnedStack.get() != null && !player.m_7500_()) {
            player.m_150109_().m_150079_((ItemStack)returnedStack.get());
        }
        return InteractionResult.CONSUME;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public static ArrayList<BlockPos> getAllParts(BlockState state, BlockPos pos) {
        BlockPos mainPos = PaddockFeederBlock.getMainPos(state, pos);
        Direction offsetFacing = ((Direction)state.m_61143_((Property)FACING)).m_122428_();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        positions.add(mainPos);
        positions.add(mainPos.m_7494_());
        positions.add(mainPos.m_7494_().m_121945_(offsetFacing));
        positions.add(mainPos.m_121945_(offsetFacing));
        return positions;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return PaddockFeederBlock.getAllParts(state, pos).stream().allMatch(p -> {
            BlockState state1 = worldIn.m_8055_(p);
            return state1 == Blocks.f_50016_.m_49966_();
        });
    }

    private int getPosIndexForState(BlockState state) {
        if (!state.m_60713_((Block)this)) {
            return -1;
        }
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        SWEMBlockStateProperties.DoubleBlockSide side = (SWEMBlockStateProperties.DoubleBlockSide)((Object)state.m_61143_(SIDE));
        if (side == SWEMBlockStateProperties.DoubleBlockSide.LEFT) {
            if (half == DoubleBlockHalf.LOWER) {
                return 0;
            }
            return 1;
        }
        if (half == DoubleBlockHalf.UPPER) {
            return 2;
        }
        return 3;
    }

    public PushReaction getPistonPushReaction(BlockState pState) {
        return PushReaction.BLOCK;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF, FACING, SIDE, LEVEL});
    }

    public void eat(Level level, BlockPos foundFood, BlockState blockState) {
        PaddockFeederBlock.getAllParts(blockState, foundFood).stream().forEach(pos -> {
            BlockState feederState = level.m_8055_(pos);
            if (feederState.m_60734_() instanceof PaddockFeederBlock) {
                int value = (Integer)feederState.m_61143_((Property)LEVEL);
                level.m_7731_(pos, (BlockState)feederState.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(Math.max(0, --value))), 3);
            }
        });
    }

    private static boolean canPlace(Level level, BlockPos pos, Direction facing, BlockPlaceContext ctx) {
        Direction offsetFacing = facing.m_122428_();
        return level.m_8055_(pos).m_60629_(ctx) && level.m_8055_(pos.m_7494_()).m_60629_(BlockPlaceContext.m_43644_((BlockPlaceContext)ctx, (BlockPos)pos, (Direction)Direction.UP)) && level.m_8055_(pos.m_121945_(offsetFacing)).m_60629_(BlockPlaceContext.m_43644_((BlockPlaceContext)ctx, (BlockPos)pos, (Direction)offsetFacing)) && level.m_8055_(pos.m_7494_().m_121945_(offsetFacing)).m_60629_(BlockPlaceContext.m_43644_((BlockPlaceContext)ctx, (BlockPos)pos.m_7494_(), (Direction)offsetFacing));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (PaddockFeederBlock.isMain(state)) {
            return new PaddockFeederBE(pos, state);
        }
        return null;
    }
}

