/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.blocks;

import com.alaharranhonor.swem.forge.blocks.SWEMBlockStateProperties;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HorseDoorHalfBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;
    public static final EnumProperty<SWEMBlockStateProperties.DoubleBlockSide> SIDE = SWEMBlockStateProperties.D_SIDE;
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    private final DyeColor colour;
    private final BlockSetType type;

    public HorseDoorHalfBlock(BlockBehaviour.Properties builder, BlockSetType type, DyeColor colour) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_(HINGE, (Comparable)DoorHingeSide.LEFT));
        this.colour = colour;
        this.type = type;
    }

    public DyeColor getColour() {
        return this.colour;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        boolean flag = (Boolean)state.m_61143_((Property)OPEN) == false;
        boolean flag1 = state.m_61143_(HINGE) == DoorHingeSide.RIGHT;
        switch (direction) {
            default: {
                return flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return flag ? SOUTH_AABB : (flag1 ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return flag ? WEST_AABB : (flag1 ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        switch (type) {
            case LAND: {
                return (Boolean)state.m_61143_((Property)OPEN);
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return (Boolean)state.m_61143_((Property)OPEN);
            }
        }
        return false;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        Direction direction = context.m_8125_();
        DoorHingeSide hinge = this.getHingeSide(context);
        if (hinge == DoorHingeSide.LEFT) {
            return this.checkAndGetRightSide(blockpos, direction, context, hinge, false);
        }
        return this.checkAndGetLeftSide(blockpos, direction, context, hinge, false);
    }

    public BlockState checkAndGetRightSide(BlockPos blockpos, Direction direction, BlockPlaceContext context, DoorHingeSide hinge, boolean secondTime) {
        ArrayList blockChecks = new ArrayList();
        BlockPos.m_121940_((BlockPos)blockpos, (BlockPos)blockpos.m_5487_(direction.m_122428_().m_122434_(), direction == Direction.EAST ? 1 : (direction == Direction.NORTH ? 1 : -1))).forEach(blockPos1 -> blockChecks.add(context.m_43725_().m_8055_(blockPos1).m_60629_(context)));
        if (blockpos.m_123342_() < 254 && blockChecks.stream().allMatch(bool -> bool)) {
            Level world = context.m_43725_();
            boolean flag = world.m_276867_(blockpos) || world.m_276867_(blockpos.m_7494_());
            return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_(HINGE, (Comparable)hinge)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(flag))).m_61124_(SIDE, (Comparable)((Object)SWEMBlockStateProperties.DoubleBlockSide.LEFT));
        }
        if (!secondTime) {
            return this.checkAndGetLeftSide(blockpos, direction, context, hinge == DoorHingeSide.LEFT ? DoorHingeSide.RIGHT : hinge, true);
        }
        return null;
    }

    public BlockState checkAndGetLeftSide(BlockPos blockpos, Direction direction, BlockPlaceContext context, DoorHingeSide hinge, boolean secondTime) {
        ArrayList blockChecks = new ArrayList();
        BlockPos.m_121940_((BlockPos)blockpos, (BlockPos)blockpos.m_5487_(direction.m_122428_().m_122434_(), direction == Direction.EAST ? -1 : (direction == Direction.NORTH ? -1 : 1))).forEach(blockPos1 -> blockChecks.add(context.m_43725_().m_8055_(blockPos1).m_60629_(context)));
        if (blockpos.m_123342_() < 254 && blockChecks.stream().allMatch(bool -> bool)) {
            Level world = context.m_43725_();
            boolean flag = world.m_276867_(blockpos) || world.m_276867_(blockpos.m_7494_());
            return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_(HINGE, (Comparable)hinge)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(flag))).m_61124_(SIDE, (Comparable)((Object)SWEMBlockStateProperties.DoubleBlockSide.RIGHT));
        }
        if (!secondTime) {
            return this.checkAndGetRightSide(blockpos, direction, context, hinge == DoorHingeSide.RIGHT ? DoorHingeSide.LEFT : hinge, true);
        }
        return null;
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        return state.m_61143_(SIDE) == SWEMBlockStateProperties.DoubleBlockSide.LEFT;
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.f_46443_) {
            this.getAllDoorParts(state, pos, worldIn, (Boolean)state.m_61143_((Property)OPEN) == false).stream().forEach(blockPos -> worldIn.m_6933_(blockPos, Blocks.f_50016_.m_49966_(), 35, 3));
        }
        if (!player.m_7500_()) {
            HorseDoorHalfBlock.m_49950_((BlockState)state, (Level)worldIn, (BlockPos)pos);
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (state.m_61143_(SIDE) == SWEMBlockStateProperties.DoubleBlockSide.LEFT) {
            if (placer.m_6350_().m_122434_() == Direction.Axis.Z) {
                switch (placer.m_6350_()) {
                    case NORTH: {
                        worldIn.m_6933_(pos.m_122029_(), (BlockState)state.m_61124_(SIDE, (Comparable)((Object)SWEMBlockStateProperties.DoubleBlockSide.RIGHT)), 3, 3);
                        break;
                    }
                    case SOUTH: {
                        worldIn.m_6933_(pos.m_122024_(), (BlockState)state.m_61124_(SIDE, (Comparable)((Object)SWEMBlockStateProperties.DoubleBlockSide.RIGHT)), 3, 3);
                    }
                }
            } else if (placer.m_6350_().m_122434_() == Direction.Axis.X) {
                switch (placer.m_6350_()) {
                    case EAST: {
                        worldIn.m_6933_(pos.m_122019_(), (BlockState)state.m_61124_(SIDE, (Comparable)((Object)SWEMBlockStateProperties.DoubleBlockSide.RIGHT)), 3, 3);
                        break;
                    }
                    case WEST: {
                        worldIn.m_6933_(pos.m_122012_(), (BlockState)state.m_61124_(SIDE, (Comparable)((Object)SWEMBlockStateProperties.DoubleBlockSide.RIGHT)), 3, 3);
                    }
                }
            }
        } else if (placer.m_6350_().m_122434_() == Direction.Axis.Z) {
            switch (placer.m_6350_()) {
                case NORTH: {
                    worldIn.m_6933_(pos.m_122024_(), (BlockState)state.m_61124_(SIDE, (Comparable)((Object)SWEMBlockStateProperties.DoubleBlockSide.LEFT)), 3, 3);
                    break;
                }
                case SOUTH: {
                    worldIn.m_6933_(pos.m_122029_(), (BlockState)state.m_61124_(SIDE, (Comparable)((Object)SWEMBlockStateProperties.DoubleBlockSide.LEFT)), 3, 3);
                }
            }
        } else if (placer.m_6350_().m_122434_() == Direction.Axis.X) {
            switch (placer.m_6350_()) {
                case EAST: {
                    worldIn.m_6933_(pos.m_122012_(), (BlockState)state.m_61124_(SIDE, (Comparable)((Object)SWEMBlockStateProperties.DoubleBlockSide.LEFT)), 3, 3);
                    break;
                }
                case WEST: {
                    worldIn.m_6933_(pos.m_122019_(), (BlockState)state.m_61124_(SIDE, (Comparable)((Object)SWEMBlockStateProperties.DoubleBlockSide.LEFT)), 3, 3);
                }
            }
        }
    }

    private DoorHingeSide getHingeSide(BlockPlaceContext context) {
        Level iblockreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        Direction direction = context.m_8125_();
        Direction direction1 = direction.m_122428_();
        BlockPos blockpos2 = blockpos.m_121945_(direction1);
        BlockState blockstate = iblockreader.m_8055_(blockpos2);
        Direction direction2 = direction.m_122427_();
        BlockPos blockpos4 = blockpos.m_121945_(direction2);
        BlockState blockstate2 = iblockreader.m_8055_(blockpos4);
        int i = (blockstate.m_60838_((BlockGetter)iblockreader, blockpos2) ? -1 : 0) + (blockstate2.m_60838_((BlockGetter)iblockreader, blockpos4) ? 1 : 0);
        boolean flag = blockstate.m_60713_((Block)this);
        boolean flag1 = blockstate2.m_60713_((Block)this);
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int j = direction.m_122429_();
                int k = direction.m_122431_();
                Vec3 vector3d = context.m_43720_();
                double d0 = vector3d.f_82479_ - (double)blockpos.m_123341_();
                double d1 = vector3d.f_82481_ - (double)blockpos.m_123343_();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPose, Player pPlayer, InteractionHand handIn, BlockHitResult hit) {
        if (!pLevel.f_46443_) {
            ArrayList<BlockPos> openPositions = this.getAllDoorParts(pState, this.getInvertedOpenPos(pState, pPose), pLevel, (Boolean)pState.m_61143_((Property)OPEN));
            if (pState.m_61143_(SIDE) == SWEMBlockStateProperties.DoubleBlockSide.RIGHT) {
                if (pState.m_61143_(HINGE) == DoorHingeSide.LEFT) {
                    openPositions.remove(1);
                } else {
                    openPositions.remove(0);
                }
            } else if (pState.m_61143_(HINGE) == DoorHingeSide.LEFT) {
                openPositions.remove(0);
            } else {
                openPositions.remove(1);
            }
            boolean shouldOpen = openPositions.stream().allMatch(pos1 -> pLevel.m_8055_(pos1).m_247087_());
            if (shouldOpen) {
                pState = (BlockState)pState.m_61122_((Property)OPEN);
                boolean open = (Boolean)pState.m_61143_((Property)OPEN);
                ArrayList states = new ArrayList();
                ArrayList<BlockPos> positions = this.getAllDoorParts(pState, pPose, pLevel, open);
                positions.forEach(pos1 -> states.add(pLevel.m_8055_(pos1)));
                for (int i = 0; i < 2; ++i) {
                    this.openDoor(pLevel, (BlockState)states.get(i), positions.get(i), open);
                }
                this.playSound(pPlayer, pLevel, pPose, pState);
            } else {
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.m_61143_((Property)OPEN);
    }

    public BlockPos getInvertedOpenPos(BlockState state, BlockPos pos) {
        boolean open;
        if (((SWEMBlockStateProperties.DoubleBlockSide)((Object)state.m_61143_(SIDE))).toString().equals(((DoorHingeSide)state.m_61143_(HINGE)).toString())) {
            return pos;
        }
        boolean bl = open = (Boolean)state.m_61143_((Property)OPEN) == false;
        if (open) {
            switch ((Direction)state.m_61143_((Property)FACING)) {
                case NORTH: {
                    if (state.m_61143_(HINGE) == DoorHingeSide.LEFT) {
                        return pos.m_7918_(-1, 0, -1);
                    }
                    return pos.m_7918_(1, 0, -1);
                }
                case EAST: {
                    if (state.m_61143_(HINGE) == DoorHingeSide.LEFT) {
                        return pos.m_7918_(1, 0, -1);
                    }
                    return pos.m_7918_(1, 0, 1);
                }
                case SOUTH: {
                    if (state.m_61143_(HINGE) == DoorHingeSide.LEFT) {
                        return pos.m_7918_(1, 0, 1);
                    }
                    return pos.m_7918_(-1, 0, 1);
                }
                case WEST: {
                    if (state.m_61143_(HINGE) == DoorHingeSide.LEFT) {
                        return pos.m_7918_(-1, 0, 1);
                    }
                    return pos.m_7918_(-1, 0, -1);
                }
            }
            return pos;
        }
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                if (state.m_61143_(HINGE) == DoorHingeSide.LEFT) {
                    return pos.m_7918_(1, 0, 1);
                }
                return pos.m_7918_(-1, 0, 1);
            }
            case EAST: {
                if (state.m_61143_(HINGE) == DoorHingeSide.LEFT) {
                    return pos.m_7918_(-1, 0, 1);
                }
                return pos.m_7918_(-1, 0, -1);
            }
            case SOUTH: {
                if (state.m_61143_(HINGE) == DoorHingeSide.LEFT) {
                    return pos.m_7918_(-1, 0, -1);
                }
                return pos.m_7918_(1, 0, -1);
            }
            case WEST: {
                if (state.m_61143_(HINGE) == DoorHingeSide.LEFT) {
                    return pos.m_7918_(1, 0, -1);
                }
                return pos.m_7918_(1, 0, 1);
            }
        }
        return pos;
    }

    public void openDoor(Level worldIn, BlockState state, BlockPos pos, boolean open) {
        if (state.m_60713_((Block)this)) {
            if (((DoorHingeSide)state.m_61143_(HINGE)).toString().equals(((SWEMBlockStateProperties.DoubleBlockSide)((Object)state.m_61143_(SIDE))).toString())) {
                worldIn.m_6933_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10, 3);
            } else if (open) {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    case NORTH: {
                        if (state.m_61143_(HINGE) == DoorHingeSide.LEFT) {
                            worldIn.m_7731_(pos.m_7918_(-1, 0, -1), (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
                            break;
                        }
                        worldIn.m_7731_(pos.m_7918_(1, 0, -1), (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
                        break;
                    }
                    case EAST: {
                        if (state.m_61143_(HINGE) == DoorHingeSide.LEFT) {
                            worldIn.m_6933_(pos.m_7918_(1, 0, -1), (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10, 3);
                            break;
                        }
                        worldIn.m_6933_(pos.m_7918_(1, 0, 1), (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10, 3);
                        break;
                    }
                    case SOUTH: {
                        if (state.m_61143_(HINGE) == DoorHingeSide.LEFT) {
                            worldIn.m_6933_(pos.m_7918_(1, 0, 1), (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10, 3);
                            break;
                        }
                        worldIn.m_6933_(pos.m_7918_(-1, 0, 1), (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10, 3);
                        break;
                    }
                    case WEST: {
                        if (state.m_61143_(HINGE) == DoorHingeSide.LEFT) {
                            worldIn.m_6933_(pos.m_7918_(-1, 0, 1), (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10, 3);
                            break;
                        }
                        worldIn.m_6933_(pos.m_7918_(-1, 0, -1), (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10, 3);
                    }
                }
                worldIn.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            } else {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    case NORTH: {
                        if (state.m_61143_(HINGE) == DoorHingeSide.LEFT) {
                            worldIn.m_7731_(pos.m_7918_(1, 0, 1), (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
                            break;
                        }
                        worldIn.m_7731_(pos.m_7918_(-1, 0, 1), (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
                        break;
                    }
                    case EAST: {
                        if (state.m_61143_(HINGE) == DoorHingeSide.LEFT) {
                            worldIn.m_6933_(pos.m_7918_(-1, 0, 1), (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10, 3);
                            break;
                        }
                        worldIn.m_6933_(pos.m_7918_(-1, 0, -1), (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10, 3);
                        break;
                    }
                    case SOUTH: {
                        if (state.m_61143_(HINGE) == DoorHingeSide.LEFT) {
                            worldIn.m_6933_(pos.m_7918_(-1, 0, -1), (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10, 3);
                            break;
                        }
                        worldIn.m_6933_(pos.m_7918_(1, 0, -1), (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10, 3);
                        break;
                    }
                    case WEST: {
                        if (state.m_61143_(HINGE) == DoorHingeSide.LEFT) {
                            worldIn.m_6933_(pos.m_7918_(1, 0, -1), (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10, 3);
                            break;
                        }
                        worldIn.m_6933_(pos.m_7918_(1, 0, 1), (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10, 3);
                    }
                }
                worldIn.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            }
        }
    }

    public ArrayList<BlockPos> getAllDoorParts(BlockState state, BlockPos pos, Level worldIn, boolean opened) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        if (state.m_61143_(HINGE) == DoorHingeSide.LEFT && state.m_61143_(SIDE) == SWEMBlockStateProperties.DoubleBlockSide.LEFT) {
            positions.add(pos);
            positions.add(pos.m_121945_(opened ? direction.m_122427_() : direction));
        } else if (state.m_61143_(HINGE) == DoorHingeSide.LEFT && state.m_61143_(SIDE) == SWEMBlockStateProperties.DoubleBlockSide.RIGHT) {
            positions.add(pos);
            positions.add(pos.m_121945_(opened ? direction.m_122428_() : direction.m_122424_()));
        } else if (state.m_61143_(HINGE) == DoorHingeSide.RIGHT && state.m_61143_(SIDE) == SWEMBlockStateProperties.DoubleBlockSide.LEFT) {
            positions.add(pos);
            positions.add(pos.m_121945_(opened ? direction.m_122427_() : direction.m_122424_()));
        } else if (state.m_61143_(HINGE) == DoorHingeSide.RIGHT && state.m_61143_(SIDE) == SWEMBlockStateProperties.DoubleBlockSide.RIGHT) {
            positions.add(pos);
            positions.add(pos.m_121945_(opened ? direction.m_122428_() : direction));
        }
        return positions;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return this.getAllDoorParts(state, pos, (Level)worldIn, true).stream().allMatch(pos1 -> {
            BlockState state1 = worldIn.m_8055_(pos1);
            return state1 == Blocks.f_50016_.m_49966_();
        });
    }

    private void playSound(Player pPlayer, Level pLevel, BlockPos pPos, BlockState pState) {
        pLevel.m_142346_((Entity)pPlayer, this.isOpen(pState) ? GameEvent.f_157796_ : GameEvent.f_157793_, pPos);
        pLevel.m_5594_(null, pPos, this.isOpen(pState) ? this.type.f_271141_() : this.type.f_271502_(), SoundSource.BLOCKS, 1.0f, pLevel.m_213780_().m_188501_() * 0.1f + 0.9f);
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : (BlockState)state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING))).m_61122_(HINGE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public long m_7799_(BlockState state, BlockPos pos) {
        return Mth.m_14130_((int)pos.m_123341_(), (int)pos.m_123342_(), (int)pos.m_123343_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN, HINGE, SIDE});
    }
}

