/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.blocks;

import com.alaharranhonor.swem.forge.blocks.SWEMBlockStateProperties;
import com.alaharranhonor.swem.forge.community.TackType;
import com.alaharranhonor.swem.forge.items.tack.TackItem;
import com.alaharranhonor.swem.forge.registry.BlockEntitySetup;
import com.alaharranhonor.swem.forge.tileentity.HorseArmorRackBE;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class HorseArmorRackBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final EnumProperty<SWEMBlockStateProperties.DoubleBlockSide> SIDE = SWEMBlockStateProperties.D_SIDE;

    public HorseArmorRackBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(SIDE, (Comparable)((Object)SWEMBlockStateProperties.DoubleBlockSide.LEFT)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity tile;
        if (level.m_5776_() || handIn != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        BlockPos position = pos;
        if (state.m_61143_(SIDE) == SWEMBlockStateProperties.DoubleBlockSide.RIGHT) {
            position = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122427_());
        }
        if (!((tile = level.m_7702_(position)) instanceof HorseArmorRackBE)) {
            return InteractionResult.PASS;
        }
        HorseArmorRackBE rack = (HorseArmorRackBE)tile;
        if (!rack.hasOwner()) {
            rack.setOwner(player);
        }
        if (player.m_6144_() && rack.canModifyLocks(player)) {
            if (!level.m_5776_()) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)rack, buffer -> buffer.m_130064_(rack.m_58899_()));
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (!rack.canAccess(player)) {
            return InteractionResult.PASS;
        }
        ItemStack held = player.m_21120_(handIn);
        Optional cap = rack.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve();
        if (cap.isEmpty()) {
            return InteractionResult.FAIL;
        }
        IItemHandler handler = (IItemHandler)cap.get();
        if (TackType.HORSE_ARMOR.is(held)) {
            if (!handler.getStackInSlot(0).m_41619_()) {
                return InteractionResult.PASS;
            }
            if (!handler.isItemValid(0, held)) {
                return InteractionResult.PASS;
            }
            ItemStack armorCopy = player.m_7500_() ? held.m_41777_().m_41620_(1) : held.m_41620_(1);
            handler.insertItem(0, armorCopy, false);
            level.m_5594_(null, pos, SoundEvents.f_11678_, SoundSource.NEUTRAL, 0.5f, 1.0f);
            PacketDistributor.TRACKING_CHUNK.with(() -> rack.m_58904_().m_46745_(rack.m_58899_())).send(rack.m_58483_());
            return InteractionResult.SUCCESS;
        }
        if (TackType.SADDLE.is(held) && ((TackItem)held.m_41720_()).getData().canWearArmor()) {
            if (!handler.getStackInSlot(1).m_41619_()) {
                return InteractionResult.PASS;
            }
            if (!handler.isItemValid(1, held)) {
                return InteractionResult.PASS;
            }
            ItemStack saddleCopy = player.m_7500_() ? held.m_41777_().m_41620_(1) : held.m_41620_(1);
            handler.insertItem(1, saddleCopy, false);
            level.m_5594_(null, pos, SoundEvents.f_11678_, SoundSource.NEUTRAL, 0.5f, 1.0f);
            PacketDistributor.TRACKING_CHUNK.with(() -> rack.m_58904_().m_46745_(rack.m_58899_())).send(rack.m_58483_());
            return InteractionResult.SUCCESS;
        }
        if (handler.getStackInSlot(0).m_41619_() && handler.getStackInSlot(1).m_41619_()) {
            return InteractionResult.PASS;
        }
        if (!handler.getStackInSlot(1).m_41619_()) {
            ItemStack stack = handler.extractItem(1, 64, false);
            ItemEntity itementity = new ItemEntity(level, (double)rack.m_58899_().m_123341_(), (double)rack.m_58899_().m_123342_(), (double)rack.m_58899_().m_123343_(), stack);
            itementity.m_20334_(level.f_46441_.m_188583_() * (double)0.05f, level.f_46441_.m_188583_() * (double)0.05f + (double)0.2f, level.f_46441_.m_188583_() * (double)0.05f);
            level.m_7967_((Entity)itementity);
            level.m_5594_(null, pos, SoundEvents.f_11678_, SoundSource.NEUTRAL, 0.5f, 1.0f);
            PacketDistributor.TRACKING_CHUNK.with(() -> rack.m_58904_().m_46745_(rack.m_58899_())).send(rack.m_58483_());
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = handler.extractItem(0, 64, false);
        ItemEntity itementity = new ItemEntity(level, (double)rack.m_58899_().m_123341_(), (double)rack.m_58899_().m_123342_(), (double)rack.m_58899_().m_123343_(), stack);
        itementity.m_20334_(level.f_46441_.m_188583_() * (double)0.05f, level.f_46441_.m_188583_() * (double)0.05f + (double)0.2f, level.f_46441_.m_188583_() * (double)0.05f);
        level.m_7967_((Entity)itementity);
        level.m_5594_(null, pos, SoundEvents.f_11678_, SoundSource.NEUTRAL, 0.5f, 1.0f);
        PacketDistributor.TRACKING_CHUNK.with(() -> rack.m_58904_().m_46745_(rack.m_58899_())).send(rack.m_58483_());
        return InteractionResult.SUCCESS;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (!level.f_46443_) {
            BlockPos blockpos = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122428_());
            level.m_7731_(blockpos, (BlockState)state.m_61124_(SIDE, (Comparable)((Object)SWEMBlockStateProperties.DoubleBlockSide.RIGHT)), 3);
            level.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)level, pos, 3);
        }
        if (placer instanceof Player) {
            Player player = (Player)placer;
            BlockPos position = pos;
            if (state.m_61143_(SIDE) == SWEMBlockStateProperties.DoubleBlockSide.RIGHT) {
                position = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122427_());
            }
            level.m_141902_(position, (BlockEntityType)BlockEntitySetup.HORSE_ARMOR_RACK_BLOCK_ENTITY.get()).ifPresent(rack -> rack.setOwner(player));
        }
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing == HorseArmorRackBlock.getNeighbourDirection((SWEMBlockStateProperties.DoubleBlockSide)((Object)pState.m_61143_(SIDE)), ((Direction)pState.m_61143_((Property)f_54117_)).m_122428_())) {
            return pFacingState.m_60713_((Block)this) && pFacingState.m_61143_(SIDE) != pState.m_61143_(SIDE) ? pState : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    private static Direction getNeighbourDirection(SWEMBlockStateProperties.DoubleBlockSide pPart, Direction pDirection) {
        return pPart == SWEMBlockStateProperties.DoubleBlockSide.LEFT ? pDirection : pDirection.m_122424_();
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.m_5776_()) {
            if (player.m_7500_()) {
                this.preventCreativeDropFromOtherHalf(worldIn, pos, state, player);
            } else {
                HorseArmorRackBlock.m_49881_((BlockState)state, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21120_(player.m_7655_()));
            }
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public void m_6240_(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, @Nullable BlockEntity pTe, ItemStack pStack) {
        super.m_6240_(pLevel, pPlayer, pPos, Blocks.f_50016_.m_49966_(), pTe, pStack);
    }

    protected void preventCreativeDropFromOtherHalf(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockPos blockpos;
        BlockState blockstate;
        SWEMBlockStateProperties.DoubleBlockSide side = (SWEMBlockStateProperties.DoubleBlockSide)((Object)pState.m_61143_(SIDE));
        if (side == SWEMBlockStateProperties.DoubleBlockSide.RIGHT && (blockstate = pLevel.m_8055_(blockpos = pPos.m_121945_(HorseArmorRackBlock.getNeighbourDirection(side, ((Direction)pState.m_61143_((Property)f_54117_)).m_122428_())))).m_60734_() == this && blockstate.m_61143_(SIDE) == SWEMBlockStateProperties.DoubleBlockSide.LEFT) {
            pLevel.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            pLevel.m_5898_(pPlayer, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity tileentity = pLevel.m_7702_(pPos);
            if (tileentity instanceof HorseArmorRackBE) {
                ((HorseArmorRackBE)tileentity).dropItems();
                pLevel.m_46717_(pPos, (Block)this);
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83048_((double)0.01, (double)0.01, (double)0.01, (double)0.99, (double)0.99, (double)0.99);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return true;
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_().m_122424_().m_122428_();
        BlockPos blockpos = context.m_8083_();
        BlockPos blockpos1 = blockpos.m_121945_(context.m_8125_());
        return context.m_43725_().m_8055_(blockpos1).m_60629_(context) ? (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction) : null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, SIDE});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new HorseArmorRackBE(p_153215_, p_153216_);
    }
}

