/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.blocks;

import com.alaharranhonor.swem.forge.tileentity.GrainBinBE;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

public class GrainBinBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;

    public GrainBinBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, OPEN});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122424_());
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return super.m_6227_(state, level, pos, player, hand, hitResult);
        }
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.FAIL;
        }
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof GrainBinBE)) {
            return super.m_6227_(state, level, pos, player, hand, hitResult);
        }
        GrainBinBE bin = (GrainBinBE)be;
        ItemStack held = player.m_21120_(hand);
        if (!held.m_41619_()) {
            boolean inserted = bin.putFeed(player, held);
            if (inserted && !level.m_5776_()) {
                player.m_21008_(hand, held);
            }
            return inserted ? InteractionResult.m_19078_((boolean)level.m_5776_()) : InteractionResult.FAIL;
        }
        ItemStack extracted = bin.removeFeed();
        if (!extracted.m_41619_()) {
            if (!level.m_5776_()) {
                player.m_150109_().m_150079_(extracted);
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pBuilder) {
        List drops = super.m_49635_(pState, pBuilder);
        BlockEntity be = (BlockEntity)pBuilder.m_287159_(LootContextParams.f_81462_);
        if (be instanceof GrainBinBE) {
            int stackAmount;
            GrainBinBE bin = (GrainBinBE)be;
            for (int amount = bin.getFeedAmount(); amount > 0; amount -= stackAmount) {
                ItemStack feedDrop = bin.getFeedInBin().m_41777_();
                stackAmount = Math.min(amount, feedDrop.m_41741_());
                feedDrop.m_41764_(stackAmount);
                drops.add(feedDrop);
            }
        }
        return drops;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new GrainBinBE(pPos, pState);
    }

    @Mod.EventBusSubscriber(modid="swem")
    public static class Events {
        @SubscribeEvent
        public static void openOrCloseBin(PlayerInteractEvent.RightClickBlock event) {
            if (!event.getEntity().m_6144_()) {
                return;
            }
            if (event.getHand() == InteractionHand.OFF_HAND) {
                return;
            }
            BlockPos pos = event.getPos();
            BlockState state = event.getLevel().m_8055_(pos);
            if (state.m_60734_() instanceof GrainBinBlock) {
                event.getLevel().m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)OPEN) == false)), 3);
                event.setCanceled(true);
            }
        }
    }
}

