/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.blocks;

import com.alaharranhonor.swem.forge.registry.BlockEntitySetup;
import com.alaharranhonor.swem.forge.registry.ItemSetup;
import com.alaharranhonor.swem.forge.tileentity.CowboyHatBE;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CowboyHatBlock
extends BaseEntityBlock {
    private static final VoxelShape SHAPE = Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.4375, (double)0.9375);
    private static final Map<Direction, VoxelShape> WALL_SHAPES = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83048_((double)0.0625, (double)0.0625, (double)0.4375, (double)0.9375, (double)0.9375, (double)1.0));
            this.put(Direction.EAST, Shapes.m_83048_((double)0.0, (double)0.0625, (double)0.0625, (double)0.4375, (double)0.9375, (double)0.9375));
            this.put(Direction.SOUTH, Shapes.m_83048_((double)0.0625, (double)0.0625, (double)0.0, (double)0.9375, (double)0.9375, (double)0.4375));
            this.put(Direction.WEST, Shapes.m_83048_((double)0.4375, (double)0.0625, (double)0.0625, (double)1.0, (double)0.9375, (double)0.9375));
        }
    };
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty ON_WALL = BlockStateProperties.f_61386_;
    private final Supplier<String> texturePath;

    public CowboyHatBlock(Supplier<String> texturePath, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.texturePath = texturePath;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ON_WALL, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ON_WALL});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        boolean placedOnWall = ctx.m_43719_().m_122434_().m_122479_();
        if (!placedOnWall) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)ON_WALL, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FACING, (Comparable)ctx.m_43719_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return (Boolean)state.m_61143_((Property)ON_WALL) != false ? WALL_SHAPES.get(state.m_61143_((Property)FACING)) : SHAPE;
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        super.m_5707_(pLevel, pPos, pState, pPlayer);
        SoundType sound = this.getSoundType(pState, (LevelReader)pLevel, pPos, (Entity)pPlayer);
        pLevel.m_5594_(pPlayer, pPos, sound.m_56775_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder builder) {
        List drops = super.m_49635_(pState, builder);
        Object object = builder.m_287261_(LootContextParams.f_81462_);
        if (object instanceof CowboyHatBE) {
            CowboyHatBE hat = (CowboyHatBE)((Object)object);
            drops.add(hat.getHat());
        }
        return drops;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return level.m_141902_(pos, (BlockEntityType)BlockEntitySetup.COWBOY_HAT.get()).map(hat -> {
            ItemStack stack = hat.getHat().m_41777_();
            stack.m_41721_(0);
            return stack;
        }).orElse(new ItemStack((ItemLike)ItemSetup.COWBOY_HAT.get()));
    }

    protected void m_142387_(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState) {
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CowboyHatBE(this.texturePath.get(), pos, state);
    }
}

