/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.source;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.position.Pos3d;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.server.PlasmoBaseVoiceServer;
import su.plo.voice.api.server.audio.line.BaseServerSourceLine;
import su.plo.voice.api.server.audio.provider.AudioFrameProvider;
import su.plo.voice.api.server.audio.source.AudioSender;
import su.plo.voice.api.server.audio.source.BaseServerDirectSource;
import su.plo.voice.api.server.connection.UdpConnectionManager;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.api.server.socket.UdpConnection;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.audio.source.DirectSourceInfo;
import su.plo.voice.proto.packets.tcp.clientbound.SourceInfoPacket;
import su.plo.voice.server.audio.source.BaseServerAudioSource;

public abstract class VoiceBaseServerDirectSource
extends BaseServerAudioSource<DirectSourceInfo>
implements BaseServerDirectSource {
    protected final PlasmoBaseVoiceServer voiceServer;
    protected final UdpConnectionManager<? extends VoicePlayer, ? extends UdpConnection> udpConnections;
    @Nullable
    private VoicePlayer sender;
    @Nullable
    private Pos3d relativePosition;
    @Nullable
    private Pos3d lookAngle;
    private boolean cameraRelative = true;
    private int angle;

    public VoiceBaseServerDirectSource(@NotNull PlasmoBaseVoiceServer voiceServer, @NotNull UdpConnectionManager<? extends VoicePlayer, ? extends UdpConnection> udpConnections, @NotNull AddonContainer addon, @NotNull BaseServerSourceLine line, @Nullable CodecInfo decoderInfo, boolean stereo) {
        super(addon, UUID.randomUUID(), line, decoderInfo, stereo);
        this.voiceServer = voiceServer;
        this.udpConnections = udpConnections;
    }

    @Override
    @Nullable
    public VoicePlayer getSender() {
        return this.sender;
    }

    @Override
    public void setSender(@Nullable VoicePlayer player) {
        this.sender = player;
        this.updateSourceInfo();
    }

    @Override
    @Nullable
    public Pos3d getRelativePosition() {
        return this.relativePosition;
    }

    @Override
    public void setRelativePosition(@Nullable Pos3d position) {
        this.relativePosition = position;
        this.updateSourceInfo();
    }

    @Override
    @Nullable
    public Pos3d getLookAngle() {
        return this.lookAngle;
    }

    @Override
    public void setLookAngle(@NotNull Pos3d position) {
        this.lookAngle = position;
        this.updateSourceInfo();
    }

    @Override
    public boolean isCameraRelative() {
        return this.cameraRelative;
    }

    @Override
    public void setCameraRelative(boolean cameraRelative) {
        this.cameraRelative = cameraRelative;
        this.updateSourceInfo();
    }

    @Override
    @NotNull
    public DirectSourceInfo getSourceInfo() {
        return new DirectSourceInfo(this.addon.getId(), this.id, this.line.getId(), this.name, (byte)this.state.get(), this.decoderInfo, this.stereo, this.iconVisible, this.angle, this.sender == null ? null : this.sender.getInstance().getGameProfile(), this.relativePosition, this.lookAngle, this.cameraRelative);
    }

    @Override
    @NotNull
    public AudioSender createAudioSender(@NotNull AudioFrameProvider frameProvider) {
        return new AudioSender(frameProvider, this::sendAudioFrame, this::sendAudioEnd);
    }

    @Override
    @NotNull
    public CompletableFuture<DirectSourceInfo> resolveSourceInfo() {
        return CompletableFuture.completedFuture(this.getSourceInfo());
    }

    protected void updateSourceInfo() {
        this.sendPacket(new SourceInfoPacket(this.getSourceInfo()));
    }

    public void setAngle(int angle) {
        this.angle = angle;
    }

    public int getAngle() {
        return this.angle;
    }
}

