/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.render.voice;

import com.mojang.blaze3d.platform.Window;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.mod.client.ResourceLocationUtil;
import su.plo.lib.mod.client.render.LazyGlState;
import su.plo.lib.mod.client.render.gui.GuiRenderContext;
import su.plo.lib.mod.client.render.pipeline.RenderPipelines;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.capture.ClientActivation;
import su.plo.voice.api.client.config.IconPosition;
import su.plo.voice.api.client.event.render.HudActivationRenderEvent;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.event.HudRenderEvent;
import su.plo.voice.proto.data.audio.capture.Activation;

public final class HudIconRenderer
implements HudRenderEvent.Callback {
    private static final ResourceLocation MICROPHONE_DISCONNECTED_ICON = ResourceLocationUtil.parse("plasmovoice:textures/icons/microphone_disconnected.png");
    private static final ResourceLocation MICROPHONE_MUTED_ICON = ResourceLocationUtil.parse("plasmovoice:textures/icons/microphone_muted.png");
    private static final ResourceLocation MICROPHONE_DISABLED_ICON = ResourceLocationUtil.parse("plasmovoice:textures/icons/microphone_disabled.png");
    private static final ResourceLocation SPEAKER_DISABLED_ICON = ResourceLocationUtil.parse("plasmovoice:textures/icons/speaker_disabled.png");
    private final PlasmoVoiceClient voiceClient;
    private final VoiceClientConfig config;
    @NotNull
    private final LazyGlState glState = new LazyGlState();

    @Override
    public void onRender(@NotNull GuiRenderContext context, float delta) {
        if (!this.voiceClient.getServerInfo().isPresent() || !this.voiceClient.getUdpClientManager().getClient().isPresent() || Minecraft.m_91087_().f_91074_ == null || !((Boolean)this.config.getOverlay().getShowActivationIcon().value()).booleanValue() || Minecraft.m_91087_().f_91066_.f_92062_) {
            return;
        }
        if (this.voiceClient.getUdpClientManager().getClient().get().isTimedOut()) {
            this.renderIcon(context, MICROPHONE_DISCONNECTED_ICON);
            return;
        }
        if (((Boolean)this.config.getVoice().getDisabled().value()).booleanValue()) {
            this.renderIcon(context, SPEAKER_DISABLED_ICON);
            return;
        }
        if (this.voiceClient.getAudioCapture().isServerMuted()) {
            this.renderIcon(context, MICROPHONE_MUTED_ICON);
            return;
        }
        if (((Boolean)this.config.getVoice().getMicrophoneDisabled().value()).booleanValue()) {
            this.renderIcon(context, MICROPHONE_DISABLED_ICON);
            return;
        }
        List activations = (List)this.voiceClient.getActivationManager().getActivations();
        Activation currentActivation = null;
        for (int index = activations.size() - 1; index >= 0; --index) {
            ClientActivation activation = (ClientActivation)activations.get(index);
            HudActivationRenderEvent renderEvent = new HudActivationRenderEvent(activation, activation.isActive());
            this.voiceClient.getEventBus().fire(renderEvent);
            if (!renderEvent.isRender()) continue;
            currentActivation = activation;
            if (!activation.isTransitive()) break;
        }
        if (currentActivation != null) {
            this.renderIcon(context, ResourceLocationUtil.parse(currentActivation.getIcon()));
        }
    }

    private void renderIcon(@NotNull GuiRenderContext context, @NotNull ResourceLocation iconLocation) {
        IconPosition iconPosition = (IconPosition)((Object)this.config.getOverlay().getActivationIconPosition().value());
        context.getStack().m_85836_();
        context.getStack().m_252880_(0.0f, 0.0f, 1000.0f);
        this.glState.withState(() -> context.blit(iconLocation, this.calcIconX(iconPosition.getX()), this.calcIconY(iconPosition.getY()), 0.0f, 0.0f, 16, 16, 16, 16, RenderPipelines.GUI_TEXTURE_OVERLAY));
        context.getStack().m_85849_();
    }

    private int calcIconX(Integer x) {
        Window window = Minecraft.m_91087_().m_91268_();
        if (x == null) {
            return window.m_85445_() / 2 - 8;
        }
        if (x < 0) {
            return window.m_85445_() + x - 16;
        }
        return x;
    }

    private int calcIconY(Integer y) {
        Window window = Minecraft.m_91087_().m_91268_();
        if (y == null) {
            return window.m_85446_() - 32;
        }
        if (y < 0) {
            return window.m_85446_() + y - 16;
        }
        return y;
    }

    public HudIconRenderer(PlasmoVoiceClient voiceClient, VoiceClientConfig config) {
        this.voiceClient = voiceClient;
        this.config = config;
    }
}

