/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice;

import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.event.EventNetworkChannel;
import su.plo.slib.mod.channel.ModChannelManager;
import su.plo.voice.client.ModVoiceClient;
import su.plo.voice.server.ModVoiceServer;
import su.plo.voice.util.version.PlatformLoader;

@Mod(value="plasmovoice")
public final class ModVoice {
    private EventNetworkChannel channel;

    public ModVoice() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    @SubscribeEvent
    public void onClientSetup(FMLClientSetupEvent event) {
        ModVoiceClient voiceClient = new ModVoiceClient();
        MinecraftForge.EVENT_BUS.register((Object)voiceClient);
        voiceClient.onInitialize(this.channel);
    }

    @SubscribeEvent
    public void onCommonSetup(FMLCommonSetupEvent event) {
        this.channel = this.createChannel(ModVoiceServer.CHANNEL);
        this.createChannel(ModVoiceServer.FLAG_CHANNEL);
        EventNetworkChannel serviceChannel = this.createChannel(ModVoiceServer.SERVICE_CHANNEL);
        ModChannelManager.addForgeChannel(ModVoiceServer.CHANNEL, this.channel);
        ModChannelManager.addForgeChannel(ModVoiceServer.SERVICE_CHANNEL, serviceChannel);
        ModVoiceServer voiceServer = new ModVoiceServer(PlatformLoader.FORGE);
        voiceServer.onInitialize();
    }

    private EventNetworkChannel createChannel(ResourceLocation resourceLocation) {
        return NetworkRegistry.ChannelBuilder.named((ResourceLocation)resourceLocation).networkProtocolVersion(() -> NetworkRegistry.ACCEPTVANILLA).clientAcceptedVersions(NetworkRegistry.acceptMissingOr((String)NetworkRegistry.ACCEPTVANILLA)).serverAcceptedVersions(NetworkRegistry.acceptMissingOr((String)NetworkRegistry.ACCEPTVANILLA)).eventNetworkChannel();
    }
}

