/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.gui.screen;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.mod.client.gui.screen.GuiScreenListener;
import su.plo.lib.mod.client.gui.screen.ScreenWrapper;
import su.plo.lib.mod.client.gui.widget.GuiNarrationWidget;
import su.plo.lib.mod.client.gui.widget.GuiWidget;
import su.plo.lib.mod.client.gui.widget.GuiWidgetListener;
import su.plo.lib.mod.client.render.gui.GuiRenderContext;
import su.plo.slib.api.chat.component.McTextComponent;

public abstract class GuiScreen
implements GuiWidget,
GuiScreenListener {
    protected static final Minecraft minecraft = Minecraft.m_91087_();
    private final List<GuiWidget> renderWidgets = Lists.newArrayList();
    private final List<GuiWidgetListener> widgets = Lists.newArrayList();
    private final List<GuiNarrationWidget> narrationWidgets = Lists.newArrayList();
    protected ScreenWrapper screen;
    private GuiWidgetListener focused;
    private boolean dragging;
    @Nullable
    private GuiNarrationWidget lastNarration;

    @Override
    public void render(@NotNull GuiRenderContext context, int mouseX, int mouseY, float delta) {
        for (GuiWidget widget : this.renderWidgets) {
            widget.render(context, mouseX, mouseY, delta);
        }
    }

    @Override
    public List<? extends GuiWidgetListener> widgets() {
        return this.widgets;
    }

    public void setMinecraftScreen(@NotNull ScreenWrapper screen) {
        this.screen = screen;
    }

    @NotNull
    public ScreenWrapper getMinecraftScreen() {
        return this.screen;
    }

    public <T extends GuiWidgetListener & GuiWidget> T addRenderWidget(T widget) {
        this.renderWidgets.add(widget);
        return this.addWidget(widget);
    }

    public <T extends GuiWidget> T addRenderOnlyWidget(T widget) {
        this.renderWidgets.add(widget);
        return widget;
    }

    public <T extends GuiWidgetListener> T addWidget(T widget) {
        this.widgets.add(widget);
        if (widget instanceof GuiNarrationWidget) {
            this.narrationWidgets.add((GuiNarrationWidget)((Object)widget));
        }
        return widget;
    }

    public void removeWidget(GuiWidgetListener widget) {
        if (widget instanceof GuiWidget) {
            this.renderWidgets.remove(widget);
        }
        this.widgets.remove(widget);
    }

    public void clearWidgets() {
        this.renderWidgets.clear();
        this.widgets.clear();
    }

    @Nullable
    public NarrationSearchResult findNarrationWidget(List<? extends GuiNarrationWidget> list, @Nullable GuiNarrationWidget entry) {
        NarrationSearchResult searchResult = null;
        NarrationSearchResult searchResult1 = null;
        int j = list.size();
        for (int index = 0; index < j; ++index) {
            GuiNarrationWidget entry2 = list.get(index);
            GuiNarrationWidget.NarrationPriority narrationPriority = entry2.narrationPriority();
            if (narrationPriority.isTerminal()) {
                if (entry2 != entry) {
                    return new NarrationSearchResult(entry2, index, narrationPriority);
                }
                searchResult1 = new NarrationSearchResult(entry2, index, narrationPriority);
                continue;
            }
            if (narrationPriority.compareTo(searchResult != null ? searchResult.priority : GuiNarrationWidget.NarrationPriority.NONE) <= 0) continue;
            searchResult = new NarrationSearchResult(entry2, index, narrationPriority);
        }
        return searchResult != null ? searchResult : searchResult1;
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    public void tick() {
    }

    public void init() {
    }

    public void removed() {
    }

    @Override
    public int getWidth() {
        return this.screen.f_96543_;
    }

    @Override
    public int getHeight() {
        return this.screen.f_96544_;
    }

    public McTextComponent getTitle() {
        return McTextComponent.empty();
    }

    @Override
    public GuiWidgetListener getFocused() {
        return this.focused;
    }

    @Override
    public void setFocused(GuiWidgetListener focused) {
        this.focused = focused;
    }

    @Override
    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    public static class NarrationSearchResult {
        public final GuiNarrationWidget entry;
        public final int index;
        public final GuiNarrationWidget.NarrationPriority priority;

        public NarrationSearchResult(GuiNarrationWidget entry, int index, GuiNarrationWidget.NarrationPriority narrationPriority) {
            this.entry = entry;
            this.index = index;
            this.priority = narrationPriority;
        }
    }
}

