/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.registery;

import com.yahoo.chirpycricket.mythicmounts.config.Settings;
import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.mounts.AcenciaEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.mounts.ArchelonEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.mounts.ColelytraEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.mounts.CourierBirdEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.mounts.DireWolfEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.mounts.DragonEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.mounts.FirebirdEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.mounts.GriffonEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.mounts.GroundLizardEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.mounts.MothEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.mounts.NetherBatEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.mounts.NightmareEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.mounts.NudibranchEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.mounts.RidingLizardEntity;
import com.yahoo.chirpycricket.mythicmounts.items.FirebirdFeather;
import com.yahoo.chirpycricket.mythicmounts.items.SummoningStaff;
import com.yahoo.chirpycricket.mythicmounts.registery.SpawnSettings;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class Entities {
    public static final DeferredRegister<EntityType<?>> ENTITY_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"mythicmounts");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"mythicmounts");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"mythicmounts");
    public static final ResourceLocation SUMMONING_STAFF_ID = new ResourceLocation("mythicmounts", "summoning_staff");
    public static final RegistryObject<Item> SUMMONING_STAFF_ITEM = ITEMS.register(SUMMONING_STAFF_ID.m_135815_(), () -> new SummoningStaff(new Item.Properties().m_41487_(1)));
    public static final ResourceLocation FIREBIRD_FEATHER_ID = new ResourceLocation("mythicmounts", "firebird_feather");
    public static final RegistryObject<Block> FIREBIRD_FEATHER = BLOCKS.register(FIREBIRD_FEATHER_ID.m_135815_(), () -> new FirebirdFeather(BlockBehaviour.Properties.m_284310_().m_60953_(p_60929_ -> 15).m_60966_().m_60955_().m_60910_()));
    public static final RegistryObject<Item> FIREBIRD_FEATHER_ITEM = ITEMS.register(FIREBIRD_FEATHER_ID.m_135815_(), () -> new BlockItem((Block)FIREBIRD_FEATHER.get(), new Item.Properties()));
    public static final ResourceLocation FIREBIRD_FEATHER_ID2 = new ResourceLocation("mythicmounts", "firebird_feather2");
    public static final RegistryObject<Block> FIREBIRD_FEATHER2 = BLOCKS.register(FIREBIRD_FEATHER_ID2.m_135815_(), () -> new FirebirdFeather(BlockBehaviour.Properties.m_284310_().m_60953_(p_60929_ -> 15).m_60966_().m_60955_().m_60910_()));
    public static final RegistryObject<Item> FIREBIRD_FEATHER_ITEM2 = ITEMS.register(FIREBIRD_FEATHER_ID2.m_135815_(), () -> new BlockItem((Block)FIREBIRD_FEATHER2.get(), new Item.Properties()));
    public static final ResourceLocation FIREBIRD_FEATHER_ID3 = new ResourceLocation("mythicmounts", "firebird_feather3");
    public static final RegistryObject<Block> FIREBIRD_FEATHER3 = BLOCKS.register(FIREBIRD_FEATHER_ID3.m_135815_(), () -> new FirebirdFeather(BlockBehaviour.Properties.m_284310_().m_60953_(p_60929_ -> 15).m_60966_().m_60955_().m_60910_()));
    public static final RegistryObject<Item> FIREBIRD_FEATHER_ITEM3 = ITEMS.register(FIREBIRD_FEATHER_ID3.m_135815_(), () -> new BlockItem((Block)FIREBIRD_FEATHER3.get(), new Item.Properties()));
    public static final ResourceLocation FIREBIRD_FEATHER_ID4 = new ResourceLocation("mythicmounts", "firebird_feather4");
    public static final RegistryObject<Block> FIREBIRD_FEATHER4 = BLOCKS.register(FIREBIRD_FEATHER_ID4.m_135815_(), () -> new FirebirdFeather(BlockBehaviour.Properties.m_284310_().m_60953_(p_60929_ -> 15).m_60966_().m_60955_().m_60910_()));
    public static final RegistryObject<Item> FIREBIRD_FEATHER_ITEM4 = ITEMS.register(FIREBIRD_FEATHER_ID4.m_135815_(), () -> new BlockItem((Block)FIREBIRD_FEATHER4.get(), new Item.Properties()));
    public static final Item.Properties eggItemSettings = new Item.Properties();
    public static RegistryObject<EntityType<MountEntity>> ACENCIA_ENTITY = EntityInfo.buildEntity(EntityKey.ACENCIA);
    public static final RegistryObject<Item> ACENCIA_EGG_ITEM = ITEMS.register(EntityInfo.ACENCIA.path + "_spawn_egg", () -> new ForgeSpawnEggItem(ACENCIA_ENTITY, EntityInfo.ACENCIA.spawnEggColor, EntityInfo.ACENCIA.spawnEggSpotColor, eggItemSettings));
    public static RegistryObject<EntityType<MountEntity>> ARCHELON_ENTITY = EntityInfo.buildEntity(EntityKey.ARCHELON);
    public static final RegistryObject<Item> ARCHELON_EGG_ITEM = ITEMS.register(EntityInfo.ARCHELON.path + "_spawn_egg", () -> new ForgeSpawnEggItem(ARCHELON_ENTITY, EntityInfo.ARCHELON.spawnEggColor, EntityInfo.ARCHELON.spawnEggSpotColor, eggItemSettings));
    public static RegistryObject<EntityType<MountEntity>> NETHER_BAT_ENTITY = EntityInfo.buildEntity(EntityKey.NETHER_BAT);
    public static final RegistryObject<Item> NETHER_BAT_EGG_ITEM = ITEMS.register(EntityInfo.NETHER_BAT.path + "_spawn_egg", () -> new ForgeSpawnEggItem(NETHER_BAT_ENTITY, EntityInfo.NETHER_BAT.spawnEggColor, EntityInfo.NETHER_BAT.spawnEggSpotColor, eggItemSettings));
    public static RegistryObject<EntityType<MountEntity>> COURIER_BIRD_ENTITY = EntityInfo.buildEntity(EntityKey.COURIER_BIRD);
    public static final RegistryObject<Item> COURIER_BIRD_EGG_ITEM = ITEMS.register(EntityInfo.COURIER_BIRD.path + "_spawn_egg", () -> new ForgeSpawnEggItem(COURIER_BIRD_ENTITY, EntityInfo.COURIER_BIRD.spawnEggColor, EntityInfo.COURIER_BIRD.spawnEggSpotColor, eggItemSettings));
    public static RegistryObject<EntityType<MountEntity>> DRAGON_ENTITY = EntityInfo.buildEntity(EntityKey.DRAGON);
    public static final RegistryObject<Item> DRAGON_EGG_ITEM = ITEMS.register(EntityInfo.DRAGON.path + "_spawn_egg", () -> new ForgeSpawnEggItem(DRAGON_ENTITY, EntityInfo.DRAGON.spawnEggColor, EntityInfo.DRAGON.spawnEggSpotColor, eggItemSettings));
    public static RegistryObject<EntityType<MountEntity>> GRIFFON_ENTITY = EntityInfo.buildEntity(EntityKey.GRIFFON);
    public static final RegistryObject<Item> GRIFFON_EGG_ITEM = ITEMS.register(EntityInfo.GRIFFON.path + "_spawn_egg", () -> new ForgeSpawnEggItem(GRIFFON_ENTITY, EntityInfo.GRIFFON.spawnEggColor, EntityInfo.GRIFFON.spawnEggSpotColor, eggItemSettings));
    public static RegistryObject<EntityType<MountEntity>> GECKOTOA_ENTITY = EntityInfo.buildEntity(EntityKey.GECKOTOA);
    public static final RegistryObject<Item> GECKOTOA_EGG_ITEM = ITEMS.register(EntityInfo.GECKOTOA.path + "_spawn_egg", () -> new ForgeSpawnEggItem(GECKOTOA_ENTITY, EntityInfo.GECKOTOA.spawnEggColor, EntityInfo.GECKOTOA.spawnEggSpotColor, eggItemSettings));
    public static RegistryObject<EntityType<MountEntity>> MOTH_ENTITY = EntityInfo.buildEntity(EntityKey.MOTH);
    public static final RegistryObject<Item> MOTH_EGG_ITEM = ITEMS.register(EntityInfo.MOTH.path + "_spawn_egg", () -> new ForgeSpawnEggItem(MOTH_ENTITY, EntityInfo.MOTH.spawnEggColor, EntityInfo.MOTH.spawnEggSpotColor, eggItemSettings));
    public static RegistryObject<EntityType<MountEntity>> NIGHTMARE_ENTITY = EntityInfo.buildEntity(EntityKey.NIGHTMARE);
    public static final RegistryObject<Item> NIGHTMARE_EGG_ITEM = ITEMS.register(EntityInfo.NIGHTMARE.path + "_spawn_egg", () -> new ForgeSpawnEggItem(NIGHTMARE_ENTITY, EntityInfo.NIGHTMARE.spawnEggColor, EntityInfo.NIGHTMARE.spawnEggSpotColor, eggItemSettings));
    public static RegistryObject<EntityType<MountEntity>> NUDIBRANCH_ENTITY = EntityInfo.buildEntity(EntityKey.NUDIBRANCH);
    public static final RegistryObject<Item> NUDIBRANCH_EGG_ITEM = ITEMS.register(EntityInfo.NUDIBRANCH.path + "_spawn_egg", () -> new ForgeSpawnEggItem(NUDIBRANCH_ENTITY, EntityInfo.NUDIBRANCH.spawnEggColor, EntityInfo.NUDIBRANCH.spawnEggSpotColor, eggItemSettings));
    public static RegistryObject<EntityType<MountEntity>> RIDING_LIZARD_ENTITY = EntityInfo.buildEntity(EntityKey.RIDING_LIZARD);
    public static final RegistryObject<Item> RIDING_LIZARD_EGG_ITEM = ITEMS.register(EntityInfo.RIDING_LIZARD.path + "_spawn_egg", () -> new ForgeSpawnEggItem(RIDING_LIZARD_ENTITY, EntityInfo.RIDING_LIZARD.spawnEggColor, EntityInfo.RIDING_LIZARD.spawnEggSpotColor, eggItemSettings));
    public static RegistryObject<EntityType<MountEntity>> DIREWOLF_ENTITY = EntityInfo.buildEntity(EntityKey.DIREWOLF);
    public static final RegistryObject<Item> DIREWOLF_EGG_ITEM = ITEMS.register(EntityInfo.DIREWOLF.path + "_spawn_egg", () -> new ForgeSpawnEggItem(DIREWOLF_ENTITY, EntityInfo.DIREWOLF.spawnEggColor, EntityInfo.DIREWOLF.spawnEggSpotColor, eggItemSettings));
    public static RegistryObject<EntityType<MountEntity>> COLELYTRA_ENTITY = EntityInfo.buildEntity(EntityKey.COLELYTRA);
    public static final RegistryObject<Item> COLELYTRA_EGG_ITEM = ITEMS.register(EntityInfo.COLELYTRA.path + "_spawn_egg", () -> new ForgeSpawnEggItem(COLELYTRA_ENTITY, EntityInfo.COLELYTRA.spawnEggColor, EntityInfo.COLELYTRA.spawnEggSpotColor, eggItemSettings));
    public static RegistryObject<EntityType<MountEntity>> FIREBIRD_ENTITY = EntityInfo.buildEntity(EntityKey.FIREBIRD);
    public static final RegistryObject<Item> FIREBIRD_EGG_ITEM = ITEMS.register(EntityInfo.FIREBIRD.path + "_spawn_egg", () -> new ForgeSpawnEggItem(FIREBIRD_ENTITY, EntityInfo.FIREBIRD.spawnEggColor, EntityInfo.FIREBIRD.spawnEggSpotColor, eggItemSettings));

    public static void initEntityTypes() {
        EntityInfo.ACENCIA.setType(ACENCIA_ENTITY);
        EntityInfo.ARCHELON.setType(ARCHELON_ENTITY);
        EntityInfo.NETHER_BAT.setType(NETHER_BAT_ENTITY);
        EntityInfo.COURIER_BIRD.setType(COURIER_BIRD_ENTITY);
        EntityInfo.DRAGON.setType(DRAGON_ENTITY);
        EntityInfo.GRIFFON.setType(GRIFFON_ENTITY);
        EntityInfo.GECKOTOA.setType(GECKOTOA_ENTITY);
        EntityInfo.MOTH.setType(MOTH_ENTITY);
        EntityInfo.NIGHTMARE.setType(NIGHTMARE_ENTITY);
        EntityInfo.NUDIBRANCH.setType(NUDIBRANCH_ENTITY);
        EntityInfo.RIDING_LIZARD.setType(RIDING_LIZARD_ENTITY);
        EntityInfo.DIREWOLF.setType(DIREWOLF_ENTITY);
        EntityInfo.COLELYTRA.setType(COLELYTRA_ENTITY);
        EntityInfo.FIREBIRD.setType(FIREBIRD_ENTITY);
    }

    public static void initSpawns() {
        Entities.initEntityTypes();
        for (EntityInfo e : EntityInfo.values()) {
            e.initSpawn();
        }
    }

    public static enum EntityInfo {
        ACENCIA(EntityKey.ACENCIA, AcenciaEntity.class, AcenciaEntity::new, "geo/acenciamount.geo.json", "animations/acenciamount.animation.json", "textures/model/entity/acencia_mount1.png", 0.9f, 1.15f, EntityDimensions.m_20395_((float)1.75f, (float)2.1875f), "acencia", 0xFFFFFF, 6397630, false, false, false),
        ARCHELON(EntityKey.ARCHELON, ArchelonEntity.class, ArchelonEntity::new, "geo/seaturtlemount.geo.json", "animations/seaturtlemount.animation.json", "textures/model/entity/archelon_mount.png", 0.9f, 1.15f, EntityDimensions.m_20395_((float)3.9375f, (float)3.4375f), "archelon", 4112021, 284988, false, true, false),
        FIREBIRD(EntityKey.FIREBIRD, FirebirdEntity.class, FirebirdEntity::new, "geo/firebirdmount.geo.json", "animations/firebirdmount.animation.json", "textures/model/entity/firebird_mount.png", 0.9f, 1.0f, EntityDimensions.m_20395_((float)1.5f, (float)1.375f), "firebird", 16181131, 7912042, true, false, true),
        COLELYTRA(EntityKey.COLELYTRA, ColelytraEntity.class, ColelytraEntity::new, "geo/colelytramount.geo.json", "animations/colelytramount.animation.json", "textures/model/entity/colelytra_mount1.png", 0.9f, 1.0f, EntityDimensions.m_20395_((float)2.0f, (float)1.8125f), "colelytra", 16391977, 2300956, false, false, false),
        COURIER_BIRD(EntityKey.COURIER_BIRD, CourierBirdEntity.class, CourierBirdEntity::new, "geo/courierbirdmount.geo.json", "animations/courierbirdmount.animation.json", "textures/model/entity/courierbird_mount.png", 0.9f, 0.75f, EntityDimensions.m_20395_((float)1.0f, (float)1.5f), "courierbird", 0xFFFFFF, 14805247, false, false, false),
        DIREWOLF(EntityKey.DIREWOLF, DireWolfEntity.class, DireWolfEntity::new, "geo/wolfmount.geo.json", "animations/wolfmount.animation.json", "textures/model/entity/direwolf_mount.png", 0.9f, 1.25f, EntityDimensions.m_20395_((float)1.25f, (float)2.6875f), "direwolf", 3685188, 3680042, false, false, false),
        DRAGON(EntityKey.DRAGON, DragonEntity.class, DragonEntity::new, "geo/dragonmount.geo.json", "animations/dragonmount.animation.json", "textures/model/entity/dragon_mount.png", 0.9f, 1.75f, EntityDimensions.m_20395_((float)3.625f, (float)3.6875f), "dragon", 986128, 7493570, true, false, false),
        GRIFFON(EntityKey.GRIFFON, GriffonEntity.class, GriffonEntity::new, "geo/griffonmount.geo.json", "animations/griffonmount.animation.json", "textures/model/entity/griffon_mount.png", 0.9f, 1.15f, EntityDimensions.m_20395_((float)1.4375f, (float)2.3125f), "griffon", 0xFFFFFF, 16408604, false, false, false),
        GECKOTOA(EntityKey.GECKOTOA, GroundLizardEntity.class, GroundLizardEntity::new, "geo/groundlizardmount.geo.json", "animations/groundlizardmount.animation.json", "textures/model/entity/groundlizard_mount.png", 0.9f, 1.1f, EntityDimensions.m_20395_((float)2.375f, (float)1.75f), "geckotoalizard", 10006399, 4290899, false, false, false),
        MOTH(EntityKey.MOTH, MothEntity.class, MothEntity::new, "geo/mothmount.geo.json", "animations/mothmount.animation.json", "textures/model/entity/moth_mount2.png", 0.9f, 1.15f, EntityDimensions.m_20395_((float)2.0f, (float)1.125f), "moth", 0x999566, 16408604, false, false, false),
        NETHER_BAT(EntityKey.NETHER_BAT, NetherBatEntity.class, NetherBatEntity::new, "geo/batmount.geo.json", "animations/batmount.animation.json", "textures/model/entity/bat_mount.png", 0.9f, 1.55f, EntityDimensions.m_20395_((float)2.0f, (float)1.75f), "netherbat", 2583784, 16143187, true, false, false),
        NIGHTMARE(EntityKey.NIGHTMARE, NightmareEntity.class, NightmareEntity::new, "geo/nightmaremount.geo.json", "animations/nightmaremount.animation.json", "textures/model/entity/nightmare_mount_frame1.png", 0.9f, 1.0f, EntityDimensions.m_20395_((float)1.75f, (float)2.25f), "nightmare", 986128, 16724256, true, false, true),
        NUDIBRANCH(EntityKey.NUDIBRANCH, NudibranchEntity.class, NudibranchEntity::new, "geo/nudibranchmount.geo.json", "animations/nudibranchmount.animation.json", "textures/model/entity/nudibranch_mount.png", 0.9f, 1.15f, EntityDimensions.m_20395_((float)1.5625f, (float)1.6875f), "nudibranch", 4858544, 14964224, false, false, false),
        RIDING_LIZARD(EntityKey.RIDING_LIZARD, RidingLizardEntity.class, RidingLizardEntity::new, "geo/ridinglizardmount.geo.json", "animations/ridinglizardmount.animation.json", "textures/model/entity/ridinglizard_mount1.png", 0.9f, 0.8f, EntityDimensions.m_20395_((float)1.0f, (float)1.75f), "ridinglizard", 10860410, 7098137, false, false, false);

        public String path;
        public RegistryObject<EntityType<MountEntity>> type = this.type;
        public Class entityClass;
        public Item item;
        public Item item_albino;
        public EntityType.EntityFactory entityFactory;
        public EntityDimensions dimensions;
        public EntityKey key;
        public int spawnEggColor = -1;
        public int spawnEggSpotColor = -1;
        public String geo;
        public String ani;
        public String tex;
        public float shadowRadius = 0.25f;
        public float scaleAdjustment = 1.0f;
        public boolean hasExtraArmor = false;
        public boolean fireImmune = false;
        public boolean shouldGlow = false;

        private EntityInfo(EntityKey key, Class entityClass, EntityType.EntityFactory entityFactory, String geo, String ani, String tex, float shadowRadius, float scaleAdjustment, EntityDimensions dimensions, String path, int spawnEggColor, int spawnEggSpotColor, boolean fireImmune, boolean hasExtraArmor, boolean shouldGlow) {
            this.key = key;
            this.path = path;
            this.entityClass = entityClass;
            this.entityFactory = entityFactory;
            this.dimensions = dimensions;
            this.spawnEggColor = spawnEggColor;
            this.spawnEggSpotColor = spawnEggSpotColor;
            this.geo = geo;
            this.ani = ani;
            this.tex = tex;
            this.shadowRadius = shadowRadius;
            this.scaleAdjustment = scaleAdjustment;
            this.hasExtraArmor = hasExtraArmor;
            this.fireImmune = fireImmune;
            this.shouldGlow = shouldGlow;
        }

        public EntityInfo setType(RegistryObject<EntityType<MountEntity>> type) {
            this.type = type;
            return this;
        }

        public void initSpawn() {
            SpawnSettings.initSpawnSettings(this.key, (EntityType<MountEntity>)((EntityType)this.type.get()), Settings.globalSettings.printBiomes);
        }

        public static EntityInfo getByKey(EntityKey key) {
            switch (key) {
                case ACENCIA: {
                    return ACENCIA;
                }
                case ARCHELON: {
                    return ARCHELON;
                }
                case NETHER_BAT: {
                    return NETHER_BAT;
                }
                case COURIER_BIRD: {
                    return COURIER_BIRD;
                }
                case DRAGON: {
                    return DRAGON;
                }
                case GRIFFON: {
                    return GRIFFON;
                }
                case GECKOTOA: {
                    return GECKOTOA;
                }
                case MOTH: {
                    return MOTH;
                }
                case NIGHTMARE: {
                    return NIGHTMARE;
                }
                case NUDIBRANCH: {
                    return NUDIBRANCH;
                }
                case RIDING_LIZARD: {
                    return RIDING_LIZARD;
                }
                case DIREWOLF: {
                    return DIREWOLF;
                }
                case COLELYTRA: {
                    return COLELYTRA;
                }
                case FIREBIRD: {
                    return FIREBIRD;
                }
            }
            return null;
        }

        public static <T extends MountEntity> RegistryObject<EntityType<T>> buildEntity(EntityKey key) {
            EntityInfo entityConfig = EntityInfo.getByKey(key);
            MobCategory spawnGroup = MobCategory.CREATURE;
            if (Settings.settings.get((Object)((Object)key)).spawnType.equals("subterranean") || Settings.settings.get((Object)((Object)key)).spawnType.equals("nether")) {
                spawnGroup = MobCategory.AMBIENT;
            }
            if (entityConfig.fireImmune) {
                MobCategory finalSpawnGroup = spawnGroup;
                return ENTITY_REGISTER.register(entityConfig.path, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)entityConfig.entityFactory, (MobCategory)finalSpawnGroup).m_20699_(entityConfig.dimensions.f_20377_, entityConfig.dimensions.f_20378_).m_20719_().m_20712_(entityConfig.path));
            }
            MobCategory finalSpawnGroup1 = spawnGroup;
            return ENTITY_REGISTER.register(entityConfig.path, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)entityConfig.entityFactory, (MobCategory)finalSpawnGroup1).m_20699_(entityConfig.dimensions.f_20377_, entityConfig.dimensions.f_20378_).m_20712_(entityConfig.path));
        }
    }

    public static enum EntityKey {
        ACENCIA,
        ARCHELON,
        NETHER_BAT,
        COURIER_BIRD,
        DRAGON,
        GRIFFON,
        GECKOTOA,
        MOTH,
        NIGHTMARE,
        NUDIBRANCH,
        RIDING_LIZARD,
        DIREWOLF,
        COLELYTRA,
        FIREBIRD;

    }
}

