/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.entity.mounts;

import com.yahoo.chirpycricket.mythicmounts.entity.FlyingMountEntity;
import com.yahoo.chirpycricket.mythicmounts.registery.Entities;
import com.yahoo.chirpycricket.mythicmounts.registery.Sounds;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animation.RawAnimation;

public class DragonEntity
extends FlyingMountEntity {
    final String[] idleAnimations = new String[]{"animation.mount.idle", "animation.mount.idle2", "animation.mount.idle3", "animation.mount.idle4", "animation.mount.idle5"};
    final String[] sleepIdleAnimations = new String[]{"animation.mount.sleepidle1", "animation.mount.sleepidle2", "animation.mount.sleepidle3", "animation.mount.sleepidle4"};
    int knockbackCounter = 0;

    public DragonEntity(EntityType<? extends FlyingMountEntity> type, Level worldIn) {
        super(type, worldIn, Entities.EntityKey.DRAGON);
        this.armorTextureBaseStr = "textures/model/entity/armor/dragon_armor";
        this.textures.add("dragon_mount.png");
        this.textures.add("dragon_mount2.png");
        this.textures.add("dragon_mount3.png");
        this.textures.add("dragon_mount4.png");
        this.textures.add("dragon_mount5.png");
        this.textures.add("dragon_mount6.png");
        this.textures.add("dragon_mount7.png");
        this.childScale = 0.3f;
        this.leashYOffset = 0.75f;
        this.leashZOffset = 0.9f;
        this.miniYOffset = 0.575f;
    }

    @Override
    public String getDefaultTexture() {
        return "dragon_mount.png";
    }

    public Vec3 getLeashAttachPoint() {
        Vec3 attachPoint = new Vec3(0.0, (double)this.m_20192_(), (double)(this.m_20205_() * this.leashZOffset));
        if (this.m_6162_()) {
            attachPoint = new Vec3(0.0, (double)this.m_20192_() * (double)this.childScale, (double)(this.m_20205_() * this.leashZOffset * this.childScale));
        }
        return attachPoint;
    }

    public float m_20236_(Pose pose) {
        return this.m_6972_((Pose)pose).f_20378_ * 3.0f;
    }

    @Override
    protected SoundEvent m_7515_() {
        if (this.m_5912_()) {
            return (SoundEvent)Sounds.DRAGON_ANGRY_EVENT.get();
        }
        return (SoundEvent)Sounds.DRAGON_AMBIENT_EVENT.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)Sounds.DRAGON_HURT_EVENT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)Sounds.DRAGON_DEATH_EVENT.get();
    }

    @Override
    protected SoundEvent m_7871_() {
        return (SoundEvent)Sounds.DRAGON_ANGRY_EVENT.get();
    }

    @Override
    public RawAnimation getIdleAnimation() {
        return this.getRandomAnimation(this.idleAnimations);
    }

    @Override
    public RawAnimation getSleepingIdleAnimation() {
        return this.getRandomAnimation(this.sleepIdleAnimations);
    }

    @Override
    public float getWanderFlyingSpeed() {
        return 30.0f;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.settings.specialAbilitiesEnabled) {
            ++this.knockbackCounter;
            this.knockbackCounter %= 1;
            if (this.knockbackCounter == 0 && this.getIsFlying()) {
                AABB b = new AABB(this.m_20097_());
                b = b.m_82377_(10.0, 20.0, 10.0);
                List entities = this.m_9236_().m_45976_(LivingEntity.class, b);
                for (LivingEntity e : entities) {
                    if (e.equals((Object)this)) continue;
                    e.m_147240_(0.25, this.m_20185_() - e.m_20185_(), this.m_20189_() - e.m_20189_());
                }
            }
        }
    }
}

