/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.entity.mounts;

import com.yahoo.chirpycricket.mythicmounts.entity.FlyingMountEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import com.yahoo.chirpycricket.mythicmounts.registery.Entities;
import com.yahoo.chirpycricket.mythicmounts.registery.Sounds;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.core.animation.RawAnimation;

public class ColelytraEntity
extends FlyingMountEntity {
    final String[] color = new String[]{"black", "cream", "red"};
    final String[] patterns = new String[]{"22spot", "22spot", "22spot", "5spot", "5spot", "splotch", "splotch", "stripe", "netty", "none"};
    private DyeColor eatenDye;
    final String[] idleAnimations = new String[]{"animation.mount.idle", "animation.mount.idle2", "animation.mount.idle3", "animation.mount.idle4", "animation.mount.idle5", "animation.mount.idle6", "animation.mount.idle7"};

    public ColelytraEntity(EntityType<? extends FlyingMountEntity> type, Level worldIn) {
        super(type, worldIn, Entities.EntityKey.COLELYTRA);
        this.armorTextureBaseStr = "textures/model/entity/armor/colelytra_armor";
        this.textures.add("colelytra_mount_red.png");
        this.textures.add("colelytra_mount_red.png");
        this.textures.add("colelytra_mount_red.png");
        this.textures.add("colelytra_mount_red.png");
        this.textures.add("colelytra_mount_black.png");
        this.textures.add("colelytra_mount_black.png");
        this.textures.add("colelytra_mount_yellow.png");
        this.leashYOffset = 0.65f;
        this.leashZOffset = 0.4f;
        this.childHeadScale = 1.175f;
        this.miniYOffset = 0.55f;
    }

    @Override
    public void m_8119_() {
        if (!this.m_9236_().f_46443_ && !this.m_27593_()) {
            this.eatenDye = null;
        }
        super.m_8119_();
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack;
        Item item;
        DyeColor color;
        if (!this.m_9236_().m_5776_() && hand.ordinal() == 0 && (color = this.isDyeIngredient(item = (itemStack = player.m_21120_(hand)).m_41720_())) != null && this.isDyeSupported(color)) {
            this.eatenDye = color;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    protected String getRandomTexture(MountEntity m1, MountEntity m2) {
        DyeColor blend;
        Object dyeTex1 = m1.getTextureVariant();
        Object dyeTex2 = m2.getTextureVariant();
        Object dyeTex3 = m1.getTextureVariant();
        Object dyeTex4 = m2.getTextureVariant();
        ColelytraEntity c1 = null;
        ColelytraEntity c2 = null;
        if (m1 instanceof ColelytraEntity) {
            c1 = (ColelytraEntity)m1;
        }
        if (m2 instanceof ColelytraEntity) {
            c2 = (ColelytraEntity)m2;
        }
        if (c1 != null && c1.eatenDye != null) {
            dyeTex1 = "colelytra_mount_" + c1.eatenDye.m_41065_() + ".png";
        }
        if (c2 != null && c2.eatenDye != null) {
            dyeTex2 = "colelytra_mount_" + c2.eatenDye.m_41065_() + ".png";
        }
        if ((blend = this.blend(c1.eatenDye, c2.eatenDye)) != null) {
            dyeTex4 = dyeTex3 = "colelytra_mount_" + blend.m_41065_() + ".png";
        }
        String[] options = new String[]{dyeTex1, dyeTex1, dyeTex2, dyeTex2, dyeTex3, dyeTex3, dyeTex4, dyeTex4, m1.getTextureVariant(), m2.getTextureVariant(), this.getRandomTexture()};
        String res = options[this.f_19796_.m_188503_(options.length)];
        return res;
    }

    @Override
    public boolean isBreedingItem(ItemStack item) {
        return this.isDyeIngredient(item.m_41720_()) != null || super.isBreedingItem(item);
    }

    @Override
    public String[] getOverlays() {
        int specialNum = this.getSpecialNum();
        String[] overlays = new String[]{this.getBaseTex(specialNum), this.getMidTex(specialNum), this.getTopTex(specialNum)};
        return overlays;
    }

    public String getBaseTex(int specialNum) {
        return this.getPattern(this.getBasePattern(specialNum), this.getBaseColor(specialNum));
    }

    public String getMidTex(int specialNum) {
        return this.getPattern(this.getMidPattern(specialNum), this.getMidColor(specialNum));
    }

    public String getTopTex(int specialNum) {
        return this.getPattern(this.getTopPattern(specialNum), this.getTopColor(specialNum));
    }

    public String getPattern(int patternIndex, int colorIndex) {
        if (patternIndex == 9) {
            return "";
        }
        return "textures/model/entity/overlays/colelytra_mount_" + this.patterns[patternIndex] + "_" + this.color[colorIndex] + ".png";
    }

    public int getBaseColor(int specialNum) {
        return specialNum % 10;
    }

    public int getMidColor(int specialNum) {
        return specialNum / 100 % 10;
    }

    public int getTopColor(int specialNum) {
        return specialNum / 10000 % 10;
    }

    public int getBasePattern(int specialNum) {
        return specialNum / 10 % 10;
    }

    public int getMidPattern(int specialNum) {
        return specialNum / 1000 % 10;
    }

    public int getTopPattern(int specialNum) {
        return specialNum / 100000 % 10;
    }

    @Override
    protected int getRandomSpecialNum() {
        String baseColorStr = this.getTextureVariant().substring("colelytra_mount_".length(), this.getTextureVariant().length() - ".png".length());
        int baseColorIndx = Arrays.asList(this.color).indexOf(baseColorStr);
        if (baseColorIndx < 0) {
            baseColorIndx = 0;
        }
        int[] bicolor = new int[]{(int)(Math.random() * (double)this.color.length), baseColorIndx};
        int baseColor = bicolor[this.f_19796_.m_188503_(2)];
        int midColor = bicolor[this.f_19796_.m_188503_(2)];
        int topColor = bicolor[this.f_19796_.m_188503_(2)];
        int basePattern = this.f_19796_.m_188503_(this.patterns.length);
        int midPattern = this.f_19796_.m_188503_(this.patterns.length);
        int topPattern = this.f_19796_.m_188503_(this.patterns.length);
        if (topPattern == 9) {
            topPattern = this.f_19796_.m_188503_(this.patterns.length - 1);
        }
        if (topColor == baseColorIndx && (topPattern == midPattern || topPattern == basePattern)) {
            topColor = bicolor[0] == topColor ? bicolor[1] : bicolor[0];
        }
        if (baseColorIndx == baseColor && baseColorIndx == midColor && baseColorIndx == topColor) {
            topColor = (baseColorIndx + this.f_19796_.m_188503_(this.color.length - 2) + 1) % this.color.length;
        }
        return baseColor + 10 * basePattern + 100 * midColor + 1000 * midPattern + 10000 * topColor + 100000 * topPattern;
    }

    @Override
    protected int getRandomSpecialNum(int specialNum1, int specialNum2) {
        int topPattern;
        int topColor;
        int baseColor = this.f_19796_.m_188499_() ? this.getBaseColor(specialNum1) : this.getBaseColor(specialNum2);
        int midColor = this.f_19796_.m_188499_() ? this.getMidColor(specialNum1) : this.getMidColor(specialNum2);
        int n = topColor = this.f_19796_.m_188499_() ? this.getTopColor(specialNum1) : this.getTopColor(specialNum2);
        if (this.f_19796_.m_188500_() < 0.25) {
            String baseColorStr = this.getTextureVariant().substring("colelytra_mount_".length(), this.getTextureVariant().length() - ".png".length());
            int baseColorIndx = Arrays.asList(this.color).indexOf(baseColorStr);
            if (baseColorIndx < 0) {
                baseColorIndx = 0;
            }
            int[] bicolor = new int[]{(int)(Math.random() * (double)this.color.length), baseColorIndx};
            baseColor = bicolor[this.f_19796_.m_188503_(2)];
            midColor = bicolor[this.f_19796_.m_188503_(2)];
            topColor = bicolor[this.f_19796_.m_188503_(2)];
        }
        int basePattern = this.f_19796_.m_188499_() ? this.getBasePattern(specialNum1) : this.getBasePattern(specialNum2);
        int midPattern = this.f_19796_.m_188499_() ? this.getMidPattern(specialNum1) : this.getMidPattern(specialNum2);
        int n2 = topPattern = this.f_19796_.m_188499_() ? this.getTopPattern(specialNum1) : this.getTopPattern(specialNum2);
        if (this.f_19796_.m_188500_() < 0.25) {
            basePattern = this.f_19796_.m_188503_(this.patterns.length);
        }
        if (this.f_19796_.m_188500_() < 0.25) {
            midPattern = this.f_19796_.m_188503_(this.patterns.length);
        }
        if (this.f_19796_.m_188500_() < 0.25) {
            topPattern = this.f_19796_.m_188503_(this.patterns.length);
        }
        return baseColor + 10 * basePattern + 100 * midColor + 1000 * midPattern + 10000 * topColor + 100000 * topPattern;
    }

    @Override
    public String getDefaultTexture() {
        return "colelytra_mount1.png";
    }

    @Override
    protected SoundEvent m_7515_() {
        if (this.m_5912_()) {
            return (SoundEvent)Sounds.COLELYTRA_ANGRY_EVENT.get();
        }
        return (SoundEvent)Sounds.COLELYTRA_AMBIENT_EVENT.get();
    }

    @Override
    protected void playFlapSound() {
        this.m_5496_((SoundEvent)Sounds.WING_WHIR.get(), this.m_6121_() * 1.5f * 0.333f, 1.0f);
    }

    @Override
    protected float m_6121_() {
        return 1.25f * super.m_6121_();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)Sounds.COLELYTRA_HURT_EVENT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)Sounds.COLELYTRA_DEATH_EVENT.get();
    }

    @Override
    protected SoundEvent m_7871_() {
        return (SoundEvent)Sounds.COLELYTRA_ANGRY_EVENT.get();
    }

    @Override
    public RawAnimation getIdleAnimation() {
        return this.getRandomAnimation(this.idleAnimations);
    }

    @Override
    public RawAnimation getSleepingIdleAnimation() {
        return this.getRandomAnimation(this.idleAnimations);
    }

    @Override
    public void updateFlyingSound() {
        ++this.flapTimer;
        this.flapTimer %= 2;
        if (this.flapTimer == 0) {
            this.playFlapSound();
        }
    }

    public DyeColor isDyeIngredient(Item item) {
        Collection recipes = ((ServerLevel)this.m_9236_()).m_7465_().m_44051_();
        for (Recipe recipe : recipes) {
            if (!(recipe.m_8043_(this.m_9236_().m_9598_()).m_41720_() instanceof DyeItem)) continue;
            for (Ingredient ingredient : recipe.m_7527_()) {
                for (ItemStack is : ingredient.m_43908_()) {
                    if (!is.m_41720_().equals(item)) continue;
                    return ((DyeItem)recipe.m_8043_(this.m_9236_().m_9598_()).m_41720_()).m_41089_();
                }
            }
        }
        return null;
    }

    public boolean isDyeSupported(DyeColor color) {
        DyeColor[] supportedColors = new DyeColor[]{DyeColor.WHITE, DyeColor.ORANGE, DyeColor.MAGENTA, DyeColor.LIGHT_BLUE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.PINK, DyeColor.GRAY, DyeColor.LIGHT_GRAY, DyeColor.CYAN, DyeColor.PURPLE, DyeColor.BLUE, DyeColor.BROWN, DyeColor.GREEN, DyeColor.RED, DyeColor.BLACK};
        return Arrays.asList(supportedColors).contains(color);
    }

    public DyeColor blend(DyeColor c1, DyeColor c2) {
        if (this.check(DyeColor.BLUE, DyeColor.WHITE, c1, c2)) {
            return DyeColor.LIGHT_BLUE;
        }
        if (this.check(DyeColor.GRAY, DyeColor.WHITE, c1, c2)) {
            return DyeColor.LIGHT_GRAY;
        }
        if (this.check(DyeColor.GREEN, DyeColor.WHITE, c1, c2)) {
            return DyeColor.LIME;
        }
        if (this.check(DyeColor.PURPLE, DyeColor.PINK, c1, c2)) {
            return DyeColor.MAGENTA;
        }
        if (this.check(DyeColor.RED, DyeColor.YELLOW, c1, c2)) {
            return DyeColor.ORANGE;
        }
        if (this.check(DyeColor.RED, DyeColor.WHITE, c1, c2)) {
            return DyeColor.PINK;
        }
        if (this.check(DyeColor.BLUE, DyeColor.GREEN, c1, c2)) {
            return DyeColor.CYAN;
        }
        if (this.check(DyeColor.CYAN, DyeColor.YELLOW, c1, c2)) {
            return DyeColor.LIME;
        }
        if (this.check(DyeColor.BLUE, DyeColor.YELLOW, c1, c2)) {
            return DyeColor.GREEN;
        }
        if (this.check(DyeColor.BLACK, DyeColor.WHITE, c1, c2)) {
            return DyeColor.GRAY;
        }
        if (this.check(DyeColor.RED, DyeColor.BLUE, c1, c2)) {
            return DyeColor.PURPLE;
        }
        return null;
    }

    private boolean check(DyeColor mix1, DyeColor mix2, DyeColor check1, DyeColor check2) {
        return mix1.equals((Object)check1) && mix2.equals((Object)check2) || mix1.equals((Object)check2) && mix2.equals((Object)check1);
    }

    public static float getKnockbackResistance() {
        return 0.8f;
    }
}

