/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.entity.ai;

import com.yahoo.chirpycricket.mythicmounts.entity.FlyingMountEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.SwimmingMountEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.ai.SwimmingMountNavigation;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MountGoals {

    public static class MountSwimGoal
    extends Goal {
        private final MountEntity mob;

        public MountSwimGoal(MountEntity mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP));
            mob.m_21573_().m_7008_(true);
        }

        public boolean m_8036_() {
            return this.mob.m_20069_() && this.mob.m_204036_(FluidTags.f_13131_) > this.mob.m_20204_() || this.mob.m_20077_() && this.mob.m_204036_(FluidTags.f_13132_) > 0.0 && this.mob.shouldSwimInLava;
        }

        public void m_8037_() {
            if (this.mob.m_217043_().m_188501_() < 0.8f) {
                this.mob.m_21569_().m_24901_();
            }
        }
    }

    public static class MountFollowOwnerGoal
    extends Goal {
        public static final int field_30205 = 12;
        private static final int HORIZONTAL_RANGE = 2;
        private static final int HORIZONTAL_VARIATION = 3;
        private static final int VERTICAL_VARIATION = 1;
        private final MountEntity tameable;
        private LivingEntity owner;
        private final LevelReader level;
        private final double speed;
        private final PathNavigation navigation;
        private int updateCountdownTicks;
        private final float maxDistance;
        private final float minDistance;
        private float oldWaterPathfindingPenalty;
        private final boolean leavesAllowed;

        public MountFollowOwnerGoal(MountEntity tameable, double speed, float minDistance, float maxDistance, boolean leavesAllowed) {
            this.tameable = tameable;
            this.level = tameable.m_9236_();
            this.speed = speed;
            this.navigation = tameable.m_21573_();
            this.minDistance = minDistance;
            this.maxDistance = maxDistance;
            this.leavesAllowed = leavesAllowed;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            if (!(tameable.m_21573_() instanceof GroundPathNavigation || tameable.m_21573_() instanceof FlyingPathNavigation || tameable.m_21573_() instanceof SwimmingMountNavigation)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
            }
        }

        public boolean m_8036_() {
            Player livingEntity = this.tameable.getOwner();
            if (livingEntity == null) {
                return false;
            }
            if (livingEntity.m_5833_()) {
                return false;
            }
            if (this.tameable.getIsSitting()) {
                return false;
            }
            if (!this.tameable.getShouldFollow()) {
                return false;
            }
            if (this.tameable.m_20280_((Entity)livingEntity) < (double)(this.minDistance * this.minDistance)) {
                return false;
            }
            this.owner = livingEntity;
            return true;
        }

        public boolean m_8045_() {
            if (this.navigation.m_26571_()) {
                return false;
            }
            if (this.tameable.getIsSitting()) {
                return false;
            }
            return !(this.tameable.m_20280_((Entity)this.owner) <= (double)(this.maxDistance * this.maxDistance));
        }

        public void m_8056_() {
            this.updateCountdownTicks = 0;
            this.oldWaterPathfindingPenalty = this.tameable.m_21439_(BlockPathTypes.WATER);
            this.tameable.m_21441_(BlockPathTypes.WATER, 0.0f);
        }

        public void m_8041_() {
            this.owner = null;
            this.navigation.m_26573_();
            this.tameable.m_21441_(BlockPathTypes.WATER, this.oldWaterPathfindingPenalty);
        }

        public void m_8037_() {
            this.tameable.m_21563_().m_24960_((Entity)this.owner, 10.0f, 40.0f);
            if (--this.updateCountdownTicks <= 0) {
                this.updateCountdownTicks = 10;
                if (!this.tameable.m_21523_() && !this.tameable.m_20159_()) {
                    if (this.tameable.m_20280_((Entity)this.owner) >= 144.0) {
                        this.tryTeleport();
                    } else {
                        this.navigation.m_5624_((Entity)this.owner, this.speed * 2.0);
                    }
                }
            }
        }

        private void tryTeleport() {
            BlockPos blockPos = this.owner.m_20097_();
            for (int i = 0; i < 10; ++i) {
                int j = this.getRandomInt(-3, 3);
                int k = this.getRandomInt(-1, 1);
                int l = this.getRandomInt(-3, 3);
                boolean bl = this.tryTeleportTo(blockPos.m_123341_() + j, blockPos.m_123342_() + k, blockPos.m_123343_() + l);
                if (!bl) continue;
                return;
            }
        }

        private boolean tryTeleportTo(int x, int y, int z) {
            if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
                return false;
            }
            if (!this.canTeleportTo(new BlockPos(x, y, z))) {
                return false;
            }
            this.tameable.m_7678_((double)x + 0.5, y, (double)z + 0.5, this.tameable.m_146908_(), this.tameable.m_146909_());
            this.navigation.m_26573_();
            return true;
        }

        private boolean canTeleportTo(BlockPos pos) {
            BlockPathTypes pathNodeType = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pos.m_122032_());
            if (!(pathNodeType == BlockPathTypes.WALKABLE || this.tameable.m_6040_() && pathNodeType == BlockPathTypes.WATER || this.tameable.m_203441_(Fluids.f_76195_.m_76145_()) && pathNodeType == BlockPathTypes.LAVA)) {
                return false;
            }
            BlockState blockState = this.level.m_8055_(pos.m_7495_());
            if (!this.leavesAllowed && blockState.m_60734_() instanceof LeavesBlock) {
                return false;
            }
            BlockPos blockPos = pos.m_121996_((Vec3i)this.tameable.m_20097_());
            return this.level.m_45756_((Entity)this.tameable, this.tameable.m_20191_().m_82338_(blockPos));
        }

        private int getRandomInt(int min, int max) {
            return this.tameable.m_217043_().m_188503_(max - min + 1) + min;
        }
    }

    public static class MountRandomLookAroundGoal
    extends RandomLookAroundGoal {
        MountEntity f_25715_;

        public MountRandomLookAroundGoal(MountEntity mob) {
            super((Mob)mob);
            this.f_25715_ = mob;
        }

        public boolean m_8036_() {
            if (this.f_25715_.m_21563_().m_186069_()) {
                return false;
            }
            return !this.f_25715_.getIsSleeping() && !this.f_25715_.getIsFlying() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.f_25715_.getIsSleeping() && !this.f_25715_.getIsFlying() && super.m_8045_();
        }

        public void m_8056_() {
            if (!this.f_25715_.getIsSleeping() && !this.f_25715_.getIsFlying()) {
                super.m_8056_();
            }
        }

        public void m_8037_() {
            if (!this.f_25715_.getIsSleeping() && !this.f_25715_.getIsFlying()) {
                super.m_8037_();
            }
        }
    }

    public static class LookAtBlockGoal
    extends Goal {
        protected MountEntity mob;
        protected BlockPos target;
        protected final float range;
        private int lookTime;
        protected final float chance;
        private final boolean field_33761;
        private final Predicate<BlockState> blockPredicate = state -> {
            for (Block block : this.mob.seekingBlocks) {
                if (!state.m_60713_(block)) continue;
                return true;
            }
            return false;
        };

        public LookAtBlockGoal(MountEntity mob, float range) {
            this(mob, range, 0.02f);
        }

        public LookAtBlockGoal(MountEntity mob, float range, float chance) {
            this(mob, range, chance, false);
        }

        public LookAtBlockGoal(MountEntity mobEntity, float f, float g, boolean bl) {
            this.mob = mobEntity;
            this.range = f;
            this.chance = g;
            this.field_33761 = bl;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.mob.m_21563_().m_186069_()) {
                return false;
            }
            if (this.mob.m_217043_().m_188501_() >= this.chance) {
                return false;
            }
            this.target = this.findBlock(this.blockPredicate, this.range).orElse(null);
            return this.target != null;
        }

        public boolean m_8045_() {
            Vec3 vec3 = new Vec3((double)this.target.m_123341_(), (double)this.target.m_123342_(), (double)this.target.m_123343_());
            if (this.mob.m_20238_(vec3) > (double)(this.range * this.range)) {
                return false;
            }
            return this.lookTime > 0;
        }

        public void m_8056_() {
            this.lookTime = 40 + this.mob.m_217043_().m_188503_(40);
        }

        public void m_8041_() {
            this.target = null;
        }

        public void m_8037_() {
            double d = (float)this.target.m_123342_() + 0.5f;
            this.mob.m_21563_().m_24946_((double)this.target.m_123341_(), d, (double)this.target.m_123343_());
            --this.lookTime;
        }

        private Optional<BlockPos> findBlock(Predicate<BlockState> predicate, double searchDistance) {
            BlockPos blockPos = this.mob.m_20097_();
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            int i = 0;
            while ((double)i <= searchDistance) {
                int j = 0;
                while ((double)j < searchDistance) {
                    int k = 0;
                    while (k <= j) {
                        int l;
                        int n = l = k < j && k > -j ? j : 0;
                        while (l <= j) {
                            mutable.m_122154_((Vec3i)blockPos, k, i - 1, l);
                            if (blockPos.m_123314_((Vec3i)mutable, searchDistance) && predicate.test(this.mob.m_9236_().m_8055_((BlockPos)mutable))) {
                                return Optional.of(mutable);
                            }
                            l = l > 0 ? -l : 1 - l;
                        }
                        k = k > 0 ? -k : 1 - k;
                    }
                    ++j;
                }
                i = i > 0 ? -i : 1 - i;
            }
            return Optional.empty();
        }
    }

    public static class MountGoToBlockGoal
    extends MoveToBlockGoal {
        private final Block[] blocks;
        MountEntity entity;

        public MountGoToBlockGoal(MountEntity turtle, double speed, Block[] blocks) {
            super((PathfinderMob)turtle, speed, 16);
            this.blocks = blocks;
            this.entity = turtle;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.entity.getIsSitting() && !this.entity.getIsFlying() && !this.entity.getIsSleeping();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.entity.getIsSitting() && !this.entity.getIsFlying() && !this.entity.getIsSleeping();
        }

        public double getDesiredSquaredDistanceToTarget() {
            return 5.0;
        }

        protected boolean m_6465_(LevelReader world, BlockPos pos) {
            BlockState blockState = world.m_8055_(pos);
            return Arrays.asList(this.blocks).contains(blockState.m_60734_());
        }
    }

    public static class SwimRandomlyGoal
    extends Goal {
        private final SwimmingMountEntity turtle;
        private final double speed;
        private boolean noPath;
        BlockPos travelTarget;

        public SwimRandomlyGoal(SwimmingMountEntity turtle, double speed) {
            this.turtle = turtle;
            this.speed = speed;
        }

        public boolean m_8036_() {
            if (!this.turtle.shouldMove() || this.turtle.getIsFlying() || this.turtle.getShouldFollow()) {
                return false;
            }
            return this.turtle.m_20069_();
        }

        public void m_8056_() {
            BlockPos blockPos;
            boolean i = true;
            boolean j = true;
            RandomSource random = this.turtle.m_217043_();
            int k = random.m_188503_(1025) - 512;
            int l = random.m_188503_(9) - 4;
            int m = random.m_188503_(1025) - 512;
            if ((double)l + this.turtle.m_20186_() > (double)(this.turtle.m_9236_().m_5736_() - 1)) {
                l = 0;
            }
            this.travelTarget = blockPos = new BlockPos(k + this.turtle.m_146903_(), l + this.turtle.m_146904_(), m + this.turtle.m_146907_());
            this.noPath = false;
        }

        public void m_8037_() {
            if (this.turtle.m_21573_().m_26571_()) {
                Vec3 vec3d = Vec3.m_82539_((Vec3i)this.travelTarget);
                Vec3 vec3d2 = DefaultRandomPos.m_148412_((PathfinderMob)this.turtle, (int)16, (int)3, (Vec3)vec3d, (double)0.3141592741012573);
                if (vec3d2 == null) {
                    vec3d2 = DefaultRandomPos.m_148412_((PathfinderMob)this.turtle, (int)8, (int)7, (Vec3)vec3d, (double)360.0);
                }
                if (vec3d2 != null) {
                    int i = Mth.m_14107_((double)vec3d2.f_82479_);
                    int j = Mth.m_14107_((double)vec3d2.f_82481_);
                    if (!this.turtle.m_9236_().m_46812_(i - 34, 0, j - 34, i + 34, 0, j + 34)) {
                        vec3d2 = null;
                    }
                }
                if (vec3d2 == null) {
                    this.noPath = true;
                    return;
                }
                this.turtle.m_21573_().m_26519_(vec3d2.f_82479_, vec3d2.f_82480_, vec3d2.f_82481_, this.speed);
            }
        }

        public boolean m_8045_() {
            if (!this.turtle.shouldMove() || this.turtle.getIsFlying() || this.turtle.getShouldFollow()) {
                return false;
            }
            return !this.turtle.m_21573_().m_26571_() && !this.noPath && !this.turtle.m_27593_();
        }

        public void m_8041_() {
            super.m_8041_();
        }
    }

    public static class WanderInWaterGoal
    extends MoveToBlockGoal {
        private final SwimmingMountEntity turtle;

        public WanderInWaterGoal(SwimmingMountEntity turtle, double speed) {
            super((PathfinderMob)turtle, turtle.m_6162_() ? 2.0 : speed, 24);
            this.turtle = turtle;
            this.f_25603_ = -1;
        }

        public boolean m_8045_() {
            if (!this.turtle.shouldMove() || this.turtle.getIsFlying() || this.turtle.getShouldFollow()) {
                return false;
            }
            return !this.turtle.m_20069_() && this.f_25601_ <= 1200 && this.m_6465_((LevelReader)this.turtle.m_9236_(), this.f_25602_);
        }

        public boolean m_8036_() {
            if (!this.turtle.shouldMove() || this.turtle.getIsFlying() || this.turtle.getShouldFollow()) {
                return false;
            }
            if (this.turtle.m_6162_() && !this.turtle.m_20069_()) {
                return super.m_8036_();
            }
            return !this.turtle.m_20069_() ? super.m_8036_() : false;
        }

        public boolean m_8064_() {
            return this.f_25601_ % 160 == 0;
        }

        protected boolean m_6465_(LevelReader world, BlockPos pos) {
            return world.m_8055_(pos).m_60713_(Blocks.f_49990_);
        }
    }

    public static class MountFleeGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final MountEntity cat;
        static Predicate<LivingEntity> var10006 = EntitySelector.f_20406_::test;

        public MountFleeGoal(MountEntity cat, Class<T> fleeFromType, float distance, double slowSpeed, double fastSpeed) {
            super((PathfinderMob)cat, fleeFromType, distance, slowSpeed, fastSpeed, var10006::test);
            this.cat = cat;
        }

        public boolean m_8036_() {
            return !this.cat.m_30614_() && !this.cat.getIsSleeping() && super.m_8036_();
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.cat.getIsSitting() && !this.cat.getIsSleeping()) {
                this.cat.setIsSitting(false);
            }
        }

        public boolean m_8045_() {
            return !this.cat.m_30614_() && super.m_8045_();
        }
    }

    public static class FlyRandomlyGoal
    extends Goal {
        private final FlyingMountEntity ghast;
        private static final int maxLoops = 10;

        public FlyRandomlyGoal(FlyingMountEntity ghast) {
            this.ghast = ghast;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double f;
            double e;
            if (!this.ghast.getIsFlying() || this.ghast.m_217005_() || this.ghast.getShouldFollow()) {
                return false;
            }
            MoveControl moveControl = this.ghast.m_21566_();
            if (!moveControl.m_24995_()) {
                return true;
            }
            double d = moveControl.m_25000_() - this.ghast.m_20185_();
            double g = d * d + (e = moveControl.m_25001_() - this.ghast.m_20186_()) * e + (f = moveControl.m_25002_() - this.ghast.m_20189_()) * f;
            return g < 1.0 || g > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            double f;
            double d;
            double e;
            RandomSource random = this.ghast.m_217043_();
            Vec3i trackedPos = this.ghast.getTrackedPos();
            float minHeight = this.ghast.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING, this.ghast.m_20097_()).m_123342_();
            float maxHeight = minHeight + 30.0f;
            for (int i = 0; i < 255; ++i) {
                if (this.ghast.m_9236_().m_8055_(this.ghast.m_20097_().m_6625_(i)).m_60795_() && !this.ghast.m_9236_().m_8055_(this.ghast.m_20097_().m_6625_(i)).m_60713_(Blocks.f_49990_) && !this.ghast.m_9236_().m_8055_(this.ghast.m_20097_().m_6625_(i)).m_60713_(Blocks.f_49991_)) continue;
                minHeight = i + 2;
                i = 1000;
            }
            maxHeight = (float)Math.max((double)(minHeight + 30.0f), this.ghast.m_20186_() + 8.0);
            int loopCount = 0;
            do {
                e = this.ghast.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            } while (++loopCount < 10 && (e >= (double)maxHeight || e <= (double)minHeight));
            if (loopCount >= 10) {
                e = this.ghast.m_20186_();
            }
            loopCount = 0;
            do {
                d = this.ghast.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            } while (++loopCount < 10 && this.ghast.m_30614_() && !trackedPos.equals((Object)Vec3i.f_123288_) && Math.abs((double)trackedPos.m_123341_() - d) > 16.0);
            if (loopCount >= 10) {
                d = this.ghast.m_20185_();
            }
            loopCount = 0;
            do {
                f = this.ghast.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            } while (++loopCount < 10 && this.ghast.m_30614_() && !trackedPos.equals((Object)Vec3i.f_123288_) && Math.abs((double)trackedPos.m_123343_() - f) > 16.0);
            if (loopCount >= 10) {
                f = this.ghast.m_20189_();
            }
            this.ghast.m_21566_().m_6849_(d, e, f, (double)this.ghast.getWanderFlyingSpeed());
        }
    }

    public static class MountTrackOwnerAttackerGoal
    extends TargetGoal {
        private final MountEntity tameable;
        private LivingEntity attacker;
        private int lastAttackedTime;

        public MountTrackOwnerAttackerGoal(MountEntity tameable) {
            super((Mob)tameable, false);
            this.tameable = tameable;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            if (this.tameable.m_30614_() && !this.tameable.getIsSitting()) {
                Player livingEntity = this.tameable.getOwner();
                if (livingEntity == null) {
                    return false;
                }
                this.attacker = livingEntity.m_21188_();
                int i = livingEntity.m_21213_();
                return i != this.lastAttackedTime && this.m_26150_(this.attacker, TargetingConditions.f_26872_) && this.tameable.canAttackWithOwner(this.attacker, (LivingEntity)livingEntity);
            }
            return false;
        }

        public void m_8056_() {
            this.f_26135_.m_6710_(this.attacker);
            Player livingEntity = this.tameable.getOwner();
            if (livingEntity != null) {
                this.lastAttackedTime = livingEntity.m_21213_();
            }
            super.m_8056_();
        }
    }

    public static class MountRevengeGoal
    extends HurtByTargetGoal {
        private final MountEntity mob;

        public MountRevengeGoal(MountEntity mob, Class<?> ... noRevengeTypes) {
            super((PathfinderMob)mob, (Class[])noRevengeTypes);
            this.mob = mob;
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = this.mob.m_21188_();
            if (this.mob.m_30614_() && this.mob.getOwner() == livingEntity || this.mob.getIsSitting()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            LivingEntity livingEntity = this.mob.m_21188_();
            if (this.mob.m_30614_() && this.mob.getOwner() == livingEntity || this.mob.getIsSitting()) {
                return false;
            }
            return super.m_8036_();
        }
    }

    public static class MountFollowTargetIfTamedGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        private final MountEntity tameableMount;

        public MountFollowTargetIfTamedGoal(MountEntity tameableMount, Class<T> targetClass, boolean checkVisibility, @Nullable Predicate<LivingEntity> targetPredicate) {
            super((Mob)tameableMount, targetClass, 10, checkVisibility, false, targetPredicate);
            this.tameableMount = tameableMount;
        }

        public boolean m_8036_() {
            LivingEntity attackerEntity = this.tameableMount.m_21188_();
            return !this.tameableMount.m_6162_() && (this.tameableMount.m_30614_() && this.tameableMount.getOwner() != attackerEntity && attackerEntity == this.f_26050_ || !this.tameableMount.m_30614_()) && !this.tameableMount.m_217005_() && super.m_8036_();
        }

        public boolean m_8045_() {
            if (this.tameableMount.m_217005_() || this.tameableMount.m_30614_()) {
                return false;
            }
            return this.f_26051_ != null ? this.f_26051_.m_26885_((LivingEntity)this.f_26135_, this.f_26050_) : super.m_8045_();
        }
    }

    public static class MountAttackWithOwnerGoal
    extends TargetGoal {
        private final MountEntity tameable;
        private LivingEntity attacking;
        private int lastAttackTime;

        public MountAttackWithOwnerGoal(MountEntity tameable) {
            super((Mob)tameable, false);
            this.tameable = tameable;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            if (this.tameable.m_30614_() && !this.tameable.getIsSitting() && !this.tameable.m_217005_()) {
                int i;
                Player attackingOwner;
                AbstractHorse attackingTamable;
                Player mountOwner = this.tameable.getOwner();
                if (mountOwner == null) {
                    return false;
                }
                this.attacking = mountOwner.m_21214_();
                if (this.attacking instanceof AbstractHorse) {
                    attackingTamable = (AbstractHorse)this.attacking;
                    Player player = attackingOwner = attackingTamable.m_21805_() == null ? null : this.tameable.m_9236_().m_46003_(attackingTamable.m_21805_());
                    if (attackingOwner != null && mountOwner.equals((Object)attackingOwner)) {
                        return false;
                    }
                }
                if (this.attacking instanceof TamableAnimal) {
                    attackingTamable = (TamableAnimal)this.attacking;
                    Player player = attackingOwner = attackingTamable.m_21805_() == null ? null : this.tameable.m_9236_().m_46003_(attackingTamable.m_21805_());
                    if (attackingOwner != null && mountOwner.equals((Object)attackingOwner)) {
                        return false;
                    }
                }
                return (i = mountOwner.m_21215_()) != this.lastAttackTime && this.m_26150_(this.attacking, TargetingConditions.f_26872_) && this.tameable.canAttackWithOwner(this.attacking, (LivingEntity)mountOwner);
            }
            return false;
        }

        public void m_8056_() {
            this.f_26135_.m_6710_(this.attacking);
            Player livingEntity = this.tameable.getOwner();
            if (livingEntity != null) {
                this.lastAttackTime = livingEntity.m_21215_();
            }
            super.m_8056_();
        }
    }

    public static class MountBreedGoal
    extends BreedGoal {
        private int timer;
        MountEntity mount;
        private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_();

        public MountBreedGoal(Animal animal, double chance, Class<? extends Animal> entityClass) {
            super(animal, chance, entityClass);
            if (animal instanceof MountEntity) {
                this.mount = (MountEntity)animal;
            }
        }

        public boolean m_8036_() {
            if (!this.mount.m_27593_()) {
                return false;
            }
            this.f_25115_ = this.getFreePartner();
            return this.f_25115_ != null;
        }

        @javax.annotation.Nullable
        private Animal getFreePartner() {
            List list = this.f_25114_.m_45971_(MountEntity.class, PARTNER_TARGETING, (LivingEntity)this.mount, this.mount.m_20191_().m_82400_(16.0));
            double d0 = Double.MAX_VALUE;
            MountEntity animal = null;
            for (MountEntity animal1 : list) {
                if (!this.mount.m_7848_((Animal)animal1) || !(this.mount.m_20280_((Entity)animal1) < d0)) continue;
                animal = animal1;
                d0 = this.mount.m_20280_((Entity)animal1);
            }
            return animal;
        }

        public void m_8056_() {
            if (this.mount != null) {
                this.mount.resetWanderBehaviorCycle();
                this.mount.setIsSitting(false);
                this.mount.setIsSleeping(false);
                this.mount.setIsFlying(false);
            }
            if (this.mount.m_30614_()) {
                super.m_8056_();
            }
        }

        public void m_8037_() {
            this.f_25113_.m_21563_().m_24960_((Entity)this.f_25115_, 10.0f, 40.0f);
            this.f_25113_.m_21573_().m_5624_((Entity)this.f_25115_, 1.25);
            ++this.timer;
            float dist = (float)Math.max(this.f_25113_.m_20191_().m_82362_(), this.f_25113_.m_20191_().m_82385_()) + 1.0f;
            dist = Math.max(dist, 5.0f);
            if (this.timer >= 60 && this.f_25113_.m_20280_((Entity)this.f_25115_) < (double)(dist * dist)) {
                this.m_8026_();
            }
        }
    }

    public static class MountSitGoal
    extends Goal {
        private final MountEntity tameable;

        public MountSitGoal(MountEntity tameable) {
            this.tameable = tameable;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8045_() {
            return this.tameable.getIsSitting();
        }

        public boolean m_8036_() {
            if (!this.tameable.m_30614_()) {
                return false;
            }
            if (this.tameable.m_20072_()) {
                return false;
            }
            if (!this.tameable.m_20096_()) {
                return false;
            }
            Player livingEntity = this.tameable.getOwner();
            if (livingEntity == null) {
                return true;
            }
            return this.tameable.m_20280_((Entity)livingEntity) < 144.0 && livingEntity.m_21188_() != null ? false : this.tameable.getIsSitting();
        }

        public void m_8056_() {
            this.tameable.m_21573_().m_26573_();
        }
    }

    public static class MountLookAtPlayerGoal
    extends LookAtPlayerGoal {
        MountEntity e;

        public MountLookAtPlayerGoal(MountEntity mob, Class<? extends LivingEntity> targetType, float range) {
            super((Mob)mob, targetType, range);
            this.e = mob;
        }

        public MountLookAtPlayerGoal(MountEntity mob, Class<? extends LivingEntity> targetType, float range, float chance) {
            super((Mob)mob, targetType, range, chance);
            this.e = mob;
        }

        public boolean m_8036_() {
            return !this.e.getIsSleeping() && !this.e.getIsFlying() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.e.getIsSleeping() && !this.e.getIsFlying() && super.m_8045_();
        }

        public void m_8056_() {
            if (!this.e.getIsSleeping() && !this.e.getIsFlying()) {
                super.m_8056_();
            }
        }

        public void m_8037_() {
            if (!this.e.getIsSleeping() && !this.e.getIsFlying()) {
                super.m_8037_();
            }
        }
    }

    public static class MountWanderAroundGoal
    extends RandomStrollGoal {
        MountEntity e;

        public MountWanderAroundGoal(MountEntity mob, double speed) {
            super((PathfinderMob)mob, speed);
            this.e = mob;
        }

        public MountWanderAroundGoal(MountEntity mob, double speed, int chance) {
            super((PathfinderMob)mob, speed, chance, true);
            this.e = mob;
        }

        public MountWanderAroundGoal(MountEntity mob, double d, int i, boolean bl) {
            super((PathfinderMob)mob, d, i, bl);
            this.e = mob;
        }

        public boolean m_8036_() {
            return this.e.shouldMove() && !this.e.getIsFlying() && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.e.shouldMove() && super.m_8045_();
        }

        public void m_8056_() {
            if (this.e.shouldMove()) {
                super.m_8056_();
            }
        }

        protected Vec3 m_7037_() {
            Vec3i v = this.e.getTrackedPos();
            Vec3 pos = new Vec3((double)v.m_123341_(), (double)(v.m_123342_() + 1), (double)v.m_123343_());
            Vec3i posInt = new Vec3i(v.m_123341_(), v.m_123342_() + 1, v.m_123343_());
            if (this.e.m_20097_().m_123331_(posInt) > 16.0) {
                return LandRandomPos.m_148492_((PathfinderMob)this.f_25725_, (int)16, (int)5, (Vec3)pos);
            }
            return LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)10, (int)10);
        }
    }
}

