/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.entity.ai;

import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.EasingType;
import software.bernie.geckolib.core.object.PlayState;

public class MountAnimationManager {
    private MountEntity mountEntity;
    protected AnimationController<MountEntity> animationController;
    protected AnimationController<MountEntity> blinkAnimationController;
    protected AnimationController<MountEntity> idleAnimationController;
    private AnimationPhase currentMoveState;
    boolean patchouliOpen = false;
    final String guiBookClass = "class vazkii.patchouli.client.book.gui.GuiBookEntry";
    float changeDelayCount = 0.0f;
    float maxChangeDelay = 50.0f;

    public MountAnimationManager(MountEntity entity) {
        this.mountEntity = entity;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        this.animationController = new AnimationController((GeoAnimatable)this.mountEntity, "moveController", 0, this::moveAnimationPredicate);
        this.blinkAnimationController = new AnimationController((GeoAnimatable)this.mountEntity, "blinkController", 0, this::blinkAnimationPredicate);
        this.idleAnimationController = new AnimationController((GeoAnimatable)this.mountEntity, "idleController", 0, this::idleAnimationPredicate);
        this.animationController.transitionLength(10);
        this.blinkAnimationController.transitionLength(10);
        this.idleAnimationController.transitionLength(10);
        controllers.add(new AnimationController[]{this.animationController, this.blinkAnimationController, this.idleAnimationController});
    }

    protected <P extends GeoEntity> PlayState moveAnimationPredicate(AnimationState<P> event) {
        if (this.mountEntity.m_20182_().equals((Object)Vec3.f_82478_) && "class vazkii.patchouli.client.book.gui.GuiBookEntry".equals(Minecraft.m_91087_().f_91080_.getClass().toString())) {
            if (!this.patchouliOpen) {
                event.getController().setAnimation(this.mountEntity.getNeutralAnimation().thenWait(10));
            }
            event.getController().stop();
            event.getController().forceAnimationReset();
            this.patchouliOpen = true;
            return PlayState.CONTINUE;
        }
        AnimationPhase lastMoveState = this.currentMoveState;
        this.currentMoveState = this.mountEntity.getIsSleeping() ? AnimationPhase.SLEEP : (this.mountEntity.getIsClimbing() && !this.mountEntity.m_20096_() ? AnimationPhase.CLIMB : (this.mountEntity.getIsFlying() ? AnimationPhase.FLY : (event.isMoving() ? AnimationPhase.WALK : (this.mountEntity.getIsSitting() ? AnimationPhase.SIT : AnimationPhase.IDLE))));
        boolean animationDone = this.animationController.hasAnimationFinished();
        if (lastMoveState != this.currentMoveState || animationDone) {
            event.getController().forceAnimationReset();
            if (this.changeDelayCount < this.maxChangeDelay) {
                this.changeDelayCount += 1.0f;
            }
            if (this.changeDelayCount >= this.maxChangeDelay && this.currentMoveState == AnimationPhase.IDLE && lastMoveState == AnimationPhase.IDLE || this.currentMoveState == AnimationPhase.WALK && lastMoveState == AnimationPhase.IDLE || this.currentMoveState == AnimationPhase.IDLE && lastMoveState == AnimationPhase.WALK) {
                this.changeDelayCount = 0.0f;
                this.animationController.transitionLength(0);
            } else {
                this.animationController.transitionLength(10);
            }
            this.animationController.setOverrideEasingType(EasingType.LINEAR);
            if (this.mountEntity.m_5842_() && this.mountEntity.m_20184_().m_82553_() > 0.01) {
                event.getController().setAnimation(this.mountEntity.getSwimAnimation());
            } else if (!this.mountEntity.m_20096_() && this.mountEntity.getIsClimbing()) {
                event.getController().setAnimation(this.mountEntity.getClimbAnimation());
            } else if (lastMoveState == AnimationPhase.IDLE && this.currentMoveState == AnimationPhase.SIT) {
                event.getController().setAnimation(this.mountEntity.getSitDownAnimation());
            } else if (lastMoveState == AnimationPhase.SIT && this.currentMoveState == AnimationPhase.IDLE) {
                event.getController().setAnimation(this.mountEntity.getStandupAnimation());
            } else if (lastMoveState == AnimationPhase.SIT && this.currentMoveState == AnimationPhase.SLEEP) {
                event.getController().setAnimation(this.mountEntity.getGoToSleepAnimation());
            } else if (lastMoveState == AnimationPhase.SLEEP && this.currentMoveState == AnimationPhase.SIT) {
                event.getController().setAnimation(this.mountEntity.getWakeUpAnimation());
            } else if (this.mountEntity.getIsFlying()) {
                event.setAnimation(this.mountEntity.getFlyAnimation());
            } else if (this.mountEntity.getIsSleeping()) {
                event.getController().setAnimation(this.mountEntity.getSleepingAnimation());
            } else if (this.mountEntity.getIsSitting()) {
                event.getController().setAnimation(this.mountEntity.getSittingAnimation());
            } else if (event.isMoving() || this.mountEntity.m_20184_().m_82553_() > 0.1) {
                if (this.mountEntity.getTrackedAttacking()) {
                    event.getController().setAnimation(this.mountEntity.getSprintAnimation());
                } else if (this.mountEntity.m_20142_()) {
                    event.getController().setAnimation(this.mountEntity.getSprintAnimation());
                } else {
                    event.getController().setAnimation(this.mountEntity.getWalkAnimation());
                }
            } else {
                event.getController().setAnimation(this.mountEntity.getNeutralAnimation());
            }
        }
        return PlayState.CONTINUE;
    }

    protected <P extends GeoEntity> PlayState blinkAnimationPredicate(AnimationState<P> event) {
        this.blinkAnimationController.transitionLength(0);
        if (!this.mountEntity.getIsSleeping()) {
            this.blinkAnimationController.setAnimation(this.mountEntity.getBlinkAnimation());
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    protected <P extends GeoEntity> PlayState idleAnimationPredicate(AnimationState<P> event) {
        this.idleAnimationController.transitionLength(5);
        boolean switchAnimation = event.getController().hasAnimationFinished();
        if (switchAnimation) {
            if (this.mountEntity.getIsSleeping()) {
                event.getController().setAnimation(this.mountEntity.getSleepingIdleAnimation());
            } else if (this.mountEntity.getIsSitting()) {
                event.getController().setAnimation(this.mountEntity.getSittingIdleAnimation());
            } else if (this.mountEntity.getTrackedAttacking()) {
                event.getController().setAnimation(this.mountEntity.getAttackAnimation());
            } else {
                event.getController().setAnimation(this.mountEntity.getIdleAnimation());
            }
        }
        return PlayState.CONTINUE;
    }

    private static enum AnimationPhase {
        WALK,
        IDLE,
        SIT,
        SLEEP,
        FLY,
        CLIMB;

    }
}

