/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.client.renderer.model;

import com.yahoo.chirpycricket.mythicmounts.client.renderer.model.HeadRotationAdjustments;
import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;

public class AnimatedLivingEntityModel<T extends MountEntity>
extends GeoModel<T> {
    protected float size = 1.0f;
    protected float headSize = 1.0f;
    protected float scaleAdjustment = 1.0f;
    public final String geoFile;
    public final String aniFile;
    public final String texFile;
    public boolean hasExtraArmor = false;
    int sleepCount = 0;
    int maxSleepCount = 50;

    public AnimatedLivingEntityModel(String geometryFile, String animationFile, String textureFile, float scaleAdjustment, boolean hasExtraArmor) {
        this.geoFile = geometryFile;
        this.aniFile = animationFile;
        this.texFile = textureFile;
        this.scaleAdjustment = scaleAdjustment;
        this.hasExtraArmor = hasExtraArmor;
    }

    public ResourceLocation getModelResource(T entity) {
        return new ResourceLocation("mythicmounts", this.geoFile);
    }

    public ResourceLocation getAnimationResource(T animatable) {
        return new ResourceLocation("mythicmounts", this.aniFile);
    }

    public ResourceLocation getTextureResource(T entity) {
        if (((MountEntity)((Object)entity)).getTextureFile().length() > "textures/model/entity/".length()) {
            return new ResourceLocation("mythicmounts", ((MountEntity)((Object)entity)).getTextureFile());
        }
        return new ResourceLocation("mythicmounts", this.texFile);
    }

    public void applyScale(T entity) {
        if (entity.m_6162_()) {
            this.size = ((MountEntity)((Object)entity)).childScale;
            this.headSize = ((MountEntity)((Object)entity)).childHeadScale;
        } else if (((MountEntity)((Object)entity)).getIsMini()) {
            this.size = ((MountEntity)((Object)entity)).childScale * 0.75f;
            this.headSize = ((MountEntity)((Object)entity)).childHeadScale;
        } else {
            this.size = 1.0f;
            this.headSize = 1.0f;
        }
        float actualScale = this.scaleAdjustment * this.size;
        float actualHeadScale = this.headSize;
        CoreGeoBone scale = this.getAnimationProcessor().getBone("scale");
        if (scale != null) {
            CoreGeoBone head;
            scale.setScaleX(actualScale);
            scale.setScaleY(actualScale);
            scale.setScaleZ(actualScale);
            if (entity.m_6162_() && (head = (CoreGeoBone)this.getBone("head").orElse(null)) != null) {
                head.setScaleX(actualHeadScale);
                head.setScaleY(actualHeadScale);
                head.setScaleZ(actualHeadScale);
            }
        }
    }

    public void applySaddle(T entity) {
        CoreGeoBone saddle = this.getAnimationProcessor().getBone("saddle");
        CoreGeoBone bridle = this.getAnimationProcessor().getBone("bridle");
        if (saddle != null) {
            if (entity.m_6254_()) {
                saddle.setHidden(false);
                bridle.setHidden(false);
            } else {
                saddle.setHidden(true);
                bridle.setHidden(true);
            }
        }
    }

    public void applyChests(T entity) {
        CoreGeoBone chests = this.getAnimationProcessor().getBone("chests");
        CoreGeoBone chests2 = this.getAnimationProcessor().getBone("chests2");
        if (chests != null) {
            if (((MountEntity)((Object)entity)).hasChest()) {
                chests.setHidden(false);
            } else {
                chests.setHidden(true);
            }
        }
        if (chests2 != null) {
            if (((MountEntity)((Object)entity)).hasChest()) {
                chests2.setHidden(false);
            } else {
                chests2.setHidden(true);
            }
        }
    }

    public void applyArmor(T entity) {
        for (int i = 1; i < 4; ++i) {
            CoreGeoBone armor = this.getAnimationProcessor().getBone("armor" + i);
            if (armor == null) continue;
            if (entity.m_7481_()) {
                armor.setHidden(false);
                continue;
            }
            armor.setHidden(true);
        }
    }

    public void setCustomAnimations(T entity, long uniqueID, AnimationState<T> customPredicate) {
        if (!(entity.m_217005_() || ((MountEntity)((Object)entity)).getIsFlying() || ((MountEntity)((Object)entity)).getIsSleeping() || this.sleepCount < this.maxSleepCount)) {
            super.setCustomAnimations(entity, uniqueID, customPredicate);
        }
        this.applyScale(entity);
        this.applySaddle(entity);
        this.applyChests(entity);
        if (this.hasExtraArmor) {
            this.applyArmor(entity);
        }
        if (((MountEntity)((Object)entity)).getIsFlying()) {
            return;
        }
        if (!((MountEntity)((Object)entity)).getIsSleeping()) {
            T mountEntity;
            if (this.sleepCount <= this.maxSleepCount) {
                ++this.sleepCount;
            }
            if (!(((MountEntity)((Object)(mountEntity = entity))).getIsFlying() && mountEntity.m_217005_() || this.sleepCount < this.maxSleepCount)) {
                this.setHeadRotation(entity, customPredicate);
            }
        } else {
            this.sleepCount = 0;
        }
    }

    public void setHeadRotation(T entity, AnimationState customPredicate) {
        HeadRotationAdjustments.getHeadAdjustment(this, entity, customPredicate);
    }
}

