/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.registry;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.vinery.client.model.StrawHatModel;
import net.satisfy.vinery.client.model.WinemakerBootsModel;
import net.satisfy.vinery.client.model.WinemakerChestplateModel;
import net.satisfy.vinery.client.model.WinemakerLeggingsModel;
import net.satisfy.vinery.core.item.WinemakerBootsItem;
import net.satisfy.vinery.core.item.WinemakerChestItem;
import net.satisfy.vinery.core.item.WinemakerHelmetItem;
import net.satisfy.vinery.core.item.WinemakerLegsItem;
import net.satisfy.vinery.core.registry.ArmorRegistry;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ArmorRegistryClient {
    private static final Map<Item, StrawHatModel<?>> models = new HashMap();
    private static final Map<Item, WinemakerChestplateModel<?>> chestplateModels = new HashMap();
    private static final Map<Item, WinemakerLeggingsModel<?>> leggingsModels = new HashMap();
    private static final Map<Item, WinemakerBootsModel<?>> bootsModels = new HashMap();

    public static Model getHatModel(Item item, ModelPart baseHead) {
        EntityModelSet modelSet = Minecraft.m_91087_().m_167973_();
        StrawHatModel model = models.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.STRAW_HAT.get()) {
                return new StrawHatModel(modelSet.m_171103_(StrawHatModel.LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyHead(baseHead);
        }
        return model;
    }

    public static Model getChestplateModel(Item item, ModelPart body, ModelPart leftArm, ModelPart rightArm, ModelPart leftLeg, ModelPart rightLeg) {
        WinemakerChestplateModel model = chestplateModels.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.WINEMAKER_APRON.get()) {
                return new WinemakerChestplateModel(Minecraft.m_91087_().m_167973_().m_171103_(WinemakerChestplateModel.LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyBody(body, leftArm, rightArm, leftLeg, rightLeg);
        }
        return model;
    }

    public static Model getLeggingsModel(Item item, ModelPart rightLeg, ModelPart leftLeg) {
        WinemakerLeggingsModel model = leggingsModels.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.WINEMAKER_LEGGINGS.get()) {
                return new WinemakerLeggingsModel(Minecraft.m_91087_().m_167973_().m_171103_(WinemakerLeggingsModel.LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyLegs(rightLeg, leftLeg);
        }
        return model;
    }

    public static Model getBootsModel(Item item, ModelPart rightLeg, ModelPart leftLeg) {
        WinemakerBootsModel model = bootsModels.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.WINEMAKER_BOOTS.get()) {
                return new WinemakerBootsModel(Minecraft.m_91087_().m_167973_().m_171103_(WinemakerBootsModel.LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyLegs(rightLeg, leftLeg);
        }
        return model;
    }

    public static void appendToolTip(@NotNull List<Component> tooltip) {
        boolean hasFullSet;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack leggings = player.m_6844_(EquipmentSlot.LEGS);
        ItemStack boots = player.m_6844_(EquipmentSlot.FEET);
        ArmorRegistry.setBonusActive = hasFullSet = helmet.m_41720_() instanceof WinemakerHelmetItem && chestplate.m_41720_() instanceof WinemakerChestItem && leggings.m_41720_() instanceof WinemakerLegsItem && boots.m_41720_() instanceof WinemakerBootsItem;
        tooltip.add(Component.m_130674_((String)""));
        tooltip.add(Component.m_130674_((String)(String.valueOf(ChatFormatting.DARK_GREEN) + I18n.m_118938_((String)"tooltip.vinery.armor.winemaker_armor0", (Object[])new Object[0]))));
        tooltip.add(Component.m_130674_((String)((helmet.m_41720_() instanceof WinemakerHelmetItem ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.STRAW_HAT.get()).m_41466_().getString() + "]")));
        tooltip.add(Component.m_130674_((String)((chestplate.m_41720_() instanceof WinemakerChestItem ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.WINEMAKER_APRON.get()).m_41466_().getString() + "]")));
        tooltip.add(Component.m_130674_((String)((leggings.m_41720_() instanceof WinemakerLegsItem ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.WINEMAKER_LEGGINGS.get()).m_41466_().getString() + "]")));
        tooltip.add(Component.m_130674_((String)((boots.m_41720_() instanceof WinemakerBootsItem ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.WINEMAKER_BOOTS.get()).m_41466_().getString() + "]")));
        tooltip.add(Component.m_130674_((String)""));
        ChatFormatting color = hasFullSet ? ChatFormatting.GREEN : ChatFormatting.GRAY;
        tooltip.add(Component.m_130674_((String)(String.valueOf(color) + I18n.m_118938_((String)"tooltip.vinery.armor.winemaker_armor1", (Object[])new Object[0]))));
        tooltip.add(Component.m_130674_((String)(String.valueOf(color) + I18n.m_118938_((String)"tooltip.vinery.armor.winemaker_armor2", (Object[])new Object[0]))));
    }
}

