/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.satisfy.herbalbrews.client.gui.handler.CauldronGuiHandler;
import net.satisfy.herbalbrews.core.registry.ObjectRegistry;
import net.satisfy.herbalbrews.core.util.HerbalBrewsIdentifier;
import org.joml.Vector2i;

public class CauldronGui
extends AbstractContainerScreen<CauldronGuiHandler> {
    private static final ResourceLocation BACKGROUND = new HerbalBrewsIdentifier("textures/gui/cauldron.png");
    private static final int PROGRESS_X = 114;
    private static final int PROGRESS_Y = 38;
    private static final int PROGRESS_WIDTH = 11;
    private static final int PROGRESS_HEIGHT = 29;
    private static final int PROGRESS_TEX_X = 176;
    private static final int PROGRESS_TEX_Y = 0;
    private static final int CATALYST_X = 110;
    private static final int CATALYST_Y = 69;
    private static final int CATALYST_TEX_X = 176;
    private static final int CATALYST_TEX_Y = 29;
    private static final int CATALYST_WIDTH = 18;
    private static final int CATALYST_HEIGHT = 29;
    private final Vector2i screenPos = new Vector2i();

    public CauldronGui(CauldronGuiHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.screenPos.set(this.f_97735_, this.f_97736_);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.m_280218_(BACKGROUND, this.screenPos.x(), this.screenPos.y(), 0, 0, this.f_97726_, this.f_97727_);
        int progress = ((CauldronGuiHandler)this.f_97732_).getScaledProgress(29);
        guiGraphics.m_280218_(BACKGROUND, this.screenPos.x() + 114, this.screenPos.y() + 38 + (29 - progress), 176, 0 + (29 - progress), 11, progress);
        ItemStack catalyst = ((CauldronGuiHandler)this.f_97732_).m_38853_(4).m_7993_();
        if (!catalyst.m_41619_() && catalyst.m_41720_() == ObjectRegistry.HERBAL_INFUSION.get()) {
            guiGraphics.m_280218_(BACKGROUND, this.screenPos.x() + 110, this.screenPos.y() + 69, 176, 29, 18, 29);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        if (this.isMouseOverProgress(mouseX, mouseY)) {
            int remainingTicks = ((CauldronGuiHandler)this.f_97732_).getRequiredDuration() - ((CauldronGuiHandler)this.f_97732_).getCookingTime();
            String formattedTime = this.formatTicks(remainingTicks);
            MutableComponent tooltip = Component.m_237110_((String)"tooltip.herbalbrews.cauldron.remaining_time", (Object[])new Object[]{formattedTime});
            guiGraphics.m_280557_(this.f_96547_, (Component)tooltip, mouseX, mouseY);
        }
        if (this.isMouseOverInputSlot(mouseX, mouseY)) {
            MutableComponent tooltip = Component.m_237115_((String)"tooltip.herbalbrews.cauldron.input_slot");
            guiGraphics.m_280557_(this.f_96547_, (Component)tooltip, mouseX, mouseY);
        }
        super.m_280072_(guiGraphics, mouseX, mouseY);
    }

    private boolean isMouseOverProgress(int mouseX, int mouseY) {
        int left = this.screenPos.x() + 114;
        int top = this.screenPos.y() + 38;
        return mouseX >= left && mouseX < left + 11 && mouseY >= top && mouseY < top + 29;
    }

    private boolean isMouseOverInputSlot(int mouseX, int mouseY) {
        int left = this.screenPos.x() + 132;
        int top = this.screenPos.y() + 53;
        return mouseX >= left && mouseX < left + 18 && mouseY >= top && mouseY < top + 18;
    }

    private String formatTicks(int ticks) {
        int seconds = ticks / 20;
        int minutes = seconds / 60;
        return String.format("%d:%02d", minutes, seconds %= 60);
    }
}

