/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.mixin;

import com.berksire.furniture.mixin.ConditionalMixin;
import dev.architectury.platform.Platform;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class ConditionalMixinPlugin
implements IMixinConfigPlugin {
    Logger logger = LoggerFactory.getLogger(ConditionalMixinPlugin.class);

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        try {
            Class<?> mixin = Class.forName(mixinClassName);
            if (mixin.isAnnotationPresent(ConditionalMixin.class)) {
                String requiredMod = mixin.getAnnotation(ConditionalMixin.class).value();
                boolean modIsLoaded = Platform.isModLoaded((String)requiredMod);
                if (Platform.isDevelopmentEnvironment()) {
                    this.logger.info("Mixin {} requires {} to be loaded, result: {}", new Object[]{mixinClassName, requiredMod, modIsLoaded});
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }
}

