/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.client.render;

import com.berksire.furniture.block.GrandfatherClockBlock;
import com.berksire.furniture.block.entity.GrandfatherClockBlockEntity;
import com.berksire.furniture.client.model.GrandfatherClockModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class GrandfatherClockRenderer
implements BlockEntityRenderer<GrandfatherClockBlockEntity> {
    private static final Map<GrandfatherClockBlock.WoodType, ResourceLocation> TEXTURES = new EnumMap<GrandfatherClockBlock.WoodType, ResourceLocation>(GrandfatherClockBlock.WoodType.class);
    private final GrandfatherClockModel<Entity> model;

    public GrandfatherClockRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart root = context.m_173582_(GrandfatherClockModel.LAYER_LOCATION);
        this.model = new GrandfatherClockModel(root);
    }

    public void render(GrandfatherClockBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        BlockState blockstate = blockEntity.m_58900_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.5, 0.5);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        Direction direction = (Direction)blockstate.m_61143_((Property)BlockStateProperties.f_61374_);
        float rotation = direction.m_122424_().m_122435_();
        poseStack.m_252781_(new Quaternionf().rotateYXZ((float)Math.toRadians(rotation), 0.0f, 0.0f));
        long totalTime = System.currentTimeMillis();
        float smoothTime = (float)(totalTime % 60000L) / 50.0f;
        this.model.pendulum.f_104205_ = (float)Math.sin((double)smoothTime * Math.PI / 30.0) * 0.15f;
        long gameTime = Objects.requireNonNull(blockEntity.m_58904_()).m_46468_() % 24000L;
        int hours = (int)((gameTime / 1000L + 6L) % 24L);
        int minutes = (int)(gameTime % 1000L * 60L / 1000L);
        this.model.minutes.f_104205_ = (float)((double)minutes * Math.PI / 30.0);
        this.model.hours.f_104205_ = (float)((double)hours * Math.PI / 6.0);
        GrandfatherClockBlock.WoodType woodType = ((GrandfatherClockBlock)blockstate.m_60734_()).getWoodType();
        ResourceLocation texture = TEXTURES.get((Object)woodType);
        if (texture == null) {
            texture = TEXTURES.get((Object)GrandfatherClockBlock.WoodType.OAK);
        }
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)texture));
        this.model.m_7695_(poseStack, vertexConsumer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    static {
        TEXTURES.put(GrandfatherClockBlock.WoodType.OAK, new ResourceLocation("furniture", "textures/entity/oak_grandfatherclock.png"));
        TEXTURES.put(GrandfatherClockBlock.WoodType.SPRUCE, new ResourceLocation("furniture", "textures/entity/spruce_grandfatherclock.png"));
        TEXTURES.put(GrandfatherClockBlock.WoodType.BIRCH, new ResourceLocation("furniture", "textures/entity/birch_grandfatherclock.png"));
        TEXTURES.put(GrandfatherClockBlock.WoodType.JUNGLE, new ResourceLocation("furniture", "textures/entity/jungle_grandfatherclock.png"));
        TEXTURES.put(GrandfatherClockBlock.WoodType.ACACIA, new ResourceLocation("furniture", "textures/entity/acacia_grandfatherclock.png"));
        TEXTURES.put(GrandfatherClockBlock.WoodType.DARK_OAK, new ResourceLocation("furniture", "textures/entity/dark_oak_grandfatherclock.png"));
        TEXTURES.put(GrandfatherClockBlock.WoodType.MANGROVE, new ResourceLocation("furniture", "textures/entity/mangrove_grandfatherclock.png"));
        TEXTURES.put(GrandfatherClockBlock.WoodType.CHERRY, new ResourceLocation("furniture", "textures/entity/cherry_grandfatherclock.png"));
    }
}

