/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.client.render;

import com.berksire.furniture.block.GramophoneBlock;
import com.berksire.furniture.block.entity.GramophoneBlockEntity;
import com.berksire.furniture.client.model.GramophoneModel;
import com.berksire.furniture.util.FurnitureIdentifier;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class GramophoneRenderer
implements BlockEntityRenderer<GramophoneBlockEntity> {
    private static final ResourceLocation TEXTURE = new FurnitureIdentifier("textures/entity/gramophone.png");
    private final GramophoneModel<?> model;

    public GramophoneRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new GramophoneModel(context.m_173582_(GramophoneModel.LAYER_LOCATION));
    }

    public void render(GramophoneBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        BlockState blockState = blockEntity.m_58900_();
        if (blockState.m_61143_(GramophoneBlock.HALF) == DoubleBlockHalf.UPPER) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        Direction direction = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_);
        float rotation = switch (direction) {
            case Direction.NORTH -> 0.0f;
            case Direction.SOUTH -> 180.0f;
            default -> direction.m_122435_();
        };
        poseStack.m_252781_(new Quaternionf().rotateYXZ((float)Math.toRadians(rotation), 0.0f, 0.0f));
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        ModelPart base = this.model.gramophone.m_171324_("base");
        this.model.disc.f_104207_ = false;
        base.m_104306_(poseStack, bufferSource.m_6299_(this.model.m_103119_(TEXTURE)), combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        this.model.disc.f_104207_ = true;
        this.model.gramophone.m_171324_("horn").m_104306_(poseStack, bufferSource.m_6299_(this.model.m_103119_(TEXTURE)), combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (((Boolean)blockState.m_61143_((Property)GramophoneBlock.HAS_RECORD)).booleanValue()) {
            float totalGameTime = (float)(Objects.requireNonNull(blockEntity.m_58904_()).m_46467_() % 360L) + partialTicks;
            float discRotation = totalGameTime * 5.0f % 360.0f;
            float verticalMovement = (float)Math.sin((double)totalGameTime * 0.1) * 0.002f;
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, (double)(0.0f + verticalMovement), -0.5);
            poseStack.m_85837_((double)(this.model.disc.f_104200_ / 16.0f), 0.0, (double)(this.model.disc.f_104202_ / 16.0f));
            poseStack.m_252781_(new Quaternionf().rotateY((float)Math.toRadians(discRotation)));
            poseStack.m_85837_((double)(-this.model.disc.f_104200_ / 16.0f), 0.0, (double)(-this.model.disc.f_104202_ / 16.0f));
            this.model.disc.m_104306_(poseStack, bufferSource.m_6299_(this.model.m_103119_(TEXTURE)), combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }
}

