/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.client;

import com.berksire.furniture.client.model.ClockModel;
import com.berksire.furniture.client.model.FishTankModel;
import com.berksire.furniture.client.model.GramophoneModel;
import com.berksire.furniture.client.model.GrandfatherClockModel;
import com.berksire.furniture.client.render.CanvasRenderer;
import com.berksire.furniture.client.render.ChairRenderer;
import com.berksire.furniture.client.render.ClockRenderer;
import com.berksire.furniture.client.render.CofferRenderer;
import com.berksire.furniture.client.render.DisplayRenderer;
import com.berksire.furniture.client.render.FishTankRenderer;
import com.berksire.furniture.client.render.GramophoneRenderer;
import com.berksire.furniture.client.render.GrandfatherClockRenderer;
import com.berksire.furniture.client.render.PellsRenderer;
import com.berksire.furniture.registry.EntityTypeRegistry;
import com.berksire.furniture.registry.ObjectRegistry;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.stream.Stream;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FurnitureClient {
    public static void onInitializeClient() {
        RenderTypeRegistry.register((RenderType)RenderType.m_110463_(), (Block[])new Block[]{(Block)ObjectRegistry.BIN.get(), (Block)ObjectRegistry.GRAMOPHONE.get(), (Block)ObjectRegistry.CASH_REGISTER.get(), (Block)ObjectRegistry.BOAT_IN_A_JAR.get(), (Block)ObjectRegistry.STREET_LANTERN.get(), (Block)ObjectRegistry.STREET_WALL_LANTERN.get(), (Block)ObjectRegistry.PLATED_STREET_LANTERN.get(), (Block)ObjectRegistry.PLATED_STREET_WALL_LANTERN.get(), (Block)ObjectRegistry.DISPLAY.get(), (Block)ObjectRegistry.TERRARIUM.get()});
        for (RegistrySupplier<Block> block : Stream.concat(Stream.concat(ObjectRegistry.LAMPS.values().stream(), ObjectRegistry.WALL_LAMPS.values().stream()), Stream.concat(ObjectRegistry.BENCHES.values().stream(), Stream.concat(ObjectRegistry.DESKS.values().stream(), ObjectRegistry.DESK_CHAIRS.values().stream()))).toList()) {
            RenderTypeRegistry.register((RenderType)RenderType.m_110463_(), (Block[])new Block[]{(Block)block.get()});
        }
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.GRANDFATHER_CLOCK_BLOCK_ENTITY.get()), GrandfatherClockRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.CLOCK_BLOCK_ENTITY.get()), ClockRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.GRAMOPHONE_BLOCK_ENTITY.get()), GramophoneRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.COFFER_BLOCK_ENTITY.get()), CofferRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.DISPLAY_BLOCK_ENTITY.get()), context -> new DisplayRenderer());
    }

    public static void preInitClient() {
        FurnitureClient.registerEntityModelLayer();
        FurnitureClient.registerEntityRenderers();
    }

    public static void registerEntityRenderers() {
        EntityRendererRegistry.register(EntityTypeRegistry.CHAIR, ChairRenderer::new);
        EntityRendererRegistry.register(EntityTypeRegistry.CANVAS, CanvasRenderer::new);
        EntityRendererRegistry.register(EntityTypeRegistry.PELLS, PellsRenderer::new);
        EntityRendererRegistry.register(EntityTypeRegistry.FAKE_FISH_TANK, FishTankRenderer::new);
    }

    public static void registerEntityModelLayer() {
        EntityModelLayerRegistry.register((ModelLayerLocation)GrandfatherClockModel.LAYER_LOCATION, GrandfatherClockModel::getTexturedModelData);
        EntityModelLayerRegistry.register((ModelLayerLocation)ClockModel.LAYER_LOCATION, ClockModel::getTexturedModelData);
        EntityModelLayerRegistry.register((ModelLayerLocation)GramophoneModel.LAYER_LOCATION, GramophoneModel::getTexturedModelData);
        EntityModelLayerRegistry.register((ModelLayerLocation)FishTankModel.LAYER_LOCATION, FishTankModel::getTexturedModelData);
        EntityModelLayerRegistry.register((ModelLayerLocation)CofferRenderer.LAYER_LOCATION, CofferRenderer::getTexturedModelData);
    }
}

