/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.block;

import com.berksire.furniture.util.FurnitureUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class StreetLanternBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<FurnitureUtil.VerticalConnectingType> TYPE = FurnitureUtil.VerticalConnectingType.VERTICAL_CONNECTING_TYPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty BULBS = IntegerProperty.m_61631_((String)"bulbs", (int)0, (int)1);
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    private static final Supplier<VoxelShape> SINGLE_SHAPE_SUPPLIER = StreetLanternBlock::makeSingleShape;
    private static final Supplier<VoxelShape> DOUBLE_SHAPE_SUPPLIER = StreetLanternBlock::makeDoubleShape;
    private static final Supplier<VoxelShape> MIDDLE_SHAPE_SUPPLIER = StreetLanternBlock::makeMiddleShape;
    private static final Supplier<VoxelShape> BOTTOM_SHAPE_SUPPLIER = StreetLanternBlock::makeBottomShape;
    public static final Map<Direction, VoxelShape> SINGLE_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, SINGLE_SHAPE_SUPPLIER.get()));
        }
    });
    public static final Map<Direction, VoxelShape> DOUBLE_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, DOUBLE_SHAPE_SUPPLIER.get()));
        }
    });
    public static final Map<Direction, VoxelShape> MIDDLE_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, MIDDLE_SHAPE_SUPPLIER.get()));
        }
    });
    public static final Map<Direction, VoxelShape> BOTTOM_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, BOTTOM_SHAPE_SUPPLIER.get()));
        }
    });

    public StreetLanternBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)FurnitureUtil.VerticalConnectingType.NONE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BULBS, (Comparable)Integer.valueOf(0))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_, TYPE, WATERLOGGED, BULBS, LIT});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos clickedPos = context.m_8083_();
        BlockPos belowPos = clickedPos.m_7495_();
        BlockState belowBlockState = context.m_43725_().m_8055_(belowPos);
        if (!(belowBlockState.m_60713_((Block)this) || belowBlockState.m_60734_() instanceof WallBlock || belowBlockState.m_60734_() instanceof FenceBlock || belowBlockState.m_60783_((BlockGetter)context.m_43725_(), belowPos, Direction.UP))) {
            return null;
        }
        BlockState blockState = context.m_43725_().m_8055_(clickedPos);
        if (blockState.m_60713_((Block)this) && (blockState.m_61143_(TYPE) == FurnitureUtil.VerticalConnectingType.TOP || blockState.m_61143_(TYPE) == FurnitureUtil.VerticalConnectingType.NONE)) {
            return (BlockState)blockState.m_61124_((Property)BULBS, (Comparable)Integer.valueOf(Math.min(1, (Integer)blockState.m_61143_((Property)BULBS) + 1)));
        }
        boolean flag = context.m_43725_().m_6425_(clickedPos).m_76152_() == Fluids.f_76193_;
        Direction direction = context.m_8125_().m_122424_();
        blockState = (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction);
        blockState = (BlockState)blockState.m_61124_(TYPE, (Comparable)((Object)this.getType(blockState, context.m_43725_().m_8055_(clickedPos.m_7494_()), context.m_43725_().m_8055_(clickedPos.m_7495_()))));
        return (BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = world.m_8055_(belowPos);
        return belowState.m_60713_((Block)this) || belowState.m_60734_() instanceof WallBlock || belowState.m_60734_() instanceof FenceBlock || belowState.m_60783_((BlockGetter)world, belowPos, Direction.UP);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (world.f_46443_) {
            return;
        }
        FurnitureUtil.VerticalConnectingType type = this.getType(state, world.m_8055_(pos.m_7494_()), world.m_8055_(pos.m_7495_()));
        if (state.m_61143_(TYPE) != type) {
            state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)type));
        }
        world.m_7731_(pos, state, 3);
    }

    public FurnitureUtil.VerticalConnectingType getType(BlockState state, BlockState above, BlockState below) {
        boolean shapeBelowSame;
        boolean shapeAboveSame = above.m_60734_() == state.m_60734_();
        boolean bl = shapeBelowSame = below.m_60734_() == state.m_60734_();
        if (shapeAboveSame && shapeBelowSame) {
            return FurnitureUtil.VerticalConnectingType.MIDDLE;
        }
        if (shapeAboveSame) {
            return FurnitureUtil.VerticalConnectingType.BOTTOM;
        }
        if (shapeBelowSame) {
            return FurnitureUtil.VerticalConnectingType.TOP;
        }
        return FurnitureUtil.VerticalConnectingType.NONE;
    }

    private static VoxelShape makeDoubleShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.5625, (double)0.3125, (double)0.375, (double)1.0, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.625, (double)0.5625, (double)0.3125, (double)1.0, (double)1.0, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.5, (double)0.375, (double)0.3125, (double)0.5625, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.6875, (double)0.5, (double)0.375, (double)0.9375, (double)0.5625, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.125, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.125, (double)0.4375, (double)0.5625, (double)0.375, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.25, (double)0.5, (double)0.875, (double)0.5, (double)0.5), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeBottomShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeSingleShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.5, (double)0.3125, (double)0.6875, (double)0.9375, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.4375, (double)0.375, (double)0.625, (double)0.5, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.125, (double)0.4375, (double)0.5625, (double)0.4375, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.125, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeMiddleShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)1.0, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        FurnitureUtil.VerticalConnectingType type = (FurnitureUtil.VerticalConnectingType)((Object)state.m_61143_(TYPE));
        if ((Integer)state.m_61143_((Property)BULBS) == 1) {
            return DOUBLE_SHAPE.get(direction);
        }
        return switch (type) {
            case FurnitureUtil.VerticalConnectingType.MIDDLE -> MIDDLE_SHAPE.get(direction);
            case FurnitureUtil.VerticalConnectingType.BOTTOM -> BOTTOM_SHAPE.get(direction);
            default -> SINGLE_SHAPE.get(direction);
        };
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return useContext.m_7078_() && useContext.m_43722_().m_150930_(this.m_5456_()) && (Integer)state.m_61143_((Property)BULBS) < 1 || super.m_6864_(state, useContext);
    }

    public static boolean canProvideLight(BlockState state) {
        return (Boolean)state.m_61143_((Property)LIT) != false && (state.m_61143_(TYPE) == FurnitureUtil.VerticalConnectingType.TOP || state.m_61143_(TYPE) == FurnitureUtil.VerticalConnectingType.NONE);
    }

    public static int vanillaLightLevel(BlockState state) {
        return (Boolean)state.m_61143_((Property)LIT) != false ? 15 : 0;
    }
}

