/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.block;

import com.berksire.furniture.block.LineConnectingBlock;
import com.berksire.furniture.util.FurnitureUtil;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class DeskBlock
extends LineConnectingBlock
implements SimpleWaterloggedBlock {
    private static final Map<FurnitureUtil.LineConnectingType, Supplier<VoxelShape>> SHAPES_SUPPLIERS = new HashMap<FurnitureUtil.LineConnectingType, Supplier<VoxelShape>>();
    private static final Map<Direction, Map<FurnitureUtil.LineConnectingType, VoxelShape>> SHAPES = new EnumMap<Direction, Map<FurnitureUtil.LineConnectingType, VoxelShape>>(Direction.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public DeskBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        Direction facing = context.m_8125_().m_122424_();
        BlockState blockState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(clickedPos).m_76152_() == Fluids.f_76193_));
        return switch (facing) {
            case Direction.EAST -> (BlockState)blockState.m_61124_((Property)TYPE, (Comparable)((Object)this.getType(blockState, world.m_8055_(clickedPos.m_122019_()), world.m_8055_(clickedPos.m_122012_()))));
            case Direction.SOUTH -> (BlockState)blockState.m_61124_((Property)TYPE, (Comparable)((Object)this.getType(blockState, world.m_8055_(clickedPos.m_122024_()), world.m_8055_(clickedPos.m_122029_()))));
            case Direction.WEST -> (BlockState)blockState.m_61124_((Property)TYPE, (Comparable)((Object)this.getType(blockState, world.m_8055_(clickedPos.m_122012_()), world.m_8055_(clickedPos.m_122019_()))));
            default -> (BlockState)blockState.m_61124_((Property)TYPE, (Comparable)((Object)this.getType(blockState, world.m_8055_(clickedPos.m_122029_()), world.m_8055_(clickedPos.m_122024_()))));
        };
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        FurnitureUtil.LineConnectingType type = (FurnitureUtil.LineConnectingType)((Object)state.m_61143_((Property)TYPE));
        return SHAPES.get(direction).get((Object)type);
    }

    private static VoxelShape makeSingleShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.75, (double)0.25, (double)0.8125, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.0, (double)0.0625, (double)0.9375, (double)0.8125, (double)0.25), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.0, (double)0.75, (double)0.9375, (double)0.8125, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.25, (double)0.8125, (double)0.25), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.8125, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeRightShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.0, (double)0.0625, (double)0.9375, (double)0.8125, (double)0.25), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.0, (double)0.75, (double)0.9375, (double)0.8125, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.8125, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeLeftShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.75, (double)0.25, (double)0.8125, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.25, (double)0.8125, (double)0.25), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.8125, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeMiddleShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.8125, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    static {
        SHAPES_SUPPLIERS.put(FurnitureUtil.LineConnectingType.NONE, DeskBlock::makeSingleShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.LineConnectingType.MIDDLE, DeskBlock::makeMiddleShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.LineConnectingType.RIGHT, DeskBlock::makeRightShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.LineConnectingType.LEFT, DeskBlock::makeLeftShape);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            SHAPES.put(direction, new HashMap());
            for (Map.Entry<FurnitureUtil.LineConnectingType, Supplier<VoxelShape>> entry : SHAPES_SUPPLIERS.entrySet()) {
                SHAPES.get(direction).put(entry.getKey(), FurnitureUtil.rotateShape(Direction.NORTH, direction, entry.getValue().get()));
            }
        }
    }
}

