/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.entity.ai;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.satisfy.farm_and_charm.core.block.entity.ChickenCoopBlockEntity;
import net.satisfy.farm_and_charm.core.entity.ChickenCoopAccess;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;

public class ChickenLocateCoopGoal
extends Goal {
    private final Chicken chicken;
    private BlockPos foundCoop;
    private BlockPos foundApproach;
    private final Set<BlockPos> cachedCoops = new HashSet<BlockPos>();
    private int nextScanTick;

    public ChickenLocateCoopGoal(Chicken chicken) {
        this.chicken = chicken;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.chicken.m_6162_()) {
            return false;
        }
        ChickenCoopAccess access = (ChickenCoopAccess)this.chicken;
        if (access.farmAndCharm$hasCoopTarget()) {
            return false;
        }
        if (access.farmAndCharm$searchedForCoop()) {
            return false;
        }
        if (access.farmAndCharm$getCoopCooldown() > 0) {
            return false;
        }
        if (this.chicken.f_19797_ < this.nextScanTick) {
            return false;
        }
        ServerLevel level = (ServerLevel)this.chicken.m_9236_();
        if (this.foundCoop != null) {
            BlockPos approach;
            ChickenCoopBlockEntity coop;
            BlockEntity be;
            if (level.m_8055_(this.foundCoop).m_60713_((Block)ObjectRegistry.CHICKEN_COOP.get()) && (be = level.m_7702_(this.foundCoop)) instanceof ChickenCoopBlockEntity && (coop = (ChickenCoopBlockEntity)be).hasSpaceForChicken() && (approach = ChickenLocateCoopGoal.findApproach(level, this.foundCoop)) != null && this.hasLineOfSight(level, this.chicken.m_146892_(), Vec3.m_82512_((Vec3i)approach)) && this.chicken.m_21573_().m_7864_(approach, 0) != null) {
                this.foundApproach = approach;
                return true;
            }
            this.foundCoop = null;
            this.foundApproach = null;
        }
        Iterator<BlockPos> it = this.cachedCoops.iterator();
        while (it.hasNext()) {
            ChickenCoopBlockEntity coop;
            BlockPos cached = it.next();
            if (!level.m_8055_(cached).m_60713_((Block)ObjectRegistry.CHICKEN_COOP.get())) {
                it.remove();
                continue;
            }
            BlockEntity be = level.m_7702_(cached);
            if (!(be instanceof ChickenCoopBlockEntity) || !(coop = (ChickenCoopBlockEntity)be).hasSpaceForChicken()) {
                it.remove();
                continue;
            }
            BlockPos approach = ChickenLocateCoopGoal.findApproach(level, cached);
            if (approach == null) {
                it.remove();
                continue;
            }
            if (!this.hasLineOfSight(level, this.chicken.m_146892_(), Vec3.m_82512_((Vec3i)approach)) || this.chicken.m_21573_().m_7864_(approach, 0) == null) continue;
            this.foundCoop = cached;
            this.foundApproach = approach;
            this.nextScanTick = this.chicken.f_19797_ + 40;
            return true;
        }
        BlockPos pos = this.chicken.m_20183_();
        this.foundCoop = BlockPos.m_121930_((BlockPos)pos, (int)12, (int)2, check -> {
            ChickenCoopBlockEntity coop;
            if (!level.m_8055_(check).m_60713_((Block)ObjectRegistry.CHICKEN_COOP.get())) {
                return false;
            }
            BlockEntity be = level.m_7702_(check);
            if (!(be instanceof ChickenCoopBlockEntity) || !(coop = (ChickenCoopBlockEntity)be).hasSpaceForChicken()) {
                return false;
            }
            BlockPos approach = ChickenLocateCoopGoal.findApproach(level, check);
            if (approach == null) {
                return false;
            }
            if (!this.hasLineOfSight(level, this.chicken.m_146892_(), Vec3.m_82512_((Vec3i)approach))) {
                return false;
            }
            if (this.chicken.m_21573_().m_7864_(approach, 0) == null) {
                return false;
            }
            if (this.cachedCoops.size() >= 16) {
                BlockPos far = null;
                double max = -1.0;
                for (BlockPos p : this.cachedCoops) {
                    double d = p.m_123331_((Vec3i)pos);
                    if (!(d > max)) continue;
                    max = d;
                    far = p;
                }
                if (far != null) {
                    this.cachedCoops.remove(far);
                }
            }
            this.cachedCoops.add((BlockPos)check);
            this.foundApproach = approach;
            return true;
        }).orElse(null);
        this.nextScanTick = this.chicken.f_19797_ + 40;
        return this.foundCoop != null && this.foundApproach != null;
    }

    public void m_8056_() {
        ((ChickenCoopAccess)this.chicken).farmAndCharm$setCoopTarget(this.foundCoop);
        ((ChickenCoopAccess)this.chicken).farmAndCharm$setSearchedForCoop(true);
        Vec3 center = Vec3.m_82512_((Vec3i)(this.foundApproach != null ? this.foundApproach : this.foundCoop));
        this.chicken.m_21573_().m_26519_(center.f_82479_, center.f_82480_, center.f_82481_, 1.0);
    }

    private static BlockPos findApproach(ServerLevel level, BlockPos coopPos) {
        for (Direction d : Direction.Plane.HORIZONTAL) {
            BlockPos side = coopPos.m_121945_(d);
            if (!level.m_8055_(side).m_60795_() || !level.m_8055_(side.m_7494_()).m_60795_()) continue;
            return side;
        }
        return null;
    }

    private boolean hasLineOfSight(ServerLevel level, Vec3 from, Vec3 to) {
        if ((this.chicken.f_19797_ & 9) != 0) {
            return true;
        }
        BlockHitResult hit = level.m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.chicken));
        return hit.m_6662_() == HitResult.Type.MISS;
    }
}

