/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.farm_and_charm.core.entity.ChickenCoopAccess;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;

public class ChickenCoopBlockEntity
extends BlockEntity {
    private static final int MAX_CHICKENS = 3;
    private static final int MAX_EGGS = 9;
    private final List<CompoundTag> storedChickens = new ArrayList<CompoundTag>();
    private int eggCount = 0;

    public ChickenCoopBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.CHICKEN_COOP_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, ChickenCoopBlockEntity coop) {
        if (level.f_46443_) {
            return;
        }
        Iterator<CompoundTag> iterator = coop.storedChickens.iterator();
        while (iterator.hasNext()) {
            CompoundTag chickenTag = iterator.next();
            int ticks = chickenTag.m_128451_("CoopTime") - 1;
            if (ticks <= 0) {
                chickenTag.m_128473_("CoopTime");
                Entity chicken = EntityType.f_20555_.m_20615_(level);
                if (!(chicken instanceof Chicken)) continue;
                Chicken spawned = (Chicken)chicken;
                int coopCooldown = 1200 * (4 + level.m_213780_().m_188503_(2));
                spawned.m_20258_(chickenTag);
                spawned.m_21153_(spawned.m_21233_());
                spawned.m_6842_(false);
                spawned.m_21557_(false);
                spawned.m_20225_(false);
                if (spawned instanceof ChickenCoopAccess) {
                    ChickenCoopAccess coopChicken = (ChickenCoopAccess)spawned;
                    coopChicken.farmAndCharm$setCoopCooldown(coopCooldown);
                }
                BlockPos spawnPos = ChickenCoopBlockEntity.findSafeSpawnPosition(level, pos);
                spawned.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, spawned.m_146908_(), spawned.m_146909_());
                level.m_7967_((Entity)spawned);
                iterator.remove();
                coop.m_6596_();
                level.m_7260_(pos, coop.m_58900_(), coop.m_58900_(), 3);
                continue;
            }
            chickenTag.m_128405_("CoopTime", ticks);
        }
    }

    private static BlockPos findSafeSpawnPosition(Level level, BlockPos center) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos offset = center.m_121945_(dir);
            if (!level.m_8055_(offset).m_60795_() || !level.m_8055_(offset.m_7494_()).m_60795_()) continue;
            return offset;
        }
        return center.m_7494_();
    }

    public boolean hasSpaceForChicken() {
        return this.storedChickens.size() < 3;
    }

    public void addChicken(Chicken chicken) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (!this.hasSpaceForChicken()) {
            return;
        }
        CompoundTag tag = new CompoundTag();
        chicken.m_20223_(tag);
        tag.m_128473_("Leash");
        tag.m_128405_("CoopTime", 200 + chicken.m_217043_().m_188503_(200));
        this.storedChickens.add(tag);
        if (chicken.m_21524_() != null) {
            chicken.m_21455_(true, false);
            chicken.m_19998_((ItemLike)Items.f_42655_);
        }
        chicken.m_8127_();
        chicken.m_20153_();
        chicken.m_21557_(true);
        chicken.m_20225_(true);
        chicken.m_6842_(true);
        chicken.m_146870_();
        this.addEgg();
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public void releaseAllChickens() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        for (CompoundTag tag : new ArrayList<CompoundTag>(this.storedChickens)) {
            tag.m_128473_("CoopTime");
            Entity chicken = EntityType.f_20555_.m_20615_(this.f_58857_);
            if (!(chicken instanceof Chicken)) continue;
            Chicken spawned = (Chicken)chicken;
            int coopCooldown = 1200 * (4 + this.f_58857_.m_213780_().m_188503_(2));
            spawned.m_20258_(tag);
            spawned.m_21153_(spawned.m_21233_());
            spawned.m_6842_(false);
            spawned.m_21557_(false);
            spawned.m_20225_(false);
            if (spawned instanceof ChickenCoopAccess) {
                ChickenCoopAccess coopChicken = (ChickenCoopAccess)spawned;
                coopChicken.farmAndCharm$setCoopCooldown(coopCooldown);
            }
            BlockPos spawnPos = ChickenCoopBlockEntity.findSafeSpawnPosition(this.f_58857_, this.f_58858_);
            spawned.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, spawned.m_146908_(), spawned.m_146909_());
            this.f_58857_.m_7967_((Entity)spawned);
        }
        this.storedChickens.clear();
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public boolean containsChicken(Chicken chicken) {
        for (CompoundTag tag : this.storedChickens) {
            if (!tag.m_128425_("UUID", 11) || !tag.m_128342_("UUID").equals(chicken.m_20148_())) continue;
            return true;
        }
        return false;
    }

    public void addEgg() {
        if (this.eggCount < 9) {
            ++this.eggCount;
            this.m_6596_();
        }
    }

    public int getEggCount() {
        return this.eggCount;
    }

    public void clearEggs() {
        this.eggCount = 0;
        this.m_6596_();
    }

    public List<CompoundTag> getStoredChickens() {
        return this.storedChickens;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag chickenList = new ListTag();
        for (CompoundTag chickenTag : this.storedChickens) {
            chickenList.add((Object)chickenTag.m_6426_());
        }
        tag.m_128365_("Chickens", (Tag)chickenList);
        tag.m_128405_("EggCount", this.eggCount);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.storedChickens.clear();
        ListTag chickenList = tag.m_128437_("Chickens", 10);
        for (int i = 0; i < chickenList.size(); ++i) {
            CompoundTag chickenTag = chickenList.m_128728_(i);
            this.storedChickens.add(chickenTag);
        }
        this.eggCount = tag.m_128451_("EggCount");
    }
}

