/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.platform.PlatformHelper;
import org.jetbrains.annotations.Nullable;

public class FertilizedFarmlandBlock
extends FarmBlock {
    public FertilizedFarmlandBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static void turnToSoil(@Nullable Entity entity, BlockState blockState, Level level, BlockPos blockPos) {
        BlockState blockState2 = FertilizedFarmlandBlock.m_49897_((BlockState)blockState, (BlockState)((Block)ObjectRegistry.FERTILIZED_SOIL_BLOCK.get()).m_49966_(), (LevelAccessor)level, (BlockPos)blockPos);
        level.m_46597_(blockPos, blockState2);
        level.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)blockState2));
    }

    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        return !this.m_49966_().m_60710_((LevelReader)blockPlaceContext.m_43725_(), blockPlaceContext.m_8083_()) ? ((Block)ObjectRegistry.FERTILIZED_SOIL_BLOCK.get()).m_49966_() : super.m_5573_(blockPlaceContext);
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
    }

    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (randomSource.m_188501_() < this.getGrowthChance(serverLevel, blockPos)) {
            this.applyBonemealEffect(serverLevel, blockPos, randomSource);
        }
    }

    private float getGrowthChance(ServerLevel serverLevel, BlockPos blockPos) {
        int lightLevel = serverLevel.m_46803_(blockPos.m_7494_());
        return lightLevel >= 10 ? 0.055f : 0.05f;
    }

    private void applyBonemealEffect(ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        BonemealableBlock bonemealableBlock;
        if (PlatformHelper.isBonemealEffectEnabled()) {
            return;
        }
        BlockPos posAbove = blockPos.m_7494_();
        BlockState stateAbove = serverLevel.m_8055_(posAbove);
        Block block = stateAbove.m_60734_();
        if (block instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)block).m_7370_((LevelReader)serverLevel, posAbove, stateAbove, false)) {
            bonemealableBlock.m_214148_(serverLevel, randomSource, posAbove, stateAbove);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)posAbove.m_123341_() + 0.5, (double)posAbove.m_123342_() + 1.0, (double)posAbove.m_123343_() + 0.5, 5, 0.5, 0.5, 0.5, 0.5);
        }
        this.checkAndTurnToSoil(serverLevel, blockPos, serverLevel.m_8055_(blockPos));
    }

    private void checkAndTurnToSoil(ServerLevel serverLevel, BlockPos blockPos, BlockState currentBlockState) {
        if (currentBlockState.m_60713_((Block)ObjectRegistry.FERTILIZED_SOIL_BLOCK.get())) {
            FertilizedFarmlandBlock.turnToSoil(null, currentBlockState, (Level)serverLevel, blockPos);
        }
    }

    public void m_142072_(Level level, BlockState blockState, BlockPos blockPos, Entity entity, float f) {
    }
}

