/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.forge;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import de.cristelknight.doapi.DoApi;
import de.cristelknight.doapi.forge.ApiFinder;
import de.cristelknight.doapi.forge.common.packs.BuiltInPackRegistry;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.PathPackResources;

public class DoApiEPImpl {
    public static <T extends Recipe<?>> T fromJson(ResourceLocation recipeId, JsonObject json) {
        JsonObject recipe = GsonHelper.m_13930_((JsonObject)json, (String)"recipe");
        JsonArray conditions = GsonHelper.m_13933_((JsonObject)json, (String)"conditions");
        JsonObject forgeRecipe = new JsonObject();
        forgeRecipe.addProperty("type", "forge:conditional");
        JsonArray recipes = new JsonArray();
        JsonObject newRecipe = new JsonObject();
        newRecipe.add("conditions", (JsonElement)conditions);
        newRecipe.add("recipe", (JsonElement)recipe);
        recipes.add((JsonElement)newRecipe);
        forgeRecipe.add("recipes", (JsonElement)recipes);
        return (T)ConditionalRecipe.SERIALZIER.m_6729_(recipeId, forgeRecipe);
    }

    public static boolean isModLoaded(String modid) {
        ModList modList = ModList.get();
        if (modList != null) {
            return modList.isLoaded(modid);
        }
        return DoApiEPImpl.isModPreLoaded(modid);
    }

    public static void registerBuiltInPack(String modId, ResourceLocation location, boolean alwaysEnabled) {
        String stringPath = location.m_135815_();
        Path path = DoApiEPImpl.getResourceDirectory(modId, "resourcepacks/" + stringPath);
        if (path == null) {
            return;
        }
        String[] pathElements = stringPath.split("/");
        BuiltInPackRegistry.packResources.put(location, (Pair<PackResources, Boolean>)new Pair((Object)new PathPackResources(pathElements[pathElements.length - 1], true, path), (Object)alwaysEnabled));
    }

    @Nullable
    public static Path getResourceDirectory(String modId, String subPath) {
        ModContainer container = ModList.get().getModContainerById(modId).orElse(null);
        if (container == null) {
            DoApi.LOGGER.warn("Mod container for modId:" + modId + " is null");
            return null;
        }
        IModFile file = container.getModInfo().getOwningFile().getFile();
        Path path = file.findResource(new String[]{subPath});
        if (path == null) {
            DoApi.LOGGER.warn("Path for subPath: " + subPath + " in modId: " + modId + " is null");
        }
        return path;
    }

    public static <T> List<Pair<List<String>, T>> findAPIs(Class<T> returnClazz, String name, Class<?> annotationClazz) {
        return ApiFinder.scanForAPIs(annotationClazz, returnClazz);
    }

    public static boolean isModPreLoaded(String modid) {
        return DoApiEPImpl.getPreLoadedModInfo(modid) != null;
    }

    @Nullable
    public static ModInfo getPreLoadedModInfo(String modId) {
        for (ModInfo info : LoadingModList.get().getMods()) {
            if (!info.getModId().equals(modId)) continue;
            return info;
        }
        return null;
    }

    public static Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }
}

