/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.item.spell_books;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.item.SpellBook;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;

public class SimpleAttributeSpellBook
extends SpellBook {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public SimpleAttributeSpellBook(int spellSlots, SpellRarity rarity, Attribute attribute, double value) {
        this(spellSlots, rarity, attribute, value, 0.0);
    }

    public SimpleAttributeSpellBook(int spellSlots, SpellRarity rarity, Attribute attribute, double value, double mana) {
        this(spellSlots, rarity, SimpleAttributeSpellBook.createMultimap(attribute, new AttributeModifier(UUID.fromString("667ad88f-901d-4691-b2a2-3664e42026d3"), "Weapon modifier", value, AttributeModifier.Operation.MULTIPLY_BASE), mana));
    }

    public SimpleAttributeSpellBook(int spellSlots, SpellRarity rarity, Multimap<Attribute, AttributeModifier> defaultModifiers) {
        super(spellSlots, rarity);
        this.defaultModifiers = defaultModifiers;
    }

    public SimpleAttributeSpellBook(int spellSlots, SpellRarity rarity, Multimap<Attribute, AttributeModifier> defaultModifiers, Item.Properties properties) {
        super(spellSlots, rarity, properties);
        this.defaultModifiers = defaultModifiers;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        ImmutableMultimap.Builder attributeBuilder = new ImmutableMultimap.Builder();
        for (Attribute attribute : this.defaultModifiers.keySet()) {
            Collection modifiers = this.defaultModifiers.get((Object)attribute);
            for (AttributeModifier attributeModifier : modifiers) {
                attributeBuilder.put((Object)attribute, (Object)new AttributeModifier(uuid, attributeModifier.m_22214_(), attributeModifier.m_22218_(), attributeModifier.m_22217_()));
            }
        }
        return attributeBuilder.build();
    }

    private static Multimap<Attribute, AttributeModifier> createMultimap(Attribute attribute, AttributeModifier modifier, double mana) {
        HashMultimap map = HashMultimap.create();
        map.put((Object)attribute, (Object)modifier);
        if (mana > 0.0) {
            map.put((Object)((Attribute)AttributeRegistry.MAX_MANA.get()), (Object)new AttributeModifier(UUID.fromString("667ad88f-901d-4691-b2a2-3664e88826d3"), "Weapon modifier", mana, AttributeModifier.Operation.ADDITION));
        }
        return map;
    }
}

