/*
 * Decompiled with CFR 0.152.
 */
package de.bene2212.holdmyitems.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.bene2212.holdmyitems.interfaces.AlternateBlockRenderer;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BlockRenderDispatcher.class})
public abstract class BlockRenderManagerMixin
implements AlternateBlockRenderer {
    @Final
    @Shadow
    private BlockColors f_110903_;
    @Final
    @Shadow
    private BlockModelShaper f_110899_;
    @Shadow
    @Final
    private BlockEntityWithoutLevelRenderer f_173397_;

    @Shadow
    public abstract BakedModel m_110910_(BlockState var1);

    @Override
    @Unique
    public void renderSingleBlockEmission(BlockState state, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (state.m_60799_() == RenderShape.INVISIBLE) {
            return;
        }
        BlockRenderDispatcher dispatcher = (BlockRenderDispatcher)this;
        BakedModel model = dispatcher.m_110910_(state);
        int tint = this.f_110903_.m_92577_(state, null, null, 0);
        float r = (float)(tint >> 16 & 0xFF) / 255.0f;
        float g = (float)(tint >> 8 & 0xFF) / 255.0f;
        float b = (float)(tint & 0xFF) / 255.0f;
        RandomSource random = RandomSource.m_216335_((long)42L);
        for (Direction dir : Direction.values()) {
            for (BakedQuad quad : model.m_213637_(state, dir, random)) {
                this.renderQuad(quad, poseStack, buffer, r, g, b, packedLight, state);
            }
        }
        for (BakedQuad quad : model.m_213637_(state, null, random)) {
            this.renderQuad(quad, poseStack, buffer, r, g, b, packedLight, state);
        }
    }

    private void renderQuad(BakedQuad quad, PoseStack poseStack, MultiBufferSource buffer, float r, float g, float b, int light, BlockState state) {
        if (quad.m_111304_()) {
            r = Math.max(0.0f, Math.min(1.0f, r));
            g = Math.max(0.0f, Math.min(1.0f, g));
            b = Math.max(0.0f, Math.min(1.0f, b));
        } else {
            b = 1.0f;
            g = 1.0f;
            r = 1.0f;
        }
        RenderType renderType = quad.m_111307_() ? ItemBlockRenderTypes.m_109284_((BlockState)state, (boolean)false) : ItemBlockRenderTypes.m_109284_((BlockState)state, (boolean)true);
        VertexConsumer consumer = buffer.m_6299_(renderType);
        consumer.m_85987_(poseStack.m_85850_(), quad, r, g, b, light, OverlayTexture.f_118083_);
    }
}

