/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.handler;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.DigSpeedEvent;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.LivingHealEvent;
import net.blay09.mods.balm.api.event.PlayerAttackEvent;
import net.blay09.mods.balm.api.event.UseBlockEvent;
import net.blay09.mods.balm.api.event.UseItemEvent;
import net.blay09.mods.hardcorerevival.HardcoreRevival;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.tag.ModBlockTags;
import net.blay09.mods.hardcorerevival.tag.ModItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class KnockoutRestrictionHandler {
    public static void initialize() {
        Balm.getEvents().onEvent(UseBlockEvent.class, KnockoutRestrictionHandler::onUseBlock, EventPriority.Highest);
        Balm.getEvents().onEvent(UseItemEvent.class, KnockoutRestrictionHandler::onUseItem, EventPriority.Highest);
        Balm.getEvents().onEvent(PlayerAttackEvent.class, KnockoutRestrictionHandler::onAttack, EventPriority.Highest);
        Balm.getEvents().onEvent(DigSpeedEvent.class, KnockoutRestrictionHandler::onDigSpeed, EventPriority.Highest);
        Balm.getEvents().onEvent(LivingHealEvent.class, KnockoutRestrictionHandler::onHeal);
    }

    public static void onHeal(LivingHealEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && HardcoreRevival.getRevivalData((Entity)(player = (Player)livingEntity)).isKnockedOut()) {
            event.setCanceled(false);
        }
    }

    public static void onDigSpeed(DigSpeedEvent event) {
        Player player = event.getPlayer();
        if (player != null && HardcoreRevival.getRevivalData((Entity)player).isKnockedOut() && !KnockoutRestrictionHandler.mayBreakBlockKnockedOut(event.getState())) {
            event.setSpeedOverride(Float.valueOf(0.0f));
            event.setCanceled(true);
        }
    }

    public static void onUseBlock(UseBlockEvent event) {
        Player player = event.getPlayer();
        if (HardcoreRevival.getRevivalData((Entity)player).isKnockedOut()) {
            ItemStack itemStack = player.m_21120_(event.getHand());
            Level level = event.getLevel();
            BlockPos pos = event.getHitResult().m_82425_();
            if (!KnockoutRestrictionHandler.mayUseItemKnockedOut(itemStack) && !KnockoutRestrictionHandler.mayUseBlockKnockedOut(level, pos, itemStack)) {
                event.setCanceled(true);
            }
        }
    }

    public static void onUseItem(UseItemEvent event) {
        ItemStack itemStack;
        Player player = event.getPlayer();
        if (HardcoreRevival.getRevivalData((Entity)player).isKnockedOut() && !KnockoutRestrictionHandler.mayUseItemKnockedOut(itemStack = player.m_21120_(event.getHand()))) {
            event.setCanceled(true);
        }
    }

    public static void onAttack(PlayerAttackEvent event) {
        Player player = event.getPlayer();
        if (player != null && HardcoreRevival.getRevivalData((Entity)player).isKnockedOut()) {
            ItemStack itemStack = player.m_21205_();
            if (HardcoreRevivalConfig.getActive().allowUnarmedMelee && itemStack.m_41619_()) {
                return;
            }
            if (!KnockoutRestrictionHandler.mayAttackWithItemKnockedOut(itemStack)) {
                event.setCanceled(true);
            }
        }
    }

    private static boolean mayUseItemKnockedOut(ItemStack itemStack) {
        if (HardcoreRevivalConfig.getActive().allowBows && itemStack.m_41720_() instanceof BowItem) {
            return true;
        }
        return itemStack.m_204117_(ModItemTags.ALLOW_USE_WHILE_KNOCKED_OUT);
    }

    public static boolean mayTossItemKnockedOut(ItemStack itemStack) {
        return itemStack.m_204117_(ModItemTags.ALLOW_TOSS_WHILE_KNOCKED_OUT);
    }

    private static boolean mayAttackWithItemKnockedOut(ItemStack itemStack) {
        return itemStack.m_204117_(ModItemTags.ALLOW_ATTACK_WHILE_KNOCKED_OUT);
    }

    private static boolean mayUseBlockKnockedOut(Level level, BlockPos pos, ItemStack itemStack) {
        if (!itemStack.m_41619_()) {
            return false;
        }
        return level.m_8055_(pos).m_204336_(ModBlockTags.ALLOW_USE_WHILE_KNOCKED_OUT);
    }

    private static boolean mayBreakBlockKnockedOut(BlockState state) {
        return state.m_204336_(ModBlockTags.ALLOW_BREAK_WHILE_KNOCKED_OUT);
    }
}

