/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.balm.api.event.client.FovUpdateEvent;
import net.blay09.mods.balm.api.event.client.GuiDrawEvent;
import net.blay09.mods.balm.api.event.client.OpenScreenEvent;
import net.blay09.mods.hardcorerevival.HardcoreRevival;
import net.blay09.mods.hardcorerevival.capability.HardcoreRevivalData;
import net.blay09.mods.hardcorerevival.client.GuiHelper;
import net.blay09.mods.hardcorerevival.client.KnockoutScreen;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.network.RescueMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;

public class HardcoreRevivalClient {
    private static boolean wasKnockedOut;
    private static boolean isRescuing;
    private static int targetEntity;
    private static float targetProgress;
    private static boolean beingRescued;

    public static void initialize() {
        Balm.getEvents().onEvent(OpenScreenEvent.class, HardcoreRevivalClient::onOpenScreen);
        Balm.getEvents().onEvent(FovUpdateEvent.class, HardcoreRevivalClient::onFovUpdate);
        Balm.getEvents().onEvent(GuiDrawEvent.Pre.class, HardcoreRevivalClient::onGuiDrawPre);
        Balm.getEvents().onEvent(GuiDrawEvent.Post.class, HardcoreRevivalClient::onGuiDrawPost);
        Balm.getEvents().onTickEvent(TickType.Client, TickPhase.Start, HardcoreRevivalClient::onClientTick);
    }

    private static boolean isKnockedOut() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return HardcoreRevival.getClientRevivalData().isKnockedOut() && player != null && player.m_6084_();
    }

    public static void onOpenScreen(OpenScreenEvent event) {
        if (HardcoreRevivalClient.isKnockedOut() && event.getScreen() instanceof InventoryScreen) {
            event.setScreen((Screen)new KnockoutScreen());
        }
    }

    public static void onFovUpdate(FovUpdateEvent event) {
        if (HardcoreRevivalClient.isKnockedOut()) {
            event.setFov(Float.valueOf((float)Mth.m_14139_((double)((Double)Minecraft.m_91087_().f_91066_.m_231925_().m_231551_()), (double)1.0, (double)0.5)));
        }
    }

    public static void onGuiDrawPre(GuiDrawEvent.Pre event) {
        if (event.getElement() == GuiDrawEvent.Element.HEALTH && HardcoreRevivalClient.isKnockedOut()) {
            int knockoutTicksPassed = HardcoreRevival.getClientRevivalData().getKnockoutTicksPassed();
            float redness = (float)Math.sin((float)knockoutTicksPassed / 2.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)(1.0f - redness), (float)(1.0f - redness), (float)1.0f);
        }
    }

    public static void onGuiDrawPost(GuiDrawEvent.Post event) {
        GuiGraphics guiGraphics = event.getGuiGraphics();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (event.getElement() == GuiDrawEvent.Element.ALL) {
            Minecraft mc = Minecraft.m_91087_();
            if (HardcoreRevivalClient.isKnockedOut()) {
                PoseStack poseStack = guiGraphics.m_280168_();
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f, 0.0f, -300.0f);
                GuiHelper.drawGradientRectW(guiGraphics, 0, 0, mc.m_91268_().m_85441_(), mc.m_91268_().m_85442_(), 0x60500000, -1862336512);
                poseStack.m_85849_();
                if (mc.f_91080_ == null || mc.f_91080_ instanceof ChatScreen) {
                    int width = event.getWindow().m_85445_();
                    int height = event.getWindow().m_85446_();
                    GuiHelper.renderKnockedOutTitle(guiGraphics, width);
                    GuiHelper.renderDeathTimer(guiGraphics, width, height, beingRescued);
                    if (HardcoreRevivalConfig.getActive().allowAcceptingFate) {
                        Component openDeathScreenKey = mc.f_91066_.f_92092_.m_90863_();
                        MutableComponent openDeathScreenText = Component.m_237110_((String)"gui.hardcorerevival.open_death_screen", (Object[])new Object[]{openDeathScreenKey});
                        guiGraphics.m_280653_(mc.f_91062_, (Component)openDeathScreenText, width / 2, height / 2 + 25, -1);
                    }
                }
            } else {
                Entity pointedEntity;
                Entity entity;
                if (targetEntity != -1 && targetProgress > 0.0f && (entity = mc.f_91073_.m_6815_(targetEntity)) instanceof Player) {
                    MutableComponent textComponent = Component.m_237110_((String)"gui.hardcorerevival.rescuing", (Object[])new Object[]{entity.m_5446_()});
                    if (targetProgress >= 0.75f) {
                        textComponent.m_130946_(" ...");
                    } else if (targetProgress >= 0.5f) {
                        textComponent.m_130946_(" ..");
                    } else if (targetProgress >= 0.25f) {
                        textComponent.m_130946_(" .");
                    }
                    guiGraphics.m_280614_(mc.f_91062_, (Component)textComponent, mc.m_91268_().m_85445_() / 2 - mc.f_91062_.m_92852_((FormattedText)textComponent) / 2, mc.m_91268_().m_85446_() / 2 + 30, -1, true);
                }
                if (!HardcoreRevival.getClientRevivalData().isKnockedOut() && mc.f_91074_ != null && !mc.f_91074_.m_5833_() && mc.f_91074_.m_6084_() && !isRescuing && (pointedEntity = Minecraft.m_91087_().f_91076_) != null && HardcoreRevival.getRevivalData(pointedEntity).isKnockedOut() && (double)mc.f_91074_.m_20270_(pointedEntity) <= HardcoreRevivalConfig.getActive().rescueDistance) {
                    Component rescueKeyText = mc.f_91066_.f_92095_.m_90863_();
                    MutableComponent textComponent = Component.m_237110_((String)"gui.hardcorerevival.hold_to_rescue", (Object[])new Object[]{rescueKeyText});
                    guiGraphics.m_280614_(mc.f_91062_, (Component)textComponent, mc.m_91268_().m_85445_() / 2 - mc.f_91062_.m_92852_((FormattedText)textComponent) / 2, mc.m_91268_().m_85446_() / 2 + 30, -1, true);
                }
            }
            RenderSystem.enableBlend();
        }
    }

    public static void onClientTick(Minecraft client) {
        if (client.f_91074_ != null) {
            if (HardcoreRevivalClient.isKnockedOut()) {
                if (!wasKnockedOut) {
                    Balm.getHooks().setForcedPose((Player)client.f_91074_, Pose.FALL_FLYING);
                    client.m_91152_((Screen)new KnockoutScreen());
                    wasKnockedOut = true;
                }
                HardcoreRevivalData revivalData = HardcoreRevival.getRevivalData((Entity)client.f_91074_);
                revivalData.setKnockoutTicksPassed(revivalData.getKnockoutTicksPassed() + 1);
            } else {
                if (wasKnockedOut) {
                    Balm.getHooks().setForcedPose((Player)client.f_91074_, null);
                    wasKnockedOut = false;
                }
                if (client.f_91080_ instanceof KnockoutScreen) {
                    client.m_91152_(null);
                }
                if (client.f_91066_.f_92095_.m_90857_() && !client.f_91074_.m_5833_() && client.f_91074_.m_6084_() && !HardcoreRevival.getClientRevivalData().isKnockedOut()) {
                    if (!isRescuing) {
                        Balm.getNetworking().sendToServer((Object)new RescueMessage(true));
                        isRescuing = true;
                    }
                } else if (isRescuing) {
                    Balm.getNetworking().sendToServer((Object)new RescueMessage(false));
                    isRescuing = false;
                }
            }
        }
    }

    public static void setRevivalProgress(int entityId, float progress) {
        if (progress < 0.0f) {
            targetEntity = -1;
            targetProgress = 0.0f;
            Balm.getHooks().setForcedPose((Player)Minecraft.m_91087_().f_91074_, null);
        } else {
            targetEntity = entityId;
            targetProgress = progress;
            Balm.getHooks().setForcedPose((Player)Minecraft.m_91087_().f_91074_, Pose.CROUCHING);
        }
    }

    public static void setBeingRescued(boolean beingRescued) {
        HardcoreRevivalClient.beingRescued = beingRescued;
    }

    public static boolean isBeingRescued() {
        return beingRescued;
    }

    static {
        targetEntity = -1;
    }
}

