/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.events;

import com.gametechbc.spelllib.init.GSLAttributeRegistry;
import io.redspace.ironsspellbooks.api.events.SpellDamageEvent;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="gtbcs_spell_lib", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeServerEvents {
    @SubscribeEvent
    public static void onSpellDamage(SpellDamageEvent event) {
        Entity entity = event.getSpellDamageSource().m_7639_();
        if (entity instanceof LivingEntity) {
            double critRoll;
            double critChance;
            LivingEntity caster = (LivingEntity)entity;
            double damageMultiplier = caster.m_21133_((Attribute)GSLAttributeRegistry.SPELL_DAMAGE.get());
            float originalDamage = event.getAmount();
            float modifiedDamage = (float)((double)originalDamage * damageMultiplier);
            if (event.getSpellDamageSource().m_7640_() instanceof AbstractMagicProjectile) {
                double projectileDamage = caster.m_21133_((Attribute)GSLAttributeRegistry.MAGIC_PROJECTILE_DAMAGE.get());
                modifiedDamage = (float)((double)modifiedDamage * projectileDamage);
            }
            if ((critChance = caster.m_21133_((Attribute)GSLAttributeRegistry.SPELL_CRIT_CHANCE.get())) > 0.0 && (critRoll = caster.m_217043_().m_188500_()) < critChance) {
                double critDamage = caster.m_21133_((Attribute)GSLAttributeRegistry.SPELL_CRIT_DAMAGE.get());
                float finalDamage = (float)((double)modifiedDamage * critDamage);
                event.setAmount(finalDamage);
                if (caster instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)caster;
                    ForgeServerEvents.displayCriticalHit(player, finalDamage, critDamage);
                }
                return;
            }
            event.setAmount(modifiedDamage);
        }
    }

    private static void displayCriticalHit(ServerPlayer player, float baseDamage, double critDamage) {
    }
}

