/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.events;

import com.gametechbc.spelllib.entity.misc.GSLFollowingScreenShakeEntity;
import com.gametechbc.spelllib.entity.misc.GSLPowerInversionEntity;
import com.gametechbc.spelllib.entity.misc.GSLScreenFlashEntity;
import com.gametechbc.spelllib.entity.misc.GSLScreenShakeEntity;
import com.gametechbc.spelllib.render.overlay.ScreenEffectOverlayHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="gtbcs_spell_lib", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ForgeClientEvents {
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && !Minecraft.m_91087_().m_91104_()) {
            float delta = Minecraft.m_91087_().m_91296_();
            float ticksExistedDelta = (float)player.f_19797_ + delta;
            float shakeAmplitude = 0.0f;
            for (Entity screenShake : player.m_9236_().m_45976_(GSLScreenShakeEntity.class, player.m_20191_().m_82377_(50.0, 50.0, 50.0))) {
                if (!(screenShake.m_20270_((Entity)player) <= screenShake.getRadius())) continue;
                shakeAmplitude += screenShake.getShakeAmount((Player)player, delta);
            }
            for (Entity screenShake : player.m_9236_().m_45976_(GSLFollowingScreenShakeEntity.class, player.m_20191_().m_82377_(50.0, 50.0, 50.0))) {
                if (!(screenShake.m_20270_((Entity)player) <= screenShake.getRadius())) continue;
                shakeAmplitude += screenShake.getShakeAmount((Player)player, delta);
            }
            if (shakeAmplitude > 1.0f) {
                shakeAmplitude = 1.0f;
            }
            if (shakeAmplitude > 0.0f) {
                event.setPitch((float)((double)event.getPitch() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 3.0f + 2.0f) * 25.0));
                event.setYaw((float)((double)event.getYaw() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 5.0f + 1.0f) * 25.0));
                event.setRoll((float)((double)event.getRoll() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 4.0f) * 25.0));
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        LocalPlayer player;
        if (event.getOverlay() == VanillaGuiOverlay.CROSSHAIR.type() && (player = Minecraft.m_91087_().f_91074_) != null && !Minecraft.m_91087_().m_91104_()) {
            float delta = Minecraft.m_91087_().m_91296_();
            GuiGraphics guiGraphics = event.getGuiGraphics();
            ForgeClientEvents.processScreenFlashEffects((Player)player, delta, guiGraphics);
            ForgeClientEvents.processPowerInversionEffects((Player)player, delta, guiGraphics);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void processScreenFlashEffects(Player player, float delta, GuiGraphics guiGraphics) {
        float totalFlashAlpha = 0.0f;
        int flashColor = 0xFFFFFF;
        for (GSLScreenFlashEntity flash : player.m_9236_().m_45976_(GSLScreenFlashEntity.class, player.m_20191_().m_82377_(50.0, 50.0, 50.0))) {
            float alpha;
            if (!(flash.m_20270_((Entity)player) <= flash.getRadius()) || !((alpha = flash.getFlashAlpha(player, delta)) > totalFlashAlpha)) continue;
            totalFlashAlpha = alpha;
            flashColor = flash.getFlashColor();
        }
        if (totalFlashAlpha > 1.0f) {
            totalFlashAlpha = 1.0f;
        }
        if (totalFlashAlpha > 0.0f) {
            ScreenEffectOverlayHelper.renderFlashOverlay(guiGraphics, totalFlashAlpha, flashColor);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void processPowerInversionEffects(Player player, float delta, GuiGraphics guiGraphics) {
        GSLPowerInversionEntity.PowerEffectData combinedEffect = new GSLPowerInversionEntity.PowerEffectData(0.0f, 0.0f, GSLPowerInversionEntity.EffectPhase.NONE);
        boolean shouldInvert = false;
        int flashColor = 0xF8F8F8;
        for (GSLPowerInversionEntity powerEffect : player.m_9236_().m_45976_(GSLPowerInversionEntity.class, player.m_20191_().m_82377_(50.0, 50.0, 50.0))) {
            if (!(powerEffect.m_20270_((Entity)player) <= powerEffect.getRadius())) continue;
            GSLPowerInversionEntity.PowerEffectData effectData = powerEffect.getEffectData(player, delta);
            if (effectData.phase == GSLPowerInversionEntity.EffectPhase.NONE || !(effectData.flashIntensity > combinedEffect.flashIntensity) && !(effectData.effectIntensity > combinedEffect.effectIntensity)) continue;
            combinedEffect = effectData;
            shouldInvert = powerEffect.shouldInvertColors();
            flashColor = powerEffect.getFlashColor();
        }
        if (combinedEffect.phase != GSLPowerInversionEntity.EffectPhase.NONE) {
            ScreenEffectOverlayHelper.renderPowerInversionOverlay(guiGraphics, combinedEffect, shouldInvert, flashColor);
        }
    }
}

