/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.network;

import com.gametechbc.gtbcs_geomancy_plus.util.GGClientCastHelper;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundEarthExplosionParticles {
    private final Vec3 pos;
    private final float radius;

    public ClientboundEarthExplosionParticles(Vec3 pos, float radius) {
        this.pos = pos;
        this.radius = radius;
    }

    public ClientboundEarthExplosionParticles(FriendlyByteBuf buf) {
        this.pos = this.readVec3(buf);
        this.radius = buf.readFloat();
    }

    public void toBytes(FriendlyByteBuf buf) {
        this.writeVec3(this.pos, buf);
        buf.writeFloat(this.radius);
    }

    public Vec3 readVec3(FriendlyByteBuf buf) {
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        return new Vec3(x, y, z);
    }

    public void writeVec3(Vec3 vec3, FriendlyByteBuf buf) {
        buf.writeDouble(vec3.f_82479_);
        buf.writeDouble(vec3.f_82480_);
        buf.writeDouble(vec3.f_82481_);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> GGClientCastHelper.handleClientboundEarthExplosion(this.pos, this.radius));
        return true;
    }
}

