/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.tremor_spike;

import com.gametechbc.gtbcs_geomancy_plus.init.GGEntities;
import com.gametechbc.gtbcs_geomancy_plus.init.GGSpells;
import com.gametechbc.gtbcs_geomancy_plus.util.GGTags;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.damage.DamageSources;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TremorSpikeEntity
extends Entity
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> ACTIVATE = SynchedEntityData.m_135353_(TremorSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(TremorSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> WARMUP_TICKS = SynchedEntityData.m_135353_(TremorSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_RISING = SynchedEntityData.m_135353_(TremorSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_GOING_DOWN = SynchedEntityData.m_135353_(TremorSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT_TYPE = SynchedEntityData.m_135353_(TremorSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int warmupDelayTicks;
    private LivingEntity caster;
    private UUID casterUuid;
    private boolean hasDamaged = false;
    private int riseTickCount = 0;
    private boolean hasDetectedBlock = false;
    public static final int VARIANT_DIRT = 0;
    public static final int VARIANT_GRASS = 1;
    public static final int VARIANT_COBBLESTONE = 2;
    public static final int VARIANT_DEEPSLATE = 3;
    private static final RawAnimation BLANK_ANIM = RawAnimation.begin().thenLoop("blank");
    private static final RawAnimation SPIKE_RISE_ANIM = RawAnimation.begin().thenPlay("spike_rise");
    private final AnimationController<TremorSpikeEntity> controller = new AnimationController((GeoAnimatable)this, "spike_controller", 0, this::animationPredicate);

    public TremorSpikeEntity(EntityType<? extends TremorSpikeEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public TremorSpikeEntity(Level worldIn, double x, double y, double z, float yRot, int warmupDelay, float damage, LivingEntity casterIn) {
        this((EntityType<? extends TremorSpikeEntity>)((EntityType)GGEntities.TREMOR_SPIKE.get()), worldIn);
        this.warmupDelayTicks = warmupDelay;
        this.setCaster(casterIn);
        this.setDamage(damage);
        this.setWarmupTicks(warmupDelay);
        this.m_146922_(yRot);
        this.m_6034_(x, y, z);
        this.detectBlockBeneath();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ACTIVATE, (Object)false);
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(WARMUP_TICKS, (Object)0);
        this.f_19804_.m_135372_(IS_RISING, (Object)false);
        this.f_19804_.m_135372_(IS_GOING_DOWN, (Object)false);
        this.f_19804_.m_135372_(VARIANT_TYPE, (Object)0);
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("Warmup", this.warmupDelayTicks);
        if (this.casterUuid != null) {
            tag.m_128362_("Owner", this.casterUuid);
        }
        tag.m_128350_("damage", this.getDamage());
        tag.m_128405_("variantType", this.getVariantType());
        tag.m_128379_("hasDetectedBlock", this.hasDetectedBlock);
    }

    protected void m_7378_(CompoundTag tag) {
        this.warmupDelayTicks = tag.m_128451_("Warmup");
        if (tag.m_128403_("Owner")) {
            this.casterUuid = tag.m_128342_("Owner");
        }
        this.setDamage(tag.m_128457_("damage"));
        if (tag.m_128441_("variantType")) {
            this.setVariantType(tag.m_128451_("variantType"));
        }
        this.hasDetectedBlock = tag.m_128471_("hasDetectedBlock");
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public int getWarmupTicks() {
        return (Integer)this.f_19804_.m_135370_(WARMUP_TICKS);
    }

    public void setWarmupTicks(int ticks) {
        this.f_19804_.m_135381_(WARMUP_TICKS, (Object)ticks);
    }

    public void setCaster(@Nullable LivingEntity caster) {
        this.caster = caster;
        this.casterUuid = caster == null ? null : caster.m_20148_();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    public boolean isActivate() {
        return (Boolean)this.f_19804_.m_135370_(ACTIVATE);
    }

    public void setActivate(boolean activate) {
        this.f_19804_.m_135381_(ACTIVATE, (Object)activate);
    }

    public boolean isRising() {
        return (Boolean)this.f_19804_.m_135370_(IS_RISING);
    }

    public void setRising(boolean rising) {
        this.f_19804_.m_135381_(IS_RISING, (Object)rising);
    }

    public boolean isGoingDown() {
        return (Boolean)this.f_19804_.m_135370_(IS_GOING_DOWN);
    }

    public void setGoingDown(boolean goingDown) {
        this.f_19804_.m_135381_(IS_GOING_DOWN, (Object)goingDown);
    }

    public int getVariantType() {
        return (Integer)this.f_19804_.m_135370_(VARIANT_TYPE);
    }

    public void setVariantType(int variantType) {
        this.f_19804_.m_135381_(VARIANT_TYPE, (Object)variantType);
    }

    public boolean isDirtVariant() {
        return this.getVariantType() == 0;
    }

    public boolean isGrassVariant() {
        return this.getVariantType() == 1;
    }

    public boolean isCobblestoneVariant() {
        return this.getVariantType() == 2;
    }

    public boolean isDeepslateVariant() {
        return this.getVariantType() == 3;
    }

    private void detectBlockBeneath() {
        BlockPos posBelow = this.m_20183_().m_7495_();
        BlockState blockBelow = this.m_9236_().m_8055_(posBelow);
        int variantType = blockBelow.m_60713_(Blocks.f_50440_) ? 1 : (blockBelow.m_204336_(GGTags.IS_COBBLESTONE_CATEGORY) ? 2 : (blockBelow.m_204336_(GGTags.IS_DEEPSLATE_CATEGORY) ? 3 : 0));
        this.setVariantType(variantType);
        this.hasDetectedBlock = true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ == 1 && !this.hasDetectedBlock && !this.m_9236_().f_46443_) {
            this.detectBlockBeneath();
        }
        if (this.m_9236_().f_46443_) {
            if (this.isRising()) {
                this.spawnBlockDiggingParticles();
            }
            if (this.isGoingDown()) {
                this.spawnGoingDownParticles();
            }
        } else {
            int currentWarmup = this.getWarmupTicks();
            if (currentWarmup > 0) {
                this.setWarmupTicks(currentWarmup - 1);
            } else if (!this.isActivate()) {
                this.setActivate(true);
                this.setRising(true);
            }
            if (this.isActivate()) {
                ++this.riseTickCount;
                if (this.riseTickCount == 7) {
                    this.setRising(false);
                    if (!this.hasDamaged) {
                        this.dealDamageOnce();
                        this.hasDamaged = true;
                    }
                    this.setGoingDown(true);
                }
                if (this.riseTickCount >= 20) {
                    this.m_146870_();
                }
            }
        }
    }

    private void dealDamageOnce() {
        for (LivingEntity livingentity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(0.2, 0.0, 0.2))) {
            this.damage(livingentity);
        }
    }

    private void damage(LivingEntity hitEntity) {
        LivingEntity livingentity = this.getCaster();
        if (hitEntity.m_6084_() && !hitEntity.m_20147_() && hitEntity != livingentity) {
            if (livingentity == null) {
                hitEntity.m_6469_(this.m_269291_().m_269425_(), this.getDamage());
            } else if (!livingentity.m_7307_((Entity)hitEntity) && !hitEntity.m_7307_((Entity)livingentity)) {
                DamageSources.applyDamage((Entity)hitEntity, (float)this.getDamage(), (DamageSource)((AbstractSpell)GGSpells.TREMOR_SPIKE_SPELL.get()).getDamageSource((Entity)this, (Entity)this.getCaster()));
            }
        }
    }

    private void spawnBlockDiggingParticles() {
        for (int i = 0; i < 3; ++i) {
            BlockState block = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
            double d1 = this.m_20186_() + 0.03;
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
            double d3 = this.f_19796_.m_188583_() * 0.07;
            double d4 = this.f_19796_.m_188583_() * 0.07;
            double d5 = this.f_19796_.m_188583_() * 0.07;
            if (block.m_60799_() == RenderShape.INVISIBLE) continue;
            this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), d0, d1, d2, d3, d4, d5);
        }
    }

    private void spawnGoingDownParticles() {
        for (int i = 0; i < 1; ++i) {
            BlockState spikeBlock = this.getBlockForVariant();
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.6;
            double d1 = this.m_20186_() + 0.5 + this.f_19796_.m_188500_() * 0.8;
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.6;
            double d3 = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.15;
            double d4 = -0.1 - this.f_19796_.m_188500_() * 0.2;
            double d5 = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.15;
            if (spikeBlock.m_60799_() == RenderShape.INVISIBLE) continue;
            this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, spikeBlock), d0, d1, d2, d3, d4, d5);
        }
    }

    private BlockState getBlockForVariant() {
        return switch (this.getVariantType()) {
            case 1 -> Blocks.f_50440_.m_49966_();
            case 2 -> Blocks.f_50652_.m_49966_();
            case 3 -> Blocks.f_152550_.m_49966_();
            default -> Blocks.f_50493_.m_49966_();
        };
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{this.controller});
    }

    private PlayState animationPredicate(AnimationState<TremorSpikeEntity> state) {
        if (this.isActivate()) {
            state.getController().setAnimation(SPIKE_RISE_ANIM);
        } else {
            state.getController().setAnimation(BLANK_ANIM);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

