/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.resonator;

import com.gametechbc.gtbcs_geomancy_plus.util.GGParticleHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ResonatorParticleManager {
    public static void spawnAegisRadiusRing(Level level, Vec3 centerPos, float radius, int age) {
        if (level.f_46443_) {
            int segments = 6;
            for (int seg = 0; seg < segments; ++seg) {
                double pulsePhase = ((double)age * 2.0 + (double)(seg * 20)) % 60.0;
                if (!(pulsePhase < 20.0)) continue;
                double segmentAngle = (double)seg * 60.0 + pulsePhase * 2.0;
                double angleRad = Math.toRadians(segmentAngle);
                for (int p = 0; p < 4; ++p) {
                    double particleAngle = angleRad + Math.toRadians(((double)p - 1.5) * 5.0);
                    double currentRadius = (double)radius + Math.sin(pulsePhase * 0.3) * 0.2;
                    double offsetX = Math.cos(particleAngle) * currentRadius;
                    double offsetZ = Math.sin(particleAngle) * currentRadius;
                    double particleX = centerPos.f_82479_ + offsetX;
                    double particleY = centerPos.f_82480_ + 0.15;
                    double particleZ = centerPos.f_82481_ + offsetZ;
                    double velocityX = Math.cos(particleAngle) * 0.01;
                    double velocityY = 0.04;
                    double velocityZ = Math.sin(particleAngle) * 0.01;
                    level.m_7106_(GGParticleHelper.PILLAR_GREEN_PASSIVE_ENCHANT, particleX, particleY, particleZ, velocityX, velocityY, velocityZ);
                }
            }
        }
    }

    public static void spawnHitEffect(Level level, Vec3 centerPos, float radius, int timeLeft) {
        if (level.f_46443_) {
            float progress = (float)(10 - timeLeft) / 10.0f;
            int ringCount = 4;
            for (int ring = 0; ring < ringCount; ++ring) {
                float ringDelay = (float)ring * 0.2f;
                float ringProgress = Math.max(0.0f, progress - ringDelay) / (1.0f - ringDelay);
                if (!(ringProgress > 0.0f) || !(ringProgress <= 1.0f)) continue;
                double ringRadius = radius * ringProgress;
                int particlesInRing = Math.max(6, (int)(12.0f * ringProgress));
                for (int i = 0; i < particlesInRing; ++i) {
                    double angle = (double)i / (double)particlesInRing * 2.0 * Math.PI;
                    double offsetX = Math.cos(angle) * ringRadius;
                    double offsetZ = Math.sin(angle) * ringRadius;
                    double particleX = centerPos.f_82479_ + offsetX;
                    double particleY = centerPos.f_82480_ + 0.1 + (double)ringProgress * 0.5;
                    double particleZ = centerPos.f_82481_ + offsetZ;
                    double velocityX = Math.cos(angle) * 0.01;
                    double velocityY = 0.04 + (double)ringProgress * 0.02;
                    double velocityZ = Math.sin(angle) * 0.01;
                    level.m_7106_(GGParticleHelper.PILLAR_GREEN_PASSIVE_ENCHANT, particleX, particleY, particleZ, velocityX, velocityY, velocityZ);
                }
            }
        }
    }
}

