/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.resonator;

import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.gametechbc.gtbcs_geomancy_plus.api.entity.IResonanceEntity;
import com.gametechbc.gtbcs_geomancy_plus.api.util.GGGeneralUtil;
import com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.resonate_pillar.ResonatePillarEntity;
import com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.resonator.ResonatorParticleManager;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEffects;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEntities;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ResonatorEntity
extends Entity
implements GeoEntity,
AntiMagicSusceptible,
IResonanceEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> DATA_AGE = SynchedEntityData.m_135353_(ResonatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_MAX_AGE = SynchedEntityData.m_135353_(ResonatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_SHOCKWAVE_RADIUS = SynchedEntityData.m_135353_(ResonatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_EMISSIVE_BRIGHTNESS = SynchedEntityData.m_135353_(ResonatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_HIT_EFFECT_TIMER = SynchedEntityData.m_135353_(ResonatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private UUID summonerUUID;
    private LivingEntity cachedSummoner;
    private int maxAegisAmplifier = 3;
    private int erodeEffectAmplifier = 1;
    private final RawAnimation IDLE_BLANK_ANIMATION = RawAnimation.begin().thenLoop("idle_blank");
    private final RawAnimation PILLAR_RISE_ANIMATION = RawAnimation.begin().thenPlay("pillar_rise");
    private final RawAnimation PILLAR_DIE_ANIMATION = RawAnimation.begin().thenPlay("pillar_die");
    private final AnimationController<ResonatorEntity> controller = new AnimationController((GeoAnimatable)this, "pillar_controller", 0, this::animationPredicate);

    public ResonatorEntity(EntityType<? extends Entity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ResonatorEntity(Level level, LivingEntity summoner) {
        this((EntityType<? extends Entity>)((EntityType)GGEntities.RESONATOR.get()), level);
        this.setSummoner(summoner);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_AGE, (Object)0);
        this.f_19804_.m_135372_(DATA_MAX_AGE, (Object)600);
        this.f_19804_.m_135372_(DATA_SHOCKWAVE_RADIUS, (Object)Float.valueOf(6.0f));
        this.f_19804_.m_135372_(DATA_EMISSIVE_BRIGHTNESS, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_HIT_EFFECT_TIMER, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        tag.m_128405_("Age", this.getAge());
        tag.m_128405_("MaxAge", this.getMaxAge());
        tag.m_128350_("ShockwaveRadius", this.getEffectRadius());
        tag.m_128350_("EmissiveBrightness", this.getEmissiveBrightness());
        tag.m_128405_("MaxAegisAmplifier", this.maxAegisAmplifier);
        tag.m_128405_("HitEffectTimer", this.getHitEffectTimer());
        tag.m_128405_("ErodeEffectAmplifier", this.erodeEffectAmplifier);
        if (this.summonerUUID != null) {
            tag.m_128362_("Summoner", this.summonerUUID);
        }
    }

    public void m_7378_(CompoundTag tag) {
        if (tag.m_128441_("Age")) {
            this.setAge(tag.m_128451_("Age"));
        }
        if (tag.m_128441_("MaxAge")) {
            this.setMaxAge(tag.m_128451_("MaxAge"));
        }
        if (tag.m_128441_("ShockwaveRadius")) {
            this.setEffectRadius(tag.m_128457_("ShockwaveRadius"));
        }
        if (tag.m_128441_("EmissiveBrightness")) {
            this.setEmissiveBrightness(tag.m_128457_("EmissiveBrightness"));
        }
        if (tag.m_128441_("MaxAegisAmplifier")) {
            this.maxAegisAmplifier = tag.m_128451_("MaxAegisAmplifier");
        }
        if (tag.m_128441_("HitEffectTimer")) {
            this.setHitEffectTimer(tag.m_128451_("HitEffectTimer"));
        }
        if (tag.m_128441_("ErodeEffectAmplifier")) {
            this.erodeEffectAmplifier = tag.m_128451_("ErodeEffectAmplifier");
        }
        if (tag.m_128403_("Summoner")) {
            this.summonerUUID = tag.m_128342_("Summoner");
        }
    }

    public int getAge() {
        return (Integer)this.f_19804_.m_135370_(DATA_AGE);
    }

    public void setAge(int age) {
        this.f_19804_.m_135381_(DATA_AGE, (Object)age);
    }

    public int getMaxAge() {
        return (Integer)this.f_19804_.m_135370_(DATA_MAX_AGE);
    }

    public void setMaxAge(int maxAge) {
        this.f_19804_.m_135381_(DATA_MAX_AGE, (Object)maxAge);
    }

    public float getEffectRadius() {
        return ((Float)this.f_19804_.m_135370_(DATA_SHOCKWAVE_RADIUS)).floatValue();
    }

    public void setEffectRadius(float radius) {
        this.f_19804_.m_135381_(DATA_SHOCKWAVE_RADIUS, (Object)Float.valueOf(radius));
    }

    public int getMaxAegisAmplifier() {
        return this.maxAegisAmplifier;
    }

    public void setMaxAegisAmplifier(int maxAmplifier) {
        this.maxAegisAmplifier = Math.max(0, Math.min(maxAmplifier, 15));
    }

    public int getResonanceErodeEffectAmplifier() {
        return this.erodeEffectAmplifier;
    }

    public void setResonanceErodeEffectAmplifier(int amplifier) {
        this.erodeEffectAmplifier = Math.max(0, amplifier);
    }

    public float getEmissiveBrightness() {
        return ((Float)this.f_19804_.m_135370_(DATA_EMISSIVE_BRIGHTNESS)).floatValue();
    }

    public void setEmissiveBrightness(float brightness) {
        this.f_19804_.m_135381_(DATA_EMISSIVE_BRIGHTNESS, (Object)Float.valueOf(brightness));
    }

    public int getHitEffectTimer() {
        return (Integer)this.f_19804_.m_135370_(DATA_HIT_EFFECT_TIMER);
    }

    public void setHitEffectTimer(int timer) {
        this.f_19804_.m_135381_(DATA_HIT_EFFECT_TIMER, (Object)timer);
    }

    public void triggerHitEffect() {
        this.setHitEffectTimer(10);
    }

    public void setSummoner(@Nullable LivingEntity owner) {
        if (owner != null) {
            this.summonerUUID = owner.m_20148_();
            this.cachedSummoner = owner;
        }
    }

    public LivingEntity getSummoner() {
        if (this.cachedSummoner != null && this.cachedSummoner.m_6084_()) {
            return this.cachedSummoner;
        }
        if (this.summonerUUID != null && this.m_9236_() instanceof ServerLevel) {
            Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(this.summonerUUID);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity;
                this.cachedSummoner = livingEntity = (LivingEntity)entity;
            }
            return this.cachedSummoner;
        }
        return null;
    }

    @Override
    public float getResonanceMultiplier() {
        return 1.15f;
    }

    @Override
    public void onResonanceShockwave(ResonatePillarEntity pillar, ResonatePillarEntity.Stage stage, LivingEntity owner, LivingEntity target, Level world, Vec3 resonancePosition, float resonanceRadius, double distanceFromSource, float baseDamage, float finalDamage) {
        IResonanceEntity.super.onResonanceShockwave(pillar, stage, owner, target, world, resonancePosition, resonanceRadius, distanceFromSource, baseDamage, finalDamage);
    }

    @Override
    public boolean canResonateWith(ResonatePillarEntity pillar) {
        LivingEntity pillarOwner = pillar.getSummoner();
        LivingEntity thisOwner = this.getSummoner();
        return pillarOwner != null && thisOwner != null && pillarOwner.m_20148_().equals(thisOwner.m_20148_());
    }

    @Override
    public Vector3f getResonanceParticleColor() {
        return GGGeneralUtil.hexToVector3f(7719759);
    }

    public void m_8119_() {
        int hitTimer;
        super.m_8119_();
        int currentAge = this.getAge();
        this.setAge(currentAge + 1);
        int age = this.getAge();
        int maxAge = this.getMaxAge();
        this.updateEmissiveBrightness();
        Vec3 currentMotion = this.m_20184_();
        double newY = this.applyArtificialGravity(currentMotion.f_82480_);
        this.m_20334_(currentMotion.f_82479_, newY, currentMotion.f_82481_);
        this.m_6478_(MoverType.SELF, this.m_20184_());
        Vec3 motion = this.m_20184_();
        this.m_20334_(0.0, motion.f_82480_, 0.0);
        if ((age == 1 || age % 60 == 0) && this.m_20096_()) {
            this.alignToBlockCenter();
        }
        if ((hitTimer = this.getHitEffectTimer()) > 0) {
            this.setHitEffectTimer(hitTimer - 1);
            ResonatorParticleManager.spawnHitEffect(this.m_9236_(), this.m_20182_(), this.getEffectRadius(), hitTimer);
        }
        if (this.f_19797_ % 2 == 0) {
            ResonatorParticleManager.spawnAegisRadiusRing(this.m_9236_(), this.m_20182_(), this.getEffectRadius(), this.getAge());
        }
        if (!this.m_9236_().f_46443_ && this.f_19797_ % 40 == 0) {
            this.performAegisShockwave();
        }
        if (age >= maxAge) {
            this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_MEDIUM_2.get(), 3.0f, 1.0f);
            this.m_146870_();
        }
    }

    private double applyArtificialGravity(double currentY) {
        if (this.m_20096_()) {
            return Math.max(currentY * 0.8, -0.05);
        }
        double gravity = -0.1;
        double terminalVelocity = -1.5;
        double newY = currentY + gravity;
        return Math.max(newY, terminalVelocity);
    }

    private void alignToBlockCenter() {
        if (!this.m_20096_()) {
            return;
        }
        Vec3 currentPos = this.m_20182_();
        BlockPos groundBlock = this.m_20183_().m_7495_();
        BlockState groundState = this.m_9236_().m_8055_(groundBlock);
        if (groundState.m_60795_() || !groundState.m_60804_((BlockGetter)this.m_9236_(), groundBlock)) {
            return;
        }
        double centerX = (double)groundBlock.m_123341_() + 0.5;
        double centerZ = (double)groundBlock.m_123343_() + 0.5;
        double currentY = currentPos.f_82480_;
        double distanceFromCenter = Math.sqrt(Math.pow(currentPos.f_82479_ - centerX, 2.0) + Math.pow(currentPos.f_82481_ - centerZ, 2.0));
        if (distanceFromCenter > 0.1) {
            this.m_6021_(centerX, currentY, centerZ);
            Vec3 motion = this.m_20184_();
            this.m_20334_(0.0, motion.f_82480_, 0.0);
        }
    }

    private void performAegisShockwave() {
        LivingEntity summoner = this.getSummoner();
        float radius = this.getEffectRadius();
        AABB aegisArea = new AABB(this.m_20185_() - (double)radius, this.m_20186_() - 2.0, this.m_20189_() - (double)radius, this.m_20185_() + (double)radius, this.m_20186_() + 4.0, this.m_20189_() + (double)radius);
        List<LivingEntity> targets = this.m_9236_().m_45976_(LivingEntity.class, aegisArea).stream().filter(entity -> entity.m_6084_() && entity.m_20270_((Entity)this) <= radius).filter(entity -> {
            if (entity == summoner) {
                return true;
            }
            if (summoner != null) {
                return GGGeneralUtil.isAlly(summoner, entity) || GGGeneralUtil.isTamed(entity);
            }
            return false;
        }).toList();
        for (LivingEntity target : targets) {
            int currentAmplifier = 0;
            if (target.m_21023_((MobEffect)GGEffects.AEGIS_EFFECT.get())) {
                currentAmplifier = target.m_21124_((MobEffect)GGEffects.AEGIS_EFFECT.get()).m_19564_();
            }
            int newAmplifier = Math.min(currentAmplifier + 1, this.getMaxAegisAmplifier());
            target.m_7292_(new MobEffectInstance((MobEffect)GGEffects.AEGIS_EFFECT.get(), 100, newAmplifier, false, false, true));
        }
        if (!targets.isEmpty()) {
            this.triggerHitEffect();
        }
    }

    public void onAntiMagic(MagicData playerMagicData) {
        this.m_146870_();
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_20068_() {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    private PlayState animationPredicate(AnimationState<ResonatorEntity> event) {
        int age = this.getAge();
        int maxAge = this.getMaxAge();
        if (age <= 10) {
            event.getController().setAnimation(this.PILLAR_RISE_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (age >= maxAge - 10) {
            event.getController().setAnimation(this.PILLAR_DIE_ANIMATION);
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(this.IDLE_BLANK_ANIMATION);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{this.controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private void updateEmissiveBrightness() {
        int maxAge;
        int age = this.getAge();
        if (age >= (maxAge = this.getMaxAge()) - 60) {
            double blinkCycle = Math.sin((double)age * 0.3) * 0.5 + 0.5;
            float blinkBrightness = blinkCycle > 0.5 ? 0.8f : 0.4f;
            this.setEmissiveBrightness(blinkBrightness);
        } else {
            double breathingCycle = Math.sin((double)age * 0.05) * 0.5 + 0.5;
            float breathingBrightness = (float)(0.3 + breathingCycle * 0.5);
            this.setEmissiveBrightness(breathingBrightness);
        }
    }
}

