/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.petrivise_pillar;

import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityFallingBlock;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.gametechbc.gtbcs_geomancy_plus.api.entity.IResonanceEntity;
import com.gametechbc.gtbcs_geomancy_plus.api.init.GGSchools;
import com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.resonate_pillar.ResonatePillarEntity;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEntities;
import com.gametechbc.gtbcs_geomancy_plus.init.GGSpells;
import com.gametechbc.spelllib.entity.misc.GSLScreenShakeEntity;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PetrivisePillarEntity
extends Entity
implements GeoEntity,
IResonanceEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Float> DATA_DAMAGE = SynchedEntityData.m_135353_(PetrivisePillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_AGE = SynchedEntityData.m_135353_(PetrivisePillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_WARMUP_DELAY = SynchedEntityData.m_135353_(PetrivisePillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_SLAM_DELAY = SynchedEntityData.m_135353_(PetrivisePillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_SLAM_SPEED = SynchedEntityData.m_135353_(PetrivisePillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_PILLAR_ID = SynchedEntityData.m_135353_(PetrivisePillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private UUID casterUUID;
    private LivingEntity cachedCaster;
    private boolean hasDamaged = false;
    private boolean enableScreenShake = false;
    private boolean hasSpawnedEmergeParticles = false;
    private final RawAnimation IDLE_BLANK_ANIMATION = RawAnimation.begin().thenLoop("idle_warmup");
    private final RawAnimation EMERGE_ANIMATION = RawAnimation.begin().thenPlayAndHold("petrivise_emerge");
    private final AnimationController<PetrivisePillarEntity> controller = new AnimationController((GeoAnimatable)this, "pillar_controller", 0, this::animationPredicate);

    public PetrivisePillarEntity(EntityType<? extends PetrivisePillarEntity> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
    }

    public PetrivisePillarEntity(Level level, double x, double y, double z, float yRot, int warmupDelay, int slamDelay, float slamSpeed, float damage, int pillarId, LivingEntity caster) {
        this((EntityType<? extends PetrivisePillarEntity>)((EntityType)GGEntities.PETRIVISE_PILLAR.get()), level);
        this.m_6034_(x, y, z);
        this.m_146922_(yRot);
        this.setDamage(damage);
        this.setWarmupDelay(warmupDelay);
        this.setSlamDelay(slamDelay);
        this.setSlamSpeed(slamSpeed);
        this.setPillarId(pillarId);
        this.setCaster(caster);
        this.f_19794_ = true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_AGE, (Object)0);
        this.f_19804_.m_135372_(DATA_WARMUP_DELAY, (Object)40);
        this.f_19804_.m_135372_(DATA_SLAM_DELAY, (Object)10);
        this.f_19804_.m_135372_(DATA_SLAM_SPEED, (Object)Float.valueOf(0.5f));
        this.f_19804_.m_135372_(DATA_PILLAR_ID, (Object)0);
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128350_("Damage", this.getDamage());
        tag.m_128405_("Age", this.getAge());
        tag.m_128405_("WarmupDelay", this.getWarmupDelay());
        tag.m_128405_("SlamDelay", this.getSlamDelay());
        tag.m_128350_("SlamSpeed", this.getSlamSpeed());
        tag.m_128379_("HasDamaged", this.hasDamaged);
        tag.m_128405_("PillarId", this.getPillarId());
        tag.m_128379_("EnableScreenShake", this.enableScreenShake);
        tag.m_128379_("HasSpawnedEmergeParticles", this.hasSpawnedEmergeParticles);
        if (this.casterUUID != null) {
            tag.m_128362_("Caster", this.casterUUID);
        }
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128441_("Damage")) {
            this.setDamage(tag.m_128457_("Damage"));
        }
        if (tag.m_128441_("Age")) {
            this.setAge(tag.m_128451_("Age"));
        }
        if (tag.m_128441_("WarmupDelay")) {
            this.setWarmupDelay(tag.m_128451_("WarmupDelay"));
        }
        if (tag.m_128441_("SlamDelay")) {
            this.setSlamDelay(tag.m_128451_("SlamDelay"));
        }
        if (tag.m_128441_("SlamSpeed")) {
            this.setSlamSpeed(tag.m_128457_("SlamSpeed"));
        }
        if (tag.m_128441_("HasDamaged")) {
            this.hasDamaged = tag.m_128471_("HasDamaged");
        }
        if (tag.m_128441_("PillarId")) {
            this.setPillarId(tag.m_128451_("PillarId"));
        }
        if (tag.m_128441_("EnableScreenShake")) {
            this.enableScreenShake = tag.m_128471_("EnableScreenShake");
        }
        if (tag.m_128441_("HasSpawnedEmergeParticles")) {
            this.hasSpawnedEmergeParticles = tag.m_128471_("HasSpawnedEmergeParticles");
        }
        if (tag.m_128403_("Caster")) {
            this.casterUUID = tag.m_128342_("Caster");
        }
    }

    public int getPillarId() {
        return (Integer)this.f_19804_.m_135370_(DATA_PILLAR_ID);
    }

    public void setPillarId(int id) {
        this.f_19804_.m_135381_(DATA_PILLAR_ID, (Object)id);
    }

    public int getAge() {
        return (Integer)this.f_19804_.m_135370_(DATA_AGE);
    }

    public void setAge(int age) {
        this.f_19804_.m_135381_(DATA_AGE, (Object)age);
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DATA_DAMAGE, (Object)Float.valueOf(damage));
    }

    public int getWarmupDelay() {
        return (Integer)this.f_19804_.m_135370_(DATA_WARMUP_DELAY);
    }

    public void setWarmupDelay(int delay) {
        this.f_19804_.m_135381_(DATA_WARMUP_DELAY, (Object)delay);
    }

    public int getSlamDelay() {
        return (Integer)this.f_19804_.m_135370_(DATA_SLAM_DELAY);
    }

    public void setSlamDelay(int delay) {
        this.f_19804_.m_135381_(DATA_SLAM_DELAY, (Object)delay);
    }

    public float getSlamSpeed() {
        return ((Float)this.f_19804_.m_135370_(DATA_SLAM_SPEED)).floatValue();
    }

    public void setSlamSpeed(float speed) {
        this.f_19804_.m_135381_(DATA_SLAM_SPEED, (Object)Float.valueOf(speed));
    }

    public void setCaster(@Nullable LivingEntity caster) {
        this.cachedCaster = caster;
        this.casterUUID = caster == null ? null : caster.m_20148_();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.cachedCaster == null && this.casterUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.casterUUID)) instanceof LivingEntity) {
            this.cachedCaster = (LivingEntity)entity;
        }
        return this.cachedCaster;
    }

    public boolean getEnableScreenShake() {
        return this.enableScreenShake;
    }

    public void setEnableScreenShake(boolean enable) {
        this.enableScreenShake = enable;
    }

    @Override
    public float getResonanceMultiplier() {
        return 1.0f;
    }

    @Override
    public void onResonanceShockwave(ResonatePillarEntity pillar, ResonatePillarEntity.Stage stage, LivingEntity owner, LivingEntity target, Level world, Vec3 resonancePosition, float resonanceRadius, double distanceFromSource, float baseDamage, float finalDamage) {
        IResonanceEntity.super.onResonanceShockwave(pillar, stage, owner, target, world, resonancePosition, resonanceRadius, distanceFromSource, baseDamage, finalDamage);
        Vec3 targetPosition = target.m_20182_();
        Vec3 pullDirection = resonancePosition.m_82546_(targetPosition).m_82541_();
        double maxPullStrength = 2.5;
        double stageReduction = 1.0 - (double)stage.value * 0.1;
        double distanceReduction = Math.max(0.3, 1.0 - distanceFromSource / (double)resonanceRadius);
        double pullStrength = maxPullStrength * stageReduction * distanceReduction;
        Vec3 pullMotion = new Vec3(pullDirection.f_82479_ * pullStrength, 0.2 + pullStrength * 0.1, pullDirection.f_82481_ * pullStrength);
        Vec3 currentMotion = target.m_20184_();
        target.m_20256_(currentMotion.m_82549_(pullMotion));
        target.f_19864_ = true;
    }

    @Override
    public boolean canResonateWith(ResonatePillarEntity pillar) {
        LivingEntity pillarOwner = pillar.getSummoner();
        LivingEntity thisOwner = this.getCaster();
        return pillarOwner != null && thisOwner != null && pillarOwner.m_20148_().equals(thisOwner.m_20148_());
    }

    @Override
    public Vector3f getResonanceParticleColor() {
        return ((SchoolType)GGSchools.GEO.get()).getTargetingColor();
    }

    public void m_8119_() {
        super.m_8119_();
        int currentAge = this.getAge();
        this.setAge(currentAge + 1);
        int age = this.getAge();
        int warmupDelay = this.getWarmupDelay();
        int slamDelay = this.getSlamDelay();
        int slamStartAge = warmupDelay + slamDelay;
        if (age < warmupDelay) {
            this.m_20256_(Vec3.f_82478_);
        } else if (age < slamStartAge) {
            this.m_20256_(Vec3.f_82478_);
            if (!this.hasSpawnedEmergeParticles && !this.m_9236_().f_46443_) {
                this.spawnEmergeParticles();
                this.hasSpawnedEmergeParticles = true;
            }
        } else {
            Vec3 lookDirection = this.m_20154_().m_82541_();
            Vec3 movement = lookDirection.m_82490_((double)this.getSlamSpeed());
            this.m_20256_(movement);
            this.f_19812_ = true;
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (this.m_9236_().f_46443_) {
                this.spawnBlockDiggingParticles();
            }
            if (!this.m_9236_().f_46443_) {
                this.checkForPillarCollision();
                this.applySubtlePushToNearbyEntities();
            }
        }
    }

    private void checkForPillarCollision() {
        AABB searchArea = this.m_20191_().m_82400_(1.5);
        List nearbyPillars = this.m_9236_().m_45976_(PetrivisePillarEntity.class, searchArea);
        for (PetrivisePillarEntity otherPillar : nearbyPillars) {
            if (otherPillar == this || this.getPillarId() != otherPillar.getPillarId() || this.getPillarId() == 0) continue;
            int ourAge = this.getAge();
            int theirAge = otherPillar.getAge();
            int ourSlamStartAge = this.getWarmupDelay() + this.getSlamDelay();
            int theirSlamStartAge = otherPillar.getWarmupDelay() + otherPillar.getSlamDelay();
            if (ourAge < ourSlamStartAge || theirAge < theirSlamStartAge) continue;
            this.dealCollisionDamage();
            this.customRemove();
            otherPillar.customRemove();
            break;
        }
    }

    private void dealCollisionDamage() {
        AABB damageArea = this.m_20191_().m_82400_(1.5);
        List targets = this.m_9236_().m_45976_(LivingEntity.class, damageArea);
        LivingEntity caster = this.getCaster();
        for (LivingEntity target : targets) {
            if (target == caster || !target.m_6084_() || target.m_20147_() || caster != null && (caster.m_7307_((Entity)target) || target.m_7307_((Entity)caster))) continue;
            DamageSources.applyDamage((Entity)target, (float)this.getDamage(), (DamageSource)((AbstractSpell)GGSpells.PETRIVISE_SPELL.get()).getDamageSource((Entity)this, (Entity)caster));
        }
        if (this.enableScreenShake) {
            GSLScreenShakeEntity.createScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)24.0f, (float)0.03f, (int)15, (int)0, (int)5, (boolean)false);
            this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_LARGE_1.get(), 4.0f, 1.0f);
        }
    }

    private void applySubtlePushToNearbyEntities() {
        int slamStartAge;
        int age = this.getAge();
        if (age < (slamStartAge = this.getWarmupDelay() + this.getSlamDelay())) {
            return;
        }
        AABB pushArea = this.m_20191_().m_82400_(1.5);
        List nearbyEntities = this.m_9236_().m_45976_(LivingEntity.class, pushArea);
        LivingEntity caster = this.getCaster();
        Vec3 pillarDirection = this.m_20154_().m_82541_();
        for (LivingEntity entity : nearbyEntities) {
            if (entity == caster || !entity.m_6084_() || caster != null && (caster.m_7307_((Entity)entity) || entity.m_7307_((Entity)caster))) continue;
            Vec3 currentMotion = entity.m_20184_();
            double pushStrength = 0.05;
            Vec3 pushForce = pillarDirection.m_82490_(pushStrength);
            Vec3 horizontalPush = new Vec3(pushForce.f_82479_, 0.0, pushForce.f_82481_);
            Vec3 newMotion = currentMotion.m_82549_(horizontalPush);
            entity.m_20256_(newMotion);
            entity.f_19812_ = true;
        }
    }

    private void spawnEmergeParticles() {
        AABB boundingBox = this.m_20191_();
        for (int i = 0; i < 10; ++i) {
            double d0 = boundingBox.f_82288_ + this.f_19796_.m_188500_() * (boundingBox.f_82291_ - boundingBox.f_82288_);
            double d1 = boundingBox.f_82289_ + this.f_19796_.m_188500_() * (boundingBox.f_82292_ - boundingBox.f_82289_);
            double d2 = boundingBox.f_82290_ + this.f_19796_.m_188500_() * (boundingBox.f_82293_ - boundingBox.f_82290_);
            double d3 = (this.f_19796_.m_188500_() - 0.5) * 0.3;
            double d4 = this.f_19796_.m_188500_() * 0.3 + 0.1;
            double d5 = (this.f_19796_.m_188500_() - 0.5) * 0.3;
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50752_.m_49966_()), (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.03, (boolean)false);
        }
    }

    private void spawnBlockDiggingParticles() {
        double vZ;
        double vY;
        double vX;
        int i;
        BlockState block = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
        if (block.m_60799_() == RenderShape.INVISIBLE) {
            return;
        }
        Vec3 direction = this.m_20154_().m_82541_();
        for (i = 0; i < 1; ++i) {
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.35;
            double d1 = this.m_20186_() + 0.02;
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.35;
            double d3 = this.f_19796_.m_188583_() * 0.06;
            double d4 = this.f_19796_.m_188583_() * 0.09;
            double d5 = this.f_19796_.m_188583_() * 0.06;
            this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), d0, d1, d2, d3, d4, d5);
        }
        for (i = 0; i < 1; ++i) {
            double backX = this.m_20185_() - direction.f_82479_ * 0.55 + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 0.45;
            double backY = this.m_20186_() + 0.06;
            double backZ = this.m_20189_() - direction.f_82481_ * 0.55 + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 0.45;
            vX = direction.f_82479_ * -0.13 + this.f_19796_.m_188583_() * 0.045;
            vY = this.f_19796_.m_188583_() * 0.08;
            vZ = direction.f_82481_ * -0.13 + this.f_19796_.m_188583_() * 0.045;
            this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), backX, backY, backZ, vX, vY, vZ);
        }
        for (i = 0; i < 1; ++i) {
            double frontX = this.m_20185_() + direction.f_82479_ * 0.78 + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 0.38;
            double frontY = this.m_20186_() + 0.08;
            double frontZ = this.m_20189_() + direction.f_82481_ * 0.78 + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 0.38;
            vX = direction.f_82479_ * 0.2 + this.f_19796_.m_188583_() * 0.03;
            vY = this.f_19796_.m_188583_() * 0.08;
            vZ = direction.f_82481_ * 0.2 + this.f_19796_.m_188583_() * 0.03;
            this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), frontX, frontY, frontZ, vX, vY, vZ);
        }
    }

    private void spawnDiscardBlast() {
        double d5;
        double d4;
        double d3;
        double d2;
        double d1;
        double d0;
        int i;
        AABB boundingBox = this.m_20191_();
        Vec3 center = boundingBox.m_82399_();
        for (i = 0; i < 30; ++i) {
            d0 = boundingBox.f_82288_ + this.f_19796_.m_188500_() * (boundingBox.f_82291_ - boundingBox.f_82288_);
            d1 = boundingBox.f_82289_ + this.f_19796_.m_188500_() * (boundingBox.f_82292_ - boundingBox.f_82289_);
            d2 = boundingBox.f_82290_ + this.f_19796_.m_188500_() * (boundingBox.f_82293_ - boundingBox.f_82290_);
            d3 = (this.f_19796_.m_188500_() - 0.5) * 2.5;
            d4 = this.f_19796_.m_188500_() * 1.8 + 0.4;
            d5 = (this.f_19796_.m_188500_() - 0.5) * 2.5;
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50752_.m_49966_()), (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.08, (boolean)false);
        }
        for (i = 0; i < 25; ++i) {
            d0 = center.f_82479_ + (this.f_19796_.m_188500_() - 0.5) * 1.5;
            d1 = center.f_82480_ + this.f_19796_.m_188500_() * 1.2;
            d2 = center.f_82481_ + (this.f_19796_.m_188500_() - 0.5) * 1.5;
            d3 = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            d4 = this.f_19796_.m_188500_() * 1.5 + 0.3;
            d5 = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50652_.m_49966_()), (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.06, (boolean)false);
        }
        for (i = 0; i < 20; ++i) {
            d0 = center.f_82479_ + (this.f_19796_.m_188500_() - 0.5) * 0.8;
            d1 = center.f_82480_ + this.f_19796_.m_188500_() * 0.8;
            d2 = center.f_82481_ + (this.f_19796_.m_188500_() - 0.5) * 0.8;
            d3 = (this.f_19796_.m_188500_() - 0.5) * 3.0;
            d4 = this.f_19796_.m_188500_() * 2.0 + 0.5;
            d5 = (this.f_19796_.m_188500_() - 0.5) * 3.0;
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50069_.m_49966_()), (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.1, (boolean)false);
        }
        for (i = 0; i < 3; ++i) {
            d0 = center.f_82479_ + (this.f_19796_.m_188500_() - 0.5) * 2.0;
            d1 = center.f_82480_ + this.f_19796_.m_188500_() * 1.5;
            d2 = center.f_82481_ + (this.f_19796_.m_188500_() - 0.5) * 2.0;
            d3 = this.f_19796_.m_188500_() - 0.5;
            d4 = this.f_19796_.m_188500_() * 0.8 + 0.2;
            d5 = this.f_19796_.m_188500_() - 0.5;
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)ParticleTypes.f_123777_, (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.05, (boolean)false);
        }
    }

    private void spawnFallingBlockRemnant() {
        double randomX = (this.f_19796_.m_188500_() - 0.5) * 1.5;
        double randomY = this.f_19796_.m_188500_() * 0.8 + 0.3;
        double randomZ = (this.f_19796_.m_188500_() - 0.5) * 1.5;
        int duration = 80 + this.f_19796_.m_188503_(41);
        EntityFallingBlock fallingBlock = new EntityFallingBlock((EntityType)EntityHandler.FALLING_BLOCK.get(), this.m_9236_(), duration, Blocks.f_50752_.m_49966_());
        AABB boundingBox = this.m_20191_();
        Vec3 center = boundingBox.m_82399_();
        fallingBlock.m_6034_(center.f_82479_, center.f_82480_, center.f_82481_);
        fallingBlock.m_20334_(randomX, randomY, randomZ);
        this.m_9236_().m_7967_((Entity)fallingBlock);
    }

    public void customRemove() {
        if (!this.m_9236_().f_46443_) {
            this.spawnDiscardBlast();
            this.spawnFallingBlockRemnant();
        }
        this.m_146870_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private PlayState animationPredicate(AnimationState<PetrivisePillarEntity> event) {
        int warmupDelay;
        int age = this.getAge();
        if (age < (warmupDelay = this.getWarmupDelay())) {
            event.getController().setAnimation(this.IDLE_BLANK_ANIMATION);
        } else {
            event.getController().setAnimation(this.EMERGE_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{this.controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return true;
    }
}

