/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.dripstone_bolt;

import com.gametechbc.gtbcs_geomancy_plus.api.init.GGSchools;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEntities;
import com.gametechbc.gtbcs_geomancy_plus.init.GGSpells;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DripstoneBoltEntity
extends AbstractMagicProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE_LOOP_ANIM = RawAnimation.begin().thenLoop("traveling_loop");
    private final AnimationController<DripstoneBoltEntity> controller = new AnimationController((GeoAnimatable)this, "stone_controller", 0, this::animationPredicate);

    public DripstoneBoltEntity(EntityType<? extends DripstoneBoltEntity> entityType, Level level) {
        super(entityType, level);
        this.m_20242_(true);
    }

    public DripstoneBoltEntity(EntityType<? extends DripstoneBoltEntity> entityType, Level levelIn, LivingEntity shooter) {
        this(entityType, levelIn);
        this.m_5602_((Entity)shooter);
    }

    public DripstoneBoltEntity(Level levelIn, LivingEntity shooter) {
        this((EntityType<? extends DripstoneBoltEntity>)((EntityType)GGEntities.DRIPSTONE_BOLT.get()), levelIn, shooter);
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        Vec3 hitPos = blockHitResult.m_82450_();
        this.applyAOEDamage(hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_);
        this.m_146870_();
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        DamageSources.applyDamage((Entity)entityHitResult.m_82443_(), (float)this.getDamage(), (DamageSource)((AbstractSpell)GGSpells.DRIPSTONE_BOLT.get()).getDamageSource((Entity)this, this.m_19749_()));
        Vec3 hitPos = entityHitResult.m_82450_();
        this.applyAOEDamage(hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_);
        this.m_146870_();
    }

    private void applyAOEDamage(double x, double y, double z) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        Entity owner = this.m_19749_();
        float radius = 2.0f;
        AABB aoeRegion = new AABB(x - (double)radius, y - (double)radius, z - (double)radius, x + (double)radius, y + (double)radius, z + (double)radius);
        List nearbyEntities = this.m_9236_().m_6249_((Entity)this, aoeRegion, entity -> entity instanceof LivingEntity);
        for (Entity entity2 : nearbyEntities) {
            if (entity2 == owner || !(entity2 instanceof LivingEntity)) continue;
            DamageSources.applyDamage((Entity)entity2, (float)(this.getDamage() * 0.5f), (DamageSource)((AbstractSpell)GGSpells.DRIPSTONE_BOLT.get()).getDamageSource((Entity)this, owner));
        }
        MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)GGSchools.GEO.get()).getTargetingColor(), radius), (double)this.m_20185_(), (double)(this.m_20186_() + (double)0.1f), (double)this.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
    }

    public void impactParticles(double x, double y, double z) {
        MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_152537_.m_49966_()), (double)x, (double)y, (double)z, (int)25, (double)0.0, (double)0.0, (double)0.0, (double)0.18, (boolean)true);
    }

    public void trailParticles() {
        for (int i = 0; i < 2; ++i) {
            double speed = 0.02;
            double dx = Utils.random.m_188500_() * 2.0 * speed - speed;
            double dy = Utils.random.m_188500_() * 2.0 * speed - speed;
            double dz = Utils.random.m_188500_() * 2.0 * speed - speed;
            this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_152537_.m_49966_()), this.m_20185_() + dx, this.m_20186_() + dy, this.m_20189_() + dz, dx, dy, dz);
            if (this.f_19797_ <= 1) continue;
            this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_152537_.m_49966_()), this.m_20185_() + dx - this.m_20184_().f_82479_ / 2.0, this.m_20186_() + dy - this.m_20184_().f_82480_ / 2.0, this.m_20189_() + dz - this.m_20184_().f_82481_ / 2.0, dx, dy, dz);
        }
    }

    public float getSpeed() {
        return 2.5f;
    }

    public Optional<SoundEvent> getImpactSound() {
        return Optional.of(SoundEvents.f_144124_);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{this.controller});
    }

    private PlayState animationPredicate(AnimationState<DripstoneBoltEntity> state) {
        state.getController().setAnimation(IDLE_LOOP_ANIM);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

