/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.api.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.item.curios.CurioBaseItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;

public abstract class AdvancedSchoolEchoCurio
extends CurioBaseItem {
    private final Multimap<Attribute, AttributeModifier> attributeMap = HashMultimap.create();
    private static final int EXPERIENCE_COST = 180;

    public AdvancedSchoolEchoCurio(Item.Properties properties, Map<Attribute, AttributeModifier> attributes) {
        super(properties.m_41487_(1).m_41497_(Rarity.EPIC));
        for (Map.Entry<Attribute, AttributeModifier> entry : attributes.entrySet()) {
            this.attributeMap.put((Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    protected abstract RegistryObject<SchoolType> getSchool();

    protected abstract Component getAssignedHoverText();

    protected abstract Component getUnassignedHoverText();

    protected abstract SchoolSpellConfig getSchoolSpellConfig();

    protected SoundEvent getAssignSound() {
        SchoolType school = (SchoolType)this.getSchool().get();
        return school.getCastSound();
    }

    protected int selectLevel(AbstractSpell spell, float quality, boolean prioritizeLowerLevel) {
        int maxLevel = spell.getMaxLevel();
        if (!prioritizeLowerLevel) {
            return 1 + Math.round(quality * (float)(maxLevel - 1));
        }
        double adjustedQuality = Math.pow(quality, 0.5);
        int calculatedLevel = 1 + Math.round((float)(adjustedQuality * (double)(maxLevel - 1)));
        return Math.min(calculatedLevel, maxLevel + Math.round((quality - 1.0f) * (float)maxLevel));
    }

    protected float generateBiasedQuality(float qualityMin, float qualityMax, float bias) {
        Random random = new Random();
        float baseQuality = random.nextFloat();
        float biasedQuality = bias <= 0.5f ? (float)Math.pow(baseQuality, 1.0f / bias) : (bias < 1.0f ? (float)Math.pow(baseQuality, 2.0f - bias) : (bias == 1.0f ? baseQuality : (float)Math.pow(baseQuality, bias)));
        return qualityMin + biasedQuality * (qualityMax - qualityMin);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        AbstractSpell selectedSpell;
        ItemStack stack = player.m_21120_(hand);
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("spellAssigned")) {
            player.m_5661_((Component)Component.m_237115_((String)"item.traveloptics.spell_imbuing_curio.already_assigned.message").m_130940_(ChatFormatting.RED), true);
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (player.f_36079_ < 180) {
            player.m_5661_((Component)Component.m_237115_((String)"item.traveloptics.spell_imbuing_curio.not_enough_xp.message").m_130940_(ChatFormatting.RED), true);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        List<AbstractSpell> schoolSpells = this.getSpellsFromSchool(player);
        if (!schoolSpells.isEmpty() && (selectedSpell = this.selectWeightedRandomSpell(schoolSpells)) != null) {
            SchoolSpellConfig config = this.getSchoolSpellConfig();
            SpellOverride override = config.spellOverrides.get(selectedSpell);
            float qualityMin = override != null ? override.qualityMin : config.qualityMin;
            float qualityMax = override != null ? override.qualityMax : config.qualityMax;
            boolean prioritizeLowerLevel = override != null ? override.prioritizeLowerLevel : config.prioritizeLowerLevel;
            float quality = override != null && (override.qualityMin > 0.0f || override.qualityMax < 1.0f) ? qualityMin + new Random().nextFloat() * (qualityMax - qualityMin) : this.generateBiasedQuality(qualityMin, qualityMax, config.qualityBias);
            int levelOfSpell = this.selectLevel(selectedSpell, quality, prioritizeLowerLevel);
            ISpellContainer spellContainer = ISpellContainer.create((int)1, (boolean)true, (boolean)true);
            spellContainer.addSpell(selectedSpell, levelOfSpell, true, stack);
            spellContainer.save(stack);
            tag.m_128379_("spellAssigned", true);
            player.m_6756_(-180);
            level.m_5594_(null, player.m_20183_(), this.getAssignSound(), player.m_5720_(), 1.0f, 1.0f);
            if (!level.f_46443_) {
                player.m_5661_((Component)Component.m_237110_((String)"item.traveloptics.spell_imbuing_curio.success", (Object[])new Object[]{selectedSpell.getDisplayName(null)}).m_130940_(ChatFormatting.GREEN), true);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("spellAssigned")) {
            tooltip.add(this.getAssignedHoverText());
        } else {
            tooltip.add(this.getUnassignedHoverText());
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.random_imbue_curio.ex_required.tooltip").m_130940_(ChatFormatting.AQUA));
        }
    }

    private List<AbstractSpell> getSpellsFromSchool(Player player) {
        SchoolType school = (SchoolType)this.getSchool().get();
        SchoolSpellConfig config = this.getSchoolSpellConfig();
        return SpellRegistry.getEnabledSpells().stream().filter(spell -> spell.getSchoolType() == school).filter(spell -> {
            SpellOverride override = config.spellOverrides.get(spell);
            if (override != null && override.exclude) {
                return false;
            }
            return !config.excludedSpells.contains(spell);
        }).filter(spell -> {
            boolean shouldIgnoreCraftDisable;
            boolean shouldIgnoreLootDisable;
            SpellOverride override = config.spellOverrides.get(spell);
            boolean bl = shouldIgnoreLootDisable = override != null ? override.ignoreLootDisable : config.ignoreLootDisable;
            if (!shouldIgnoreLootDisable && !spell.allowLooting()) {
                return false;
            }
            boolean bl2 = shouldIgnoreCraftDisable = override != null ? override.ignoreCraftDisable : config.ignoreCraftDisable;
            return shouldIgnoreCraftDisable || spell.allowCrafting();
        }).collect(Collectors.toList());
    }

    private AbstractSpell selectWeightedRandomSpell(List<AbstractSpell> schoolSpells) {
        SchoolSpellConfig config = this.getSchoolSpellConfig();
        int totalWeight = 0;
        for (AbstractSpell spell : schoolSpells) {
            SpellOverride override = config.spellOverrides.get(spell);
            int weight = override != null && override.useCustomWeight ? override.weight : (config.useRarityBasedWeighting ? this.getWeightFromRarity(SpellRarity.values()[spell.getMinRarity()]) : config.defaultWeight);
            totalWeight += weight;
        }
        if (totalWeight <= 0) {
            return null;
        }
        int randomWeight = new Random().nextInt(totalWeight);
        for (AbstractSpell spell : schoolSpells) {
            SpellOverride override = config.spellOverrides.get(spell);
            int weight = override != null && override.useCustomWeight ? override.weight : (config.useRarityBasedWeighting ? this.getWeightFromRarity(SpellRarity.values()[spell.getMinRarity()]) : config.defaultWeight);
            if ((randomWeight -= weight) >= 0) continue;
            return spell;
        }
        return null;
    }

    private int getWeightFromRarity(SpellRarity rarity) {
        return switch (rarity) {
            default -> throw new IncompatibleClassChangeError();
            case SpellRarity.COMMON -> 40;
            case SpellRarity.UNCOMMON -> 30;
            case SpellRarity.RARE -> 15;
            case SpellRarity.EPIC -> 8;
            case SpellRarity.LEGENDARY -> 4;
        };
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        ImmutableMultimap.Builder attributeBuilder = new ImmutableMultimap.Builder();
        for (Attribute attribute : this.attributeMap.keySet()) {
            for (AttributeModifier modifier : this.attributeMap.get((Object)attribute)) {
                attributeBuilder.put((Object)attribute, (Object)new AttributeModifier(uuid, modifier.m_22214_(), modifier.m_22218_(), modifier.m_22217_()));
            }
        }
        return attributeBuilder.build();
    }

    public static class SchoolSpellConfig {
        public final int defaultWeight;
        public final boolean prioritizeLowerLevel;
        public final float qualityMin;
        public final float qualityMax;
        public final boolean ignoreLootDisable;
        public final boolean ignoreCraftDisable;
        public final Set<AbstractSpell> excludedSpells;
        public final Map<AbstractSpell, SpellOverride> spellOverrides;
        public final boolean useRarityBasedWeighting;
        public final float qualityBias;

        public SchoolSpellConfig(int defaultWeight, boolean prioritizeLowerLevel, float qualityMin, float qualityMax) {
            this(defaultWeight, prioritizeLowerLevel, qualityMin, qualityMax, false, false, new HashSet<AbstractSpell>(), new HashMap<AbstractSpell, SpellOverride>(), true, 1.0f);
        }

        public SchoolSpellConfig(int defaultWeight, boolean prioritizeLowerLevel, float qualityMin, float qualityMax, boolean ignoreLootDisable, boolean ignoreCraftDisable) {
            this(defaultWeight, prioritizeLowerLevel, qualityMin, qualityMax, ignoreLootDisable, ignoreCraftDisable, new HashSet<AbstractSpell>(), new HashMap<AbstractSpell, SpellOverride>(), true, 1.0f);
        }

        public SchoolSpellConfig(int defaultWeight, boolean prioritizeLowerLevel, float qualityMin, float qualityMax, boolean ignoreLootDisable, boolean ignoreCraftDisable, Set<AbstractSpell> excludedSpells) {
            this(defaultWeight, prioritizeLowerLevel, qualityMin, qualityMax, ignoreLootDisable, ignoreCraftDisable, excludedSpells, new HashMap<AbstractSpell, SpellOverride>(), true, 1.0f);
        }

        public SchoolSpellConfig(int defaultWeight, boolean prioritizeLowerLevel, float qualityMin, float qualityMax, boolean ignoreLootDisable, boolean ignoreCraftDisable, Set<AbstractSpell> excludedSpells, Map<AbstractSpell, SpellOverride> spellOverrides) {
            this(defaultWeight, prioritizeLowerLevel, qualityMin, qualityMax, ignoreLootDisable, ignoreCraftDisable, excludedSpells, spellOverrides, true, 1.0f);
        }

        public SchoolSpellConfig(int defaultWeight, boolean prioritizeLowerLevel, float qualityMin, float qualityMax, boolean ignoreLootDisable, boolean ignoreCraftDisable, Set<AbstractSpell> excludedSpells, Map<AbstractSpell, SpellOverride> spellOverrides, boolean useRarityBasedWeighting, float qualityBias) {
            this.defaultWeight = defaultWeight;
            this.prioritizeLowerLevel = prioritizeLowerLevel;
            this.qualityMin = qualityMin;
            this.qualityMax = qualityMax;
            this.ignoreLootDisable = ignoreLootDisable;
            this.ignoreCraftDisable = ignoreCraftDisable;
            this.excludedSpells = excludedSpells != null ? excludedSpells : new HashSet();
            this.spellOverrides = spellOverrides != null ? spellOverrides : new HashMap();
            this.useRarityBasedWeighting = useRarityBasedWeighting;
            this.qualityBias = qualityBias;
        }
    }

    public static class SpellOverride {
        public final int weight;
        public final boolean prioritizeLowerLevel;
        public final float qualityMin;
        public final float qualityMax;
        public final boolean exclude;
        public final boolean ignoreLootDisable;
        public final boolean ignoreCraftDisable;
        public final boolean useCustomWeight;

        public SpellOverride(int weight, boolean prioritizeLowerLevel, float qualityMin, float qualityMax) {
            this(weight, prioritizeLowerLevel, qualityMin, qualityMax, false, false, false, true);
        }

        public SpellOverride(boolean exclude) {
            this(0, false, 0.0f, 0.0f, exclude, false, false, false);
        }

        public SpellOverride(int weight, boolean prioritizeLowerLevel, float qualityMin, float qualityMax, boolean ignoreLootDisable, boolean ignoreCraftDisable) {
            this(weight, prioritizeLowerLevel, qualityMin, qualityMax, false, ignoreLootDisable, ignoreCraftDisable, true);
        }

        public SpellOverride(int weight, boolean prioritizeLowerLevel, float qualityMin, float qualityMax, boolean exclude, boolean ignoreLootDisable, boolean ignoreCraftDisable, boolean useCustomWeight) {
            this.weight = weight;
            this.prioritizeLowerLevel = prioritizeLowerLevel;
            this.qualityMin = qualityMin;
            this.qualityMax = qualityMax;
            this.exclude = exclude;
            this.ignoreLootDisable = ignoreLootDisable;
            this.ignoreCraftDisable = ignoreCraftDisable;
            this.useCustomWeight = useCustomWeight;
        }
    }
}

