/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.util;

import com.cstav.genshinstrument.GInstrumentMod;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public abstract class CommonUtil {
    public static List<Player> getPlayersInArea(Level level, AABB area) {
        ArrayList list = Lists.newArrayList();
        for (Player player : level.m_6907_()) {
            if (!area.m_82393_(player.m_20185_(), player.m_20186_(), player.m_20189_())) continue;
            list.add(player);
        }
        return list;
    }

    public static ResourceLocation getResourceFrom(ResourceLocation dir, String path) {
        return new ResourceLocation(dir.m_135827_(), dir.m_135815_() + "/" + path);
    }

    public static <T> Constructor<T> getExpectedConstructor(Class<T> clazz, Class<?> ... paramTypes) {
        try {
            return clazz.getDeclaredConstructor(paramTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not find a matching constructor for " + clazz.getName(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting constructor for " + clazz.getName(), e);
        }
    }

    public static int pyWrap(int index, int arrLength) {
        while (index < 0) {
            index += arrLength;
        }
        return index;
    }

    public static int wrapAround(int index, int arrLength) {
        return index % arrLength;
    }

    public static int doublyPyWrap(int index, int arrLength) {
        return CommonUtil.wrapAround(CommonUtil.pyWrap(index, arrLength), arrLength);
    }

    public static void loadClasses(Class<?>[] classes) {
        for (Class<?> loadMe : classes) {
            try {
                Class.forName(loadMe.getName());
            }
            catch (ClassNotFoundException e) {
                GInstrumentMod.LOGGER.error("Failed to load class " + loadMe.getSimpleName() + ": class not found", (Throwable)e);
            }
        }
    }

    public static double round(double value, int places) {
        return BigDecimal.valueOf(value).setScale(places, RoundingMode.HALF_UP).doubleValue();
    }
}

