/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.sound;

import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.sound.held.HeldNoteSound;
import com.cstav.genshinstrument.sound.registrar.HeldNoteSoundRegistrar;
import com.cstav.genshinstrument.sound.registrar.NoteSoundRegistrar;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class GISounds {
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"genshinstrument");
    public static final NoteSound[] WINDSONG_LYRE_NOTE_SOUNDS = GISounds.nsr(GISounds.loc("windsong_lyre")).stereo().registerGrid();
    public static final NoteSound[] VINTAGE_LYRE_NOTE_SOUNDS = GISounds.nsr(GISounds.loc("vintage_lyre")).registerGrid();
    public static final NoteSound[] ZITHER_NEW_NOTE_SOUNDS = GISounds.nsr(GISounds.loc("floral_zither_new")).registerGrid();
    public static final NoteSound[] ZITHER_OLD_NOTE_SOUNDS = GISounds.nsr(GISounds.loc("floral_zither_old")).registerGrid();
    public static final NoteSound[] GLORIOUS_DRUM = (NoteSound[])((NoteSoundRegistrar)GISounds.nsr(GISounds.loc("glorious_drum")).chain(GISounds.loc("glorious_drum_don")).add()).chain(GISounds.loc("glorious_drum_ka")).stereo().add().registerAll();
    public static final NoteSound[] UKULELE = GISounds.nsr(GISounds.loc("ukulele")).registerGrid();
    public static final NoteSound[] DJEM_DJEM_DRUM = GISounds.nsr(GISounds.loc("djem_djem_drum")).registerGrid(2, 4);
    private static final float WINDSONG_HOLD_DURATION = 3.0f;
    private static final float WINDSONG_FADE_TIME = 0.25f;
    public static final HeldNoteSound[] NIGHTWIND_HORN = GISounds.hnsr(GISounds.loc("nightwind_horn")).holdBuilder(GISounds::nightwindSoundBuilder).attackBuilder(GISounds::nightwindSoundBuilder).holdDelay(0.03f).chainedHoldDelay(-0.5f).releaseFadeOut(0.025f).fullHoldFadeoutTime(2.0f).decays(7.0f).register(3.0f);

    public static void register(IEventBus bus) {
        SOUNDS.register(bus);
    }

    private static NoteSound[] nightwindSoundBuilder(NoteSoundRegistrar builder) {
        return builder.stereo().registerGrid(7, 2);
    }

    private static ResourceLocation loc(String name) {
        return new ResourceLocation("genshinstrument", name);
    }

    private static NoteSoundRegistrar nsr(ResourceLocation instrumentId) {
        return new NoteSoundRegistrar(SOUNDS, instrumentId);
    }

    private static HeldNoteSoundRegistrar hnsr(ResourceLocation instrumentId) {
        return new HeldNoteSoundRegistrar(SOUNDS, instrumentId);
    }
}

